/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class UsePortalCommand {
    private static final int NETHER_SCALE = 8;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"useportal").requires(source -> source.method_9259(2))).executes(UsePortalCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        String targetName;
        double targetZ;
        double targetY;
        double targetX;
        class_3218 targetWorld;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_5321 currentDimension = player.method_37908().method_27983();
        if (currentDimension == class_1937.field_25179) {
            targetWorld = source.method_9211().method_3847(class_1937.field_25180);
            targetX = player.method_23317() / 8.0;
            targetY = Math.min(Math.max(player.method_23318(), 4.0), 120.0);
            targetZ = player.method_23321() / 8.0;
            targetName = "the Nether";
        } else if (currentDimension == class_1937.field_25180) {
            targetWorld = source.method_9211().method_3847(class_1937.field_25179);
            targetX = player.method_23317() * 8.0;
            targetY = player.method_23318();
            targetZ = player.method_23321() * 8.0;
            targetName = "the Overworld";
        } else {
            targetWorld = source.method_9211().method_3847(class_1937.field_25179);
            targetX = player.method_23317();
            targetY = player.method_23318();
            targetZ = player.method_23321();
            targetName = "the Overworld";
        }
        if (targetWorld == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Target dimension not available").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_2338 targetPos = new class_2338((int)targetX, (int)targetY, (int)targetZ);
        targetY = UsePortalCommand.findSafeY(targetWorld, targetPos);
        player.method_14251(targetWorld, targetX, targetY, targetZ, player.method_36454(), player.method_36455());
        String finalTargetName = targetName;
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)("Teleported to " + finalTargetName)).method_27692(class_124.field_1076), false);
        }
        return 1;
    }

    private static double findSafeY(class_3218 world, class_2338 pos) {
        class_2338 check;
        int i;
        int y = pos.method_10264();
        for (i = 0; i < 20; ++i) {
            check = new class_2338(pos.method_10263(), y + i, pos.method_10260());
            if (!UsePortalCommand.isSafe(world, check)) continue;
            return y + i;
        }
        for (i = 1; i < 20; ++i) {
            check = new class_2338(pos.method_10263(), y - i, pos.method_10260());
            if (!UsePortalCommand.isSafe(world, check)) continue;
            return y - i;
        }
        return y;
    }

    private static boolean isSafe(class_3218 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215() && !world.method_8320(pos.method_10074()).method_26215();
    }
}

