/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.inventory;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.util.ChestHelper;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DropStoreCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dropstore").requires(source -> source.method_9259(2))).executes(DropStoreCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_1799 stack;
        int i;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        ArrayList<class_1799> itemsToStore = new ArrayList<class_1799>();
        ArrayList<Integer> mainSlots = new ArrayList<Integer>();
        ArrayList<Integer> armorSlots = new ArrayList<Integer>();
        boolean hasOffhand = false;
        for (i = 0; i < player.method_31548().field_7547.size(); ++i) {
            stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7960()) continue;
            itemsToStore.add(stack.method_7972());
            mainSlots.add(i);
        }
        for (i = 0; i < player.method_31548().field_7548.size(); ++i) {
            stack = (class_1799)player.method_31548().field_7548.get(i);
            if (stack.method_7960()) continue;
            itemsToStore.add(stack.method_7972());
            armorSlots.add(i);
        }
        class_1799 offhand = (class_1799)player.method_31548().field_7544.get(0);
        if (!offhand.method_7960()) {
            itemsToStore.add(offhand.method_7972());
            hasOffhand = true;
        }
        if (itemsToStore.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Inventory is empty").method_27692(class_124.field_1080), false);
            return 0;
        }
        int stackCount = itemsToStore.size();
        ChestHelper.ChestResult chest = ChestHelper.findOrCreateChest(player, stackCount);
        if (chest == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No valid position found for chest").method_27692(class_124.field_1061), false);
            return 0;
        }
        int chestSlot = 0;
        for (class_1799 item : itemsToStore) {
            if (chestSlot >= chest.inventory.method_5439()) continue;
            chest.inventory.method_5447(chestSlot, item);
            ++chestSlot;
        }
        Iterator iterator = mainSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            player.method_31548().field_7547.set(slot, (Object)class_1799.field_8037);
        }
        iterator = armorSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            player.method_31548().field_7548.set(slot, (Object)class_1799.field_8037);
        }
        if (hasOffhand) {
            player.method_31548().field_7544.set(0, (Object)class_1799.field_8037);
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            int count = itemsToStore.size();
            boolean isDouble = chest.isDouble;
            source.method_9226(() -> class_2561.method_43470((String)"Stored ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" items in " + (isDouble ? "double " : "") + "chest at ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("(" + chest.primaryPos.method_10263() + ", " + chest.primaryPos.method_10264() + ", " + chest.primaryPos.method_10260() + ")")).method_27692(class_124.field_1068)), false);
        }
        return itemsToStore.size();
    }
}

