/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.inventory;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.util.ChestHelper;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DuplicateCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"duplicate").requires(source -> source.method_9259(2))).executes(DuplicateCommand::executeHeld)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(DuplicateCommand::executeAll)).then(class_2170.method_9247((String)"store").executes(DuplicateCommand::executeAllStore)))).then(class_2170.method_9247((String)"store").executes(DuplicateCommand::executeHeldStore)));
    }

    private static int executeHeld(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7960()) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not holding anything").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_1799 duplicate = heldItem.method_7972();
        if (!player.method_31548().method_7394(duplicate)) {
            DuplicateCommand.dropItem(player, duplicate);
            if (!PlayerStateManager.isHideResponses(player.method_5667())) {
                source.method_9226(() -> class_2561.method_43470((String)"Duplicated ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(heldItem.method_7947() + "x ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)heldItem.method_7964().getString()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (dropped - inventory full)").method_27692(class_124.field_1054)), false);
            }
        } else if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Duplicated ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(heldItem.method_7947() + "x ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)heldItem.method_7964().getString()).method_27692(class_124.field_1075)), false);
        }
        return 1;
    }

    private static int executeAll(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        int duplicated = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960()) continue;
            class_1799 duplicate = stack.method_7972();
            DuplicateCommand.dropItem(player, duplicate);
            ++duplicated;
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            int count = duplicated;
            source.method_9226(() -> class_2561.method_43470((String)"Duplicated ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" item stacks (dropped on ground)").method_27692(class_124.field_1060)), false);
        }
        return duplicated;
    }

    private static int executeHeldStore(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7960()) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not holding anything").method_27692(class_124.field_1061), false);
            return 0;
        }
        ChestHelper.ChestResult chest = ChestHelper.findOrCreateChest(player, 1);
        if (chest == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Could not create chest").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_1799 duplicate = heldItem.method_7972();
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        items.add(duplicate);
        ChestHelper.dropOverflow(player.method_37908(), chest.primaryPos, items, chest.inventory);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Duplicated and stored ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)heldItem.method_7964().getString()).method_27692(class_124.field_1075)), false);
        }
        return 1;
    }

    private static int executeAllStore(CommandContext<class_2168> context) {
        class_1799 stack;
        int i;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        ArrayList<class_1799> itemsToDuplicate = new ArrayList<class_1799>();
        for (i = 0; i < player.method_31548().field_7547.size(); ++i) {
            stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7960()) continue;
            itemsToDuplicate.add(stack.method_7972());
        }
        for (i = 0; i < player.method_31548().field_7548.size(); ++i) {
            stack = (class_1799)player.method_31548().field_7548.get(i);
            if (stack.method_7960()) continue;
            itemsToDuplicate.add(stack.method_7972());
        }
        class_1799 offhand = (class_1799)player.method_31548().field_7544.get(0);
        if (!offhand.method_7960()) {
            itemsToDuplicate.add(offhand.method_7972());
        }
        if (itemsToDuplicate.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Inventory is empty").method_27692(class_124.field_1080), false);
            return 0;
        }
        int stackCount = itemsToDuplicate.size();
        ChestHelper.ChestResult chest = ChestHelper.findOrCreateChest(player, stackCount);
        if (chest == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Could not create chest").method_27692(class_124.field_1061), false);
            return 0;
        }
        int stored = 0;
        int chestSlot = 0;
        for (class_1799 item : itemsToDuplicate) {
            if (chestSlot < chest.inventory.method_5439()) {
                chest.inventory.method_5447(chestSlot, item.method_7972());
                ++chestSlot;
                ++stored;
                continue;
            }
            class_1542 itemEntity = new class_1542(player.method_37908(), (double)chest.primaryPos.method_10263() + 0.5, (double)(chest.primaryPos.method_10264() + 1), (double)chest.primaryPos.method_10260() + 0.5, item.method_7972());
            player.method_37908().method_8649((class_1297)itemEntity);
            ++stored;
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            int count = stored;
            boolean isDouble = chest.isDouble;
            source.method_9226(() -> class_2561.method_43470((String)"Duplicated and stored ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" items in " + (isDouble ? "double " : "") + "chest")).method_27692(class_124.field_1060)), false);
        }
        return stored;
    }

    private static void dropItem(class_3222 player, class_1799 stack) {
        class_1542 itemEntity = player.method_7328(stack, false);
        if (itemEntity != null) {
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
    }
}

