/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.inventory;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class EnchCommand {
    private static final SuggestionProvider<class_2168> ENCHANTMENT_SUGGESTIONS = (context, builder) -> {
        ArrayList<String> names = new ArrayList<String>();
        for (class_1887 ench : class_7923.field_41176) {
            class_2960 id = class_7923.field_41176.method_10221((Object)ench);
            if (id == null) continue;
            names.add(id.method_12832());
        }
        return class_2172.method_9265(names, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ench").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)StringArgumentType.word()).suggests(ENCHANTMENT_SUGGESTIONS).executes(context -> EnchCommand.execute((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(context -> EnchCommand.execute((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int execute(CommandContext<class_2168> context, int level) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7960()) {
            source.method_9226(() -> class_2561.method_43470((String)"You're not holding anything").method_27692(class_124.field_1061), false);
            return 0;
        }
        String enchantName = StringArgumentType.getString(context, (String)"enchantment").toLowerCase();
        class_2960 enchId = new class_2960("minecraft", enchantName);
        class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(enchId);
        if (enchantment == null) {
            source.method_9226(() -> class_2561.method_43470((String)("Unknown enchantment: " + enchantName)).method_27692(class_124.field_1061), false);
            return 0;
        }
        if (level == 0) {
            EnchCommand.removeEnchantment(heldItem, enchantment);
            if (!PlayerStateManager.isHideResponses(player.method_5667())) {
                source.method_9226(() -> class_2561.method_43470((String)"Removed ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)EnchCommand.formatEnchantName(enchantName)).method_27692(class_124.field_1075)), false);
            }
            return 1;
        }
        EnchCommand.addEnchantmentUnsafe(heldItem, enchantment, level);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Applied ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(EnchCommand.formatEnchantName(enchantName) + " " + level)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to held item").method_27692(class_124.field_1060)), false);
        }
        return 1;
    }

    private static void addEnchantmentUnsafe(class_1799 stack, class_1887 enchantment, int level) {
        class_2499 enchantments;
        String enchKey;
        class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
        if (id == null) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        String string = enchKey = stack.method_7909().equals(class_1802.field_8598) ? "StoredEnchantments" : "Enchantments";
        if (nbt.method_10573(enchKey, 9)) {
            enchantments = nbt.method_10554(enchKey, 10);
            for (int i = enchantments.size() - 1; i >= 0; --i) {
                class_2487 enchNbt = enchantments.method_10602(i);
                if (!enchNbt.method_10558("id").equals(id.toString())) continue;
                enchantments.method_10536(i);
            }
        } else {
            enchantments = new class_2499();
        }
        class_2487 enchNbt = new class_2487();
        enchNbt.method_10582("id", id.toString());
        enchNbt.method_10575("lvl", (short)level);
        enchantments.add((Object)enchNbt);
        nbt.method_10566(enchKey, (class_2520)enchantments);
    }

    private static void removeEnchantment(class_1799 stack, class_1887 enchantment) {
        String enchKey;
        class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
        if (id == null) {
            return;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return;
        }
        String string = enchKey = stack.method_7909().equals(class_1802.field_8598) ? "StoredEnchantments" : "Enchantments";
        if (nbt.method_10573(enchKey, 9)) {
            class_2499 enchantments = nbt.method_10554(enchKey, 10);
            for (int i = enchantments.size() - 1; i >= 0; --i) {
                class_2487 enchNbt = enchantments.method_10602(i);
                if (!enchNbt.method_10558("id").equals(id.toString())) continue;
                enchantments.method_10536(i);
            }
        }
    }

    private static String formatEnchantName(String name) {
        String[] words = name.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }
}

