/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.power;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class HealthCommand {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"health").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"min").executes(context -> HealthCommand.executeHealth((CommandContext<class_2168>)context, "min")))).then(class_2170.method_9247((String)"max").executes(context -> HealthCommand.executeHealth((CommandContext<class_2168>)context, "max")))).then(class_2170.method_9247((String)"infinite").executes(context -> HealthCommand.executeHealth((CommandContext<class_2168>)context, "infinite")))).then(class_2170.method_9244((String)"hearts", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(HealthCommand::executeHearts)));
    }

    private static int executeHearts(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        int hearts = IntegerArgumentType.getInteger(context, (String)"hearts");
        float health = (float)hearts * 2.0f;
        class_1324 healthAttr = player.method_5996(class_5134.field_23716);
        if (healthAttr == null) {
            return 0;
        }
        healthAttr.method_6200(HEALTH_MODIFIER_UUID);
        if (health != 20.0f) {
            double currentMax = healthAttr.method_6201();
            healthAttr.method_26837(new class_1322(HEALTH_MODIFIER_UUID, "Health modifier", (double)health - currentMax, class_1322.class_1323.field_6328));
        }
        player.method_6033(health);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Health set to ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(hearts + " hearts")).method_27692(class_124.field_1075)), false);
        }
        return 1;
    }

    private static int executeHealth(CommandContext<class_2168> context, String mode) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1324 healthAttr = player.method_5996(class_5134.field_23716);
        if (healthAttr == null) {
            return 0;
        }
        healthAttr.method_6200(HEALTH_MODIFIER_UUID);
        switch (mode) {
            case "min": {
                double currentMax = healthAttr.method_6201();
                healthAttr.method_26837(new class_1322(HEALTH_MODIFIER_UUID, "Health modifier", 2.0 - currentMax, class_1322.class_1323.field_6328));
                player.method_6033(2.0f);
                if (PlayerStateManager.isHideResponses(player.method_5667())) break;
                source.method_9226(() -> class_2561.method_43470((String)"Health set to ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"minimum (1 heart)").method_27692(class_124.field_1061)), false);
                break;
            }
            case "max": {
                player.method_6033(20.0f);
                if (PlayerStateManager.isHideResponses(player.method_5667())) break;
                source.method_9226(() -> class_2561.method_43470((String)"Health set to ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"maximum (10 hearts)").method_27692(class_124.field_1075)), false);
                break;
            }
            case "infinite": {
                double currentMax = healthAttr.method_6201();
                healthAttr.method_26837(new class_1322(HEALTH_MODIFIER_UUID, "Health modifier", 1000000.0 - currentMax, class_1322.class_1323.field_6328));
                player.method_6033(1000000.0f);
                if (PlayerStateManager.isHideResponses(player.method_5667())) break;
                source.method_9226(() -> class_2561.method_43470((String)"Health set to ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"infinite").method_27692(class_124.field_1076)), false);
            }
        }
        return 1;
    }
}

