/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.power;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class SetSpeedCommand {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("b2c3d4e5-f6a7-8901-bcde-f12345678901");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setspeed").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)20.0f)).executes(SetSpeedCommand::executeValue))).then(class_2170.method_9247((String)"reset").executes(SetSpeedCommand::executeReset))).then(class_2170.method_9247((String)"rs").executes(SetSpeedCommand::executeReset)));
    }

    private static int executeValue(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        float value = FloatArgumentType.getFloat(context, (String)"value");
        PlayerStateManager.setSpeedMultiplier(player.method_5667(), value);
        SetSpeedCommand.applySpeedModifier(player, value);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Speed multiplier set to ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1fx", Float.valueOf(value))).method_27692(class_124.field_1075)), false);
        }
        return 1;
    }

    private static int executeReset(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        PlayerStateManager.setSpeedMultiplier(player.method_5667(), 1.0f);
        SetSpeedCommand.removeSpeedModifier(player);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Speed multiplier reset to default").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static void applySpeedModifier(class_3222 player, float multiplier) {
        class_1324 speedAttr = player.method_5996(class_5134.field_23719);
        if (speedAttr != null) {
            speedAttr.method_6200(SPEED_MODIFIER_UUID);
            if (multiplier != 1.0f) {
                double bonus = ((double)multiplier - 1.0) * 0.1;
                speedAttr.method_26835(new class_1322(SPEED_MODIFIER_UUID, "Speed modifier", bonus, class_1322.class_1323.field_6328));
            }
        }
    }

    private static void removeSpeedModifier(class_3222 player) {
        class_1324 speedAttr = player.method_5996(class_5134.field_23719);
        if (speedAttr != null) {
            speedAttr.method_6200(SPEED_MODIFIER_UUID);
        }
    }
}

