/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class CalcCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"calc").requires(source -> source.method_9259(0))).then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(CalcCommand::execute)));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String expression = StringArgumentType.getString(context, (String)"expression");
        try {
            double result = CalcCommand.evaluate(expression);
            String resultStr = result == Math.floor(result) && !Double.isInfinite(result) ? String.format("%.0f", result) : String.format("%.6f", result).replaceAll("0+$", "").replaceAll("\\.$", "");
            source.method_9226(() -> class_2561.method_43470((String)(expression + " = ")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)resultStr).method_27692(class_124.field_1075)), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9226(() -> class_2561.method_43470((String)("Invalid expression: " + e.getMessage())).method_27692(class_124.field_1061), false);
            return 0;
        }
    }

    private static double evaluate(String expression) throws Exception {
        expression = expression.replaceAll("\\s+", "");
        expression = expression.replace("sqrt", "Math.sqrt");
        expression = expression.replace("pow", "Math.pow");
        expression = expression.replace("abs", "Math.abs");
        expression = expression.replace("sin", "Math.sin");
        expression = expression.replace("cos", "Math.cos");
        expression = expression.replace("tan", "Math.tan");
        expression = expression.replace("log", "Math.log");
        expression = expression.replace("pi", String.valueOf(Math.PI));
        expression = expression.replace("e", String.valueOf(Math.E));
        return CalcCommand.parseExpression(expression, new int[]{0});
    }

    private static double parseExpression(String expr, int[] pos) throws Exception {
        double result = CalcCommand.parseTerm(expr, pos);
        while (pos[0] < expr.length()) {
            char op = expr.charAt(pos[0]);
            if (op == '+') {
                pos[0] = pos[0] + 1;
                result += CalcCommand.parseTerm(expr, pos);
                continue;
            }
            if (op != '-') break;
            pos[0] = pos[0] + 1;
            result -= CalcCommand.parseTerm(expr, pos);
        }
        return result;
    }

    private static double parseTerm(String expr, int[] pos) throws Exception {
        double result = CalcCommand.parseFactor(expr, pos);
        while (pos[0] < expr.length()) {
            char op = expr.charAt(pos[0]);
            if (op == '*') {
                pos[0] = pos[0] + 1;
                result *= CalcCommand.parseFactor(expr, pos);
                continue;
            }
            if (op == '/') {
                pos[0] = pos[0] + 1;
                result /= CalcCommand.parseFactor(expr, pos);
                continue;
            }
            if (op == '%') {
                pos[0] = pos[0] + 1;
                result %= CalcCommand.parseFactor(expr, pos);
                continue;
            }
            if (op != '^') break;
            pos[0] = pos[0] + 1;
            result = Math.pow(result, CalcCommand.parseFactor(expr, pos));
        }
        return result;
    }

    private static double parseFactor(String expr, int[] pos) throws Exception {
        double result;
        if (pos[0] >= expr.length()) {
            throw new Exception("Unexpected end of expression");
        }
        boolean negative = false;
        if (expr.charAt(pos[0]) == '-') {
            negative = true;
            pos[0] = pos[0] + 1;
        }
        if (expr.charAt(pos[0]) == '(') {
            pos[0] = pos[0] + 1;
            result = CalcCommand.parseExpression(expr, pos);
            if (pos[0] >= expr.length() || expr.charAt(pos[0]) != ')') {
                throw new Exception("Missing closing parenthesis");
            }
            pos[0] = pos[0] + 1;
        } else {
            int start = pos[0];
            while (pos[0] < expr.length() && (Character.isDigit(expr.charAt(pos[0])) || expr.charAt(pos[0]) == '.')) {
                pos[0] = pos[0] + 1;
            }
            if (start == pos[0]) {
                throw new Exception("Expected number at position " + pos[0]);
            }
            result = Double.parseDouble(expr.substring(start, pos[0]));
        }
        return negative ? -result : result;
    }
}

