/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.network.MusicControlPacket;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class MusicCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"music").requires(source -> source.method_9259(0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"play").executes(context -> MusicCommand.executeControl((CommandContext<class_2168>)context, "play"))).then(class_2170.method_9244((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> MusicCommand.executeControlWithVolume((CommandContext<class_2168>)context, "play", FloatArgumentType.getFloat((CommandContext)context, (String)"volume")))))).then(class_2170.method_9247((String)"pause").executes(context -> MusicCommand.executeControl((CommandContext<class_2168>)context, "pause")))).then(class_2170.method_9247((String)"skip").executes(context -> MusicCommand.executeControl((CommandContext<class_2168>)context, "skip")))).then(class_2170.method_9247((String)"back").executes(context -> MusicCommand.executeControl((CommandContext<class_2168>)context, "back")))).then(class_2170.method_9244((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> MusicCommand.executeVolume((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"volume")))));
    }

    private static int executeControl(CommandContext<class_2168> context, String action) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        MusicControlPacket.send(player, action, -1.0f);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            Object message = switch (action) {
                case "play" -> "Resuming music";
                case "pause" -> "Pausing music";
                case "skip" -> "Skipping to next track";
                case "back" -> "Going to previous track";
                default -> "Music control: " + action;
            };
            source.method_9226(() -> MusicCommand.lambda$executeControl$7((String)message), false);
        }
        return 1;
    }

    private static int executeControlWithVolume(CommandContext<class_2168> context, String action, float volume) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        MusicControlPacket.send(player, action, volume);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Resuming music at ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(volume * 100.0f))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" volume").method_27692(class_124.field_1060)), false);
        }
        return 1;
    }

    private static int executeVolume(CommandContext<class_2168> context, float volume) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        MusicControlPacket.send(player, "volume", volume);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Music volume set to ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(volume * 100.0f))).method_27692(class_124.field_1075)), false);
        }
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$executeControl$7(String message) {
        return class_2561.method_43470((String)message).method_27692(class_124.field_1060);
    }
}

