/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.world;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2393;
import net.minecraft.class_2421;
import net.minecraft.class_2473;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3830;
import net.minecraft.class_4776;
import net.minecraft.class_4777;

public class GrowCommand {
    private static final int DEFAULT_RADIUS = 10;
    private static final int MAX_RADIUS = 64;
    private static final Set<String> CROP_TYPES = Set.of("wheat", "carrots", "carrot", "potatoes", "potato", "beetroots", "beetroot", "beet", "melon", "pumpkin", "cocoa", "nether_wart", "netherwart");
    private static final Set<String> PLANT_TYPES = Set.of("sapling", "saplings", "tree", "trees", "seed", "seeds", "crop", "crops", "all");
    private static final SuggestionProvider<class_2168> TYPE_SUGGESTIONS = (context, builder) -> class_2172.method_9265(List.of("wheat", "carrot", "potato", "beetroot", "melon", "pumpkin", "sapling", "seed", "crop", "all"), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"grow").requires(source -> source.method_9259(2))).executes(context -> GrowCommand.execute((CommandContext<class_2168>)context, 10, "all"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> GrowCommand.execute((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), "all"))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(TYPE_SUGGESTIONS).executes(context -> GrowCommand.execute((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), StringArgumentType.getString((CommandContext)context, (String)"type"))))));
    }

    private static int execute(CommandContext<class_2168> context, int radius, String type) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_3218 world = player.method_51469();
        class_2338 center = player.method_24515();
        int grown = 0;
        String typeLower = type.toLowerCase();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    class_2248 block = state.method_26204();
                    if (!GrowCommand.shouldGrow(block, typeLower) || !GrowCommand.growBlock(world, pos, state, block)) continue;
                    ++grown;
                }
            }
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            int count = grown;
            String finalType = type;
            if (count > 0) {
                source.method_9226(() -> class_2561.method_43470((String)"Grew ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" plants").method_27692(class_124.field_1060)), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("No growable plants found within " + radius + " blocks")).method_27692(class_124.field_1080), false);
            }
        }
        return grown;
    }

    private static boolean shouldGrow(class_2248 block, String type) {
        if (type.equals("all")) {
            return GrowCommand.isGrowable(block);
        }
        if (type.equals("sapling") || type.equals("saplings") || type.equals("tree") || type.equals("trees")) {
            return block instanceof class_2473;
        }
        if (type.equals("seed") || type.equals("seeds") || type.equals("crop") || type.equals("crops")) {
            return block instanceof class_2302;
        }
        if (type.equals("wheat")) {
            return block instanceof class_2302 && block == class_2246.field_10293;
        }
        if (type.equals("carrot") || type.equals("carrots")) {
            return block == class_2246.field_10609;
        }
        if (type.equals("potato") || type.equals("potatoes")) {
            return block == class_2246.field_10247;
        }
        if (type.equals("beetroot") || type.equals("beetroots") || type.equals("beet")) {
            return block == class_2246.field_10341;
        }
        if (type.equals("melon")) {
            return block == class_2246.field_10168 || block == class_2246.field_10150;
        }
        if (type.equals("pumpkin")) {
            return block == class_2246.field_9984 || block == class_2246.field_10331;
        }
        if (type.equals("cocoa")) {
            return block instanceof class_2282;
        }
        if (type.equals("nether_wart") || type.equals("netherwart")) {
            return block == class_2246.field_9974;
        }
        return false;
    }

    private static boolean isGrowable(class_2248 block) {
        return block instanceof class_2302 || block instanceof class_2473 || block instanceof class_2513 || block instanceof class_2282 || block == class_2246.field_9974 || block instanceof class_3830 || block instanceof class_2211 || block instanceof class_2393 || block instanceof class_4777 || block instanceof class_4776;
    }

    private static boolean growBlock(class_3218 world, class_2338 pos, class_2680 state, class_2248 block) {
        int currentAge;
        int currentAge2;
        int currentAge3;
        if (block instanceof class_2473) {
            class_2473 sapling = (class_2473)block;
            sapling.method_10507(world, pos, state, world.field_9229);
            return world.method_8320(pos).method_26204() != block;
        }
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            int maxAge = crop.method_9827();
            int currentAge4 = crop.method_9829(state);
            if (currentAge4 < maxAge) {
                world.method_8501(pos, crop.method_9828(maxAge));
                return true;
            }
        }
        if (block instanceof class_2513) {
            class_2513 stem = (class_2513)block;
            int currentAge5 = (Integer)state.method_11654((class_2769)class_2513.field_11584);
            if (currentAge5 < 7) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(7)));
                return true;
            }
        }
        if (block instanceof class_2282 && (currentAge3 = ((Integer)state.method_11654((class_2769)class_2282.field_10779)).intValue()) < 2) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(2)));
            return true;
        }
        if (block == class_2246.field_9974 && (currentAge2 = ((Integer)state.method_11654((class_2769)class_2421.field_11306)).intValue()) < 3) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(3)));
            return true;
        }
        if (block instanceof class_3830 && (currentAge = ((Integer)state.method_11654((class_2769)class_3830.field_17000)).intValue()) < 3) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(3)));
            return true;
        }
        return false;
    }
}

