/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.world;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class LightningCommand {
    private static final double MAX_DISTANCE = 256.0;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lightning").requires(source -> source.method_9259(2))).executes(context -> LightningCommand.executeAtLook((CommandContext<class_2168>)context, 0L))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)LongArgumentType.longArg((long)0L, (long)60000L)).executes(context -> LightningCommand.executeAtLook((CommandContext<class_2168>)context, LongArgumentType.getLong((CommandContext)context, (String)"duration")))).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(LightningCommand::executeAtCoords))))));
    }

    private static int executeAtLook(CommandContext<class_2168> context, long durationMs) {
        class_243 lookVec;
        class_243 endPos;
        class_243 eyePos;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_3218 world = player.method_51469();
        class_3965 hitResult = world.method_17742(new class_3959(eyePos = player.method_33571(), endPos = eyePos.method_1019((lookVec = player.method_5720()).method_1021(256.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            source.method_9226(() -> class_2561.method_43470((String)"No block in sight").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_2338 pos = hitResult.method_17777();
        LightningCommand.spawnLightning(world, pos);
        if (durationMs > 0L) {
            long strikes = durationMs / 500L;
            int i = 1;
            while ((long)i <= strikes) {
                int delay = i * 500;
                scheduler.schedule(() -> {
                    if (world.method_8503() != null) {
                        world.method_8503().execute(() -> LightningCommand.spawnLightning(world, pos));
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
                ++i;
            }
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            if (durationMs > 0L) {
                source.method_9226(() -> class_2561.method_43470((String)("Lightning storm for " + durationMs + "ms!")).method_27692(class_124.field_1054), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u26a1 Strike!").method_27692(class_124.field_1054), false);
            }
        }
        return 1;
    }

    private static int executeAtCoords(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_3218 world = player.method_51469();
        long durationMs = LongArgumentType.getLong(context, (String)"duration");
        int x = IntegerArgumentType.getInteger(context, (String)"x");
        int y = IntegerArgumentType.getInteger(context, (String)"y");
        int z = IntegerArgumentType.getInteger(context, (String)"z");
        class_2338 pos = new class_2338(x, y, z);
        LightningCommand.spawnLightning(world, pos);
        if (durationMs > 0L) {
            long strikes = durationMs / 500L;
            int i = 1;
            while ((long)i <= strikes) {
                int delay = i * 500;
                scheduler.schedule(() -> {
                    if (world.method_8503() != null) {
                        world.method_8503().execute(() -> LightningCommand.spawnLightning(world, pos));
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
                ++i;
            }
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)("\u26a1 Strike at (" + x + ", " + y + ", " + z + ")!")).method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static void spawnLightning(class_3218 world, class_2338 pos) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)world);
        if (lightning != null) {
            lightning.method_24203((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            world.method_8649((class_1297)lightning);
        }
    }
}

