/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.world;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.superiorplayercommands.data.PlayerStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

public class SpawnStackCommand {
    private static final SuggestionProvider<class_2168> MOB_SUGGESTIONS = (context, builder) -> class_2172.method_9265(List.of("zombie", "skeleton", "creeper", "spider", "pig", "cow", "sheep", "chicken", "villager", "enderman", "blaze", "witch", "slime"), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawnstack").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"mobs", (ArgumentType)StringArgumentType.greedyString()).suggests(MOB_SUGGESTIONS).executes(SpawnStackCommand::execute)));
    }

    private static int execute(CommandContext<class_2168> context) {
        int repeatCount;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        String input = StringArgumentType.getString(context, (String)"mobs");
        String[] parts = input.split("\\s+");
        if (parts.length < 2) {
            source.method_9226(() -> class_2561.method_43470((String)"Usage: /spawnstack <mob1> [mob2] [mob3] ... <repeat>").method_27692(class_124.field_1061), false);
            return 0;
        }
        try {
            repeatCount = Integer.parseInt(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            source.method_9226(() -> class_2561.method_43470((String)"Last argument must be a number (repeat count)").method_27692(class_124.field_1061), false);
            return 0;
        }
        if (repeatCount < 1 || repeatCount > 50) {
            source.method_9226(() -> class_2561.method_43470((String)"Repeat count must be between 1 and 50").method_27692(class_124.field_1061), false);
            return 0;
        }
        ArrayList<class_1299> mobTypes = new ArrayList<class_1299>();
        for (int i = 0; i < parts.length - 1; ++i) {
            String mobName = parts[i].toLowerCase();
            class_2960 entityId = new class_2960("minecraft", mobName);
            Optional entityType = class_7923.field_41177.method_17966(entityId);
            if (entityType.isEmpty()) {
                String finalMobName = mobName;
                source.method_9226(() -> class_2561.method_43470((String)("Unknown mob type: " + finalMobName)).method_27692(class_124.field_1061), false);
                return 0;
            }
            mobTypes.add((class_1299)entityType.get());
        }
        if (mobTypes.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No valid mob types specified").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3218 world = player.method_51469();
        class_2338 spawnPos = player.method_24515().method_10079(player.method_5735(), 2);
        class_1297 bottomEntity = null;
        class_1297 previousEntity = null;
        int totalSpawned = 0;
        for (int repeat = 0; repeat < repeatCount; ++repeat) {
            for (class_1299 mobType : mobTypes) {
                class_1297 entity = mobType.method_5888(world, null, null, spawnPos, class_3730.field_16462, false, false);
                if (entity == null) continue;
                world.method_8649(entity);
                if (bottomEntity == null) {
                    bottomEntity = entity;
                }
                if (previousEntity != null) {
                    entity.method_5873(previousEntity, true);
                }
                previousEntity = entity;
                ++totalSpawned;
            }
        }
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            int count = totalSpawned;
            source.method_9226(() -> class_2561.method_43470((String)"Spawned stack of ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" mobs").method_27692(class_124.field_1060)), false);
        }
        return totalSpawned;
    }
}

