/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.superiorplayercommands.SuperiorPlayerCommands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("superior-player-commands-config.json");
    private static ConfigData config = new ConfigData();
    public static final Map<String, String[]> COMMAND_CATEGORIES = new LinkedHashMap<String, String[]>();

    public static void load() {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
                Type type = new TypeToken<ConfigData>(){}.getType();
                ConfigData loaded = (ConfigData)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    config = loaded;
                    SuperiorPlayerCommands.LOGGER.info("Loaded mod config");
                }
            }
            catch (IOException e) {
                SuperiorPlayerCommands.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
        for (String[] commands : COMMAND_CATEGORIES.values()) {
            for (String cmd : commands) {
                ModConfig.config.commandToggles.putIfAbsent(cmd, true);
            }
        }
        ModConfig.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SuperiorPlayerCommands.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static boolean isMasterEnabled() {
        return ModConfig.config.masterEnabled;
    }

    public static void setMasterEnabled(boolean enabled) {
        ModConfig.config.masterEnabled = enabled;
        ModConfig.save();
    }

    public static boolean isCommandEnabled(String command) {
        if (!ModConfig.config.masterEnabled) {
            return false;
        }
        return ModConfig.config.commandToggles.getOrDefault(command.toLowerCase(), true);
    }

    public static void setCommandEnabled(String command, boolean enabled) {
        ModConfig.config.commandToggles.put(command.toLowerCase(), enabled);
        ModConfig.save();
    }

    public static Map<String, Boolean> getAllToggles() {
        return new LinkedHashMap<String, Boolean>(ModConfig.config.commandToggles);
    }

    public static void enableAll() {
        for (String cmd : ModConfig.config.commandToggles.keySet()) {
            ModConfig.config.commandToggles.put(cmd, true);
        }
        ModConfig.save();
    }

    public static void disableAll() {
        for (String cmd : ModConfig.config.commandToggles.keySet()) {
            ModConfig.config.commandToggles.put(cmd, false);
        }
        ModConfig.save();
    }

    static {
        COMMAND_CATEGORIES.put("Core", new String[]{"jump", "ascend", "descend", "back", "return", "unstuck", "bind", "alias", "hideresponses", "useportal", "help", "set", "rem", "goto", "listwaypoints"});
        COMMAND_CATEGORIES.put("Inventory", new String[]{"heal", "hunger", "replenish", "repair", "destroy", "duplicate", "more", "stack", "ench", "drop", "dropstore"});
        COMMAND_CATEGORIES.put("Power", new String[]{"god", "fly", "noclip", "mobsignore", "instamine", "drops", "hands", "autosmelt", "waterwalk", "knockback", "fullbright", "setjump", "setspeed", "falldamage", "firedamage", "drowndamage", "health", "ride"});
        COMMAND_CATEGORIES.put("World", new String[]{"extinguish", "freeze", "freezeai", "killall", "explode", "lightning", "defuse", "grow", "spawnstack"});
        COMMAND_CATEGORIES.put("Utility", new String[]{"calc", "biome", "measure", "tps", "coords", "music"});
    }

    public static class ConfigData {
        public boolean masterEnabled = true;
        public Map<String, Boolean> commandToggles = new LinkedHashMap<String, Boolean>();
    }
}

