/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.data;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class PlayerStateManager {
    private static final Map<UUID, Boolean> instamineEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastInstamineBreak = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> lastInstaminePos = new ConcurrentHashMap<UUID, Long>();
    private static final long INSTAMINE_COOLDOWN_MS = 100L;
    private static final Map<UUID, Boolean> dropsEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> handsLevel = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> godModeEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> flyEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Float> flySpeed = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, Boolean> noclipEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> mobsIgnoreEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> autosmeltEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> waterwalkEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Float> knockbackMultiplier = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, DeathPosition> lastDeathPosition = new ConcurrentHashMap<UUID, DeathPosition>();
    private static final Map<UUID, Boolean> hideResponses = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> dropWarningShown = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> fallDamageEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> fireDamageEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> drownDamageEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Float> jumpMultiplier = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, Float> speedMultiplier = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, TeleportPosition> lastTeleportPosition = new ConcurrentHashMap<UUID, TeleportPosition>();
    private static boolean freezeAI = false;

    public static boolean isInstamineEnabled(UUID playerUuid) {
        return instamineEnabled.getOrDefault(playerUuid, false);
    }

    public static void setInstamineEnabled(UUID playerUuid, boolean enabled) {
        if (enabled) {
            instamineEnabled.put(playerUuid, true);
        } else {
            instamineEnabled.remove(playerUuid);
            lastInstamineBreak.remove(playerUuid);
        }
    }

    public static boolean toggleInstamine(UUID playerUuid) {
        boolean newState = !PlayerStateManager.isInstamineEnabled(playerUuid);
        PlayerStateManager.setInstamineEnabled(playerUuid, newState);
        return newState;
    }

    public static boolean isInstamineReady(UUID playerUuid, long packedPos) {
        if (!PlayerStateManager.isInstamineEnabled(playerUuid)) {
            return false;
        }
        Long lastPos = lastInstaminePos.get(playerUuid);
        if (lastPos != null && lastPos == packedPos) {
            return true;
        }
        long lastBreak = lastInstamineBreak.getOrDefault(playerUuid, 0L);
        long elapsed = System.currentTimeMillis() - lastBreak;
        boolean ready = elapsed >= 100L;
        return ready;
    }

    public static void updateInstaminePosition(UUID playerUuid, long packedPos) {
        Long lastPos = lastInstaminePos.get(playerUuid);
        if (lastPos == null || lastPos != packedPos) {
            lastInstamineBreak.put(playerUuid, System.currentTimeMillis());
            lastInstaminePos.put(playerUuid, packedPos);
        }
    }

    public static boolean areDropsEnabled(UUID playerUuid) {
        return dropsEnabled.getOrDefault(playerUuid, true);
    }

    public static void setDropsEnabled(UUID playerUuid, boolean enabled) {
        if (enabled) {
            dropsEnabled.remove(playerUuid);
        } else {
            dropsEnabled.put(playerUuid, false);
        }
    }

    public static boolean toggleDrops(UUID playerUuid) {
        boolean newState = !PlayerStateManager.areDropsEnabled(playerUuid);
        PlayerStateManager.setDropsEnabled(playerUuid, newState);
        return newState;
    }

    public static ToolTier getHandsLevel(UUID playerUuid) {
        return ToolTier.fromLevel(handsLevel.getOrDefault(playerUuid, 0));
    }

    public static void setHandsLevel(UUID playerUuid, ToolTier tier) {
        if (tier == ToolTier.NONE) {
            handsLevel.remove(playerUuid);
        } else {
            handsLevel.put(playerUuid, tier.level);
        }
    }

    public static boolean isGodModeEnabled(UUID playerUuid) {
        return godModeEnabled.getOrDefault(playerUuid, false);
    }

    public static boolean toggleGodMode(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isGodModeEnabled(playerUuid);
        if (newState) {
            godModeEnabled.put(playerUuid, true);
        } else {
            godModeEnabled.remove(playerUuid);
        }
        return newState;
    }

    public static boolean isFlyEnabled(UUID playerUuid) {
        return flyEnabled.getOrDefault(playerUuid, false);
    }

    public static void setFlyEnabled(UUID playerUuid, boolean enabled) {
        if (enabled) {
            flyEnabled.put(playerUuid, true);
        } else {
            flyEnabled.remove(playerUuid);
        }
    }

    public static boolean toggleFly(UUID playerUuid) {
        boolean newState = !PlayerStateManager.isFlyEnabled(playerUuid);
        PlayerStateManager.setFlyEnabled(playerUuid, newState);
        return newState;
    }

    public static float getFlySpeed(UUID playerUuid) {
        return flySpeed.getOrDefault(playerUuid, Float.valueOf(0.05f)).floatValue();
    }

    public static void setFlySpeed(UUID playerUuid, float speed) {
        flySpeed.put(playerUuid, Float.valueOf(speed));
    }

    public static boolean isNoclipEnabled(UUID playerUuid) {
        return noclipEnabled.getOrDefault(playerUuid, false);
    }

    public static boolean toggleNoclip(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isNoclipEnabled(playerUuid);
        if (newState) {
            noclipEnabled.put(playerUuid, true);
        } else {
            noclipEnabled.remove(playerUuid);
        }
        return newState;
    }

    public static boolean isMobsIgnoreEnabled(UUID playerUuid) {
        return mobsIgnoreEnabled.getOrDefault(playerUuid, false);
    }

    public static boolean toggleMobsIgnore(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isMobsIgnoreEnabled(playerUuid);
        if (newState) {
            mobsIgnoreEnabled.put(playerUuid, true);
        } else {
            mobsIgnoreEnabled.remove(playerUuid);
        }
        return newState;
    }

    public static boolean isAutosmeltEnabled(UUID playerUuid) {
        return autosmeltEnabled.getOrDefault(playerUuid, false);
    }

    public static boolean toggleAutosmelt(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isAutosmeltEnabled(playerUuid);
        if (newState) {
            autosmeltEnabled.put(playerUuid, true);
        } else {
            autosmeltEnabled.remove(playerUuid);
        }
        return newState;
    }

    public static boolean isWaterwalkEnabled(UUID playerUuid) {
        return waterwalkEnabled.getOrDefault(playerUuid, false);
    }

    public static boolean toggleWaterwalk(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isWaterwalkEnabled(playerUuid);
        if (newState) {
            waterwalkEnabled.put(playerUuid, true);
        } else {
            waterwalkEnabled.remove(playerUuid);
        }
        return newState;
    }

    public static float getKnockbackMultiplier(UUID playerUuid) {
        return knockbackMultiplier.getOrDefault(playerUuid, Float.valueOf(1.0f)).floatValue();
    }

    public static void setKnockbackMultiplier(UUID playerUuid, float multiplier) {
        if (multiplier == 1.0f) {
            knockbackMultiplier.remove(playerUuid);
        } else {
            knockbackMultiplier.put(playerUuid, Float.valueOf(multiplier));
        }
    }

    public static boolean hasKnockbackModifier(UUID playerUuid) {
        return knockbackMultiplier.containsKey(playerUuid);
    }

    public static void setLastDeathPosition(UUID playerUuid, class_2338 pos, class_2960 dimension) {
        lastDeathPosition.put(playerUuid, new DeathPosition(pos, dimension));
    }

    public static DeathPosition getLastDeathPosition(UUID playerUuid) {
        return lastDeathPosition.get(playerUuid);
    }

    public static boolean isHideResponses(UUID playerUuid) {
        return hideResponses.getOrDefault(playerUuid, false);
    }

    public static boolean toggleHideResponses(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isHideResponses(playerUuid);
        if (newState) {
            hideResponses.put(playerUuid, true);
        } else {
            hideResponses.remove(playerUuid);
        }
        return newState;
    }

    public static boolean hasSeenDropWarning(UUID playerUuid) {
        return dropWarningShown.getOrDefault(playerUuid, false);
    }

    public static void setDropWarningShown(UUID playerUuid) {
        dropWarningShown.put(playerUuid, true);
    }

    public static boolean isFallDamageEnabled(UUID playerUuid) {
        return fallDamageEnabled.getOrDefault(playerUuid, true);
    }

    public static boolean toggleFallDamage(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isFallDamageEnabled(playerUuid);
        if (newState) {
            fallDamageEnabled.remove(playerUuid);
        } else {
            fallDamageEnabled.put(playerUuid, false);
        }
        return newState;
    }

    public static boolean isFireDamageEnabled(UUID playerUuid) {
        return fireDamageEnabled.getOrDefault(playerUuid, true);
    }

    public static boolean toggleFireDamage(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isFireDamageEnabled(playerUuid);
        if (newState) {
            fireDamageEnabled.remove(playerUuid);
        } else {
            fireDamageEnabled.put(playerUuid, false);
        }
        return newState;
    }

    public static boolean isDrownDamageEnabled(UUID playerUuid) {
        return drownDamageEnabled.getOrDefault(playerUuid, true);
    }

    public static boolean toggleDrownDamage(UUID playerUuid) {
        boolean newState;
        boolean bl = newState = !PlayerStateManager.isDrownDamageEnabled(playerUuid);
        if (newState) {
            drownDamageEnabled.remove(playerUuid);
        } else {
            drownDamageEnabled.put(playerUuid, false);
        }
        return newState;
    }

    public static float getJumpMultiplier(UUID playerUuid) {
        return jumpMultiplier.getOrDefault(playerUuid, Float.valueOf(1.0f)).floatValue();
    }

    public static void setJumpMultiplier(UUID playerUuid, float multiplier) {
        if (multiplier == 1.0f) {
            jumpMultiplier.remove(playerUuid);
        } else {
            jumpMultiplier.put(playerUuid, Float.valueOf(multiplier));
        }
    }

    public static float getSpeedMultiplier(UUID playerUuid) {
        return speedMultiplier.getOrDefault(playerUuid, Float.valueOf(1.0f)).floatValue();
    }

    public static void setSpeedMultiplier(UUID playerUuid, float multiplier) {
        if (multiplier == 1.0f) {
            speedMultiplier.remove(playerUuid);
        } else {
            speedMultiplier.put(playerUuid, Float.valueOf(multiplier));
        }
    }

    public static TeleportPosition getLastTeleportPosition(UUID playerUuid) {
        return lastTeleportPosition.get(playerUuid);
    }

    public static void setLastTeleportPosition(UUID playerUuid, class_2338 pos, class_2960 dimension) {
        lastTeleportPosition.put(playerUuid, new TeleportPosition(pos, dimension));
    }

    public static boolean isFreezeAI() {
        return freezeAI;
    }

    public static boolean toggleFreezeAI() {
        freezeAI = !freezeAI;
        return freezeAI;
    }

    public static void clearPlayerState(UUID playerUuid) {
        instamineEnabled.remove(playerUuid);
        lastInstamineBreak.remove(playerUuid);
        lastInstaminePos.remove(playerUuid);
        dropsEnabled.remove(playerUuid);
        handsLevel.remove(playerUuid);
        godModeEnabled.remove(playerUuid);
        flyEnabled.remove(playerUuid);
        flySpeed.remove(playerUuid);
        noclipEnabled.remove(playerUuid);
        mobsIgnoreEnabled.remove(playerUuid);
        autosmeltEnabled.remove(playerUuid);
        waterwalkEnabled.remove(playerUuid);
        knockbackMultiplier.remove(playerUuid);
        hideResponses.remove(playerUuid);
        fallDamageEnabled.remove(playerUuid);
        fireDamageEnabled.remove(playerUuid);
        drownDamageEnabled.remove(playerUuid);
        jumpMultiplier.remove(playerUuid);
        speedMultiplier.remove(playerUuid);
        lastTeleportPosition.remove(playerUuid);
    }

    public static enum ToolTier {
        NONE(0, "none", 0),
        WOOD(1, "wood", 0),
        STONE(2, "stone", 1),
        IRON(3, "iron", 2),
        GOLD(4, "gold", 0),
        DIAMOND(5, "diamond", 3),
        NETHERITE(6, "netherite", 4);

        public final int level;
        public final String name;
        public final int harvestLevel;

        private ToolTier(int level, String name, int harvestLevel) {
            this.level = level;
            this.name = name;
            this.harvestLevel = harvestLevel;
        }

        public static ToolTier fromLevel(int level) {
            for (ToolTier tier : ToolTier.values()) {
                if (tier.level != level) continue;
                return tier;
            }
            return NONE;
        }

        public float getMiningSpeed() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> 1.0f;
                case 1 -> 2.0f;
                case 2 -> 4.0f;
                case 3 -> 6.0f;
                case 4 -> 12.0f;
                case 5 -> 8.0f;
                case 6 -> 9.0f;
            };
        }
    }

    public static class DeathPosition {
        public final class_2338 pos;
        public final class_2960 dimension;

        public DeathPosition(class_2338 pos, class_2960 dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }
    }

    public static class TeleportPosition {
        public final class_2338 pos;
        public final class_2960 dimension;

        public TeleportPosition(class_2338 pos, class_2960 dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }
    }
}

