/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.superiorplayercommands.SuperiorPlayerCommands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class WaypointManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path WAYPOINTS_FILE = FabricLoader.getInstance().getConfigDir().resolve("superior-player-commands-waypoints.json");
    private static Map<String, Map<String, WaypointData>> playerWaypoints = new HashMap<String, Map<String, WaypointData>>();

    public static void load() {
        if (Files.exists(WAYPOINTS_FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(WAYPOINTS_FILE);){
                Type type = new TypeToken<Map<String, Map<String, WaypointData>>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    playerWaypoints = loaded;
                    int count = playerWaypoints.values().stream().mapToInt(Map::size).sum();
                    SuperiorPlayerCommands.LOGGER.info("Loaded {} waypoints for {} players", (Object)count, (Object)playerWaypoints.size());
                }
            }
            catch (IOException e) {
                SuperiorPlayerCommands.LOGGER.error("Failed to load waypoints", (Throwable)e);
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(WAYPOINTS_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(WAYPOINTS_FILE, new OpenOption[0]);){
                GSON.toJson(playerWaypoints, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SuperiorPlayerCommands.LOGGER.error("Failed to save waypoints", (Throwable)e);
        }
    }

    public static void setWaypoint(UUID playerUuid, String name, class_2338 pos, class_5321<class_1937> dimension) {
        String uuid = playerUuid.toString();
        playerWaypoints.computeIfAbsent(uuid, k -> new HashMap());
        playerWaypoints.get(uuid).put(name.toLowerCase(), new WaypointData(pos, dimension));
        WaypointManager.save();
    }

    public static boolean removeWaypoint(UUID playerUuid, String name) {
        WaypointData removed;
        String uuid = playerUuid.toString();
        Map<String, WaypointData> waypoints = playerWaypoints.get(uuid);
        if (waypoints != null && (removed = waypoints.remove(name.toLowerCase())) != null) {
            WaypointManager.save();
            return true;
        }
        return false;
    }

    public static Optional<WaypointData> getWaypoint(UUID playerUuid, String name) {
        String uuid = playerUuid.toString();
        Map<String, WaypointData> waypoints = playerWaypoints.get(uuid);
        if (waypoints != null) {
            return Optional.ofNullable(waypoints.get(name.toLowerCase()));
        }
        return Optional.empty();
    }

    public static Map<String, WaypointData> getWaypoints(UUID playerUuid) {
        String uuid = playerUuid.toString();
        return playerWaypoints.getOrDefault(uuid, new HashMap());
    }

    public static Collection<String> getWaypointNames(UUID playerUuid) {
        return WaypointManager.getWaypoints(playerUuid).keySet();
    }

    public static class WaypointData {
        public int x;
        public int y;
        public int z;
        public String dimension;

        public WaypointData() {
        }

        public WaypointData(class_2338 pos, class_5321<class_1937> dimension) {
            this.x = pos.method_10263();
            this.y = pos.method_10264();
            this.z = pos.method_10260();
            this.dimension = dimension.method_29177().toString();
        }

        public class_2338 getPos() {
            return new class_2338(this.x, this.y, this.z);
        }

        public class_2960 getDimensionId() {
            return new class_2960(this.dimension);
        }
    }
}

