/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ChestHelper {
    public static final int SINGLE_CHEST_SIZE = 27;
    public static final int DOUBLE_CHEST_SIZE = 54;

    public static int countUniqueStacks(List<class_1799> items) {
        ArrayList<class_1799> uniqueStacks = new ArrayList<class_1799>();
        for (class_1799 item : items) {
            if (item.method_7960()) continue;
            boolean found = false;
            for (class_1799 existing : uniqueStacks) {
                if (!class_1799.method_31577((class_1799)existing, (class_1799)item)) continue;
                int space = existing.method_7914() - existing.method_7947();
                if (space >= item.method_7947()) {
                    existing.method_7933(item.method_7947());
                    found = true;
                    break;
                }
                if (space <= 0) continue;
                existing.method_7933(space);
                item = item.method_7972();
                item.method_7934(space);
            }
            if (found || item.method_7960()) continue;
            uniqueStacks.add(item.method_7972());
        }
        return uniqueStacks.size();
    }

    public static boolean needsDoubleChest(int stackCount) {
        return stackCount > 27;
    }

    public static ChestResult findOrCreateChest(class_3222 player, int stackCount) {
        boolean needDouble;
        class_2338 playerPos;
        class_3218 world = player.method_51469();
        ChestResult existing = ChestHelper.findExistingChest(world, playerPos = player.method_24515(), needDouble = ChestHelper.needsDoubleChest(stackCount));
        if (existing != null) {
            return existing;
        }
        if (needDouble) {
            return ChestHelper.createDoubleChest(world, playerPos, player.method_5735());
        }
        return ChestHelper.createSingleChest(world, playerPos, player.method_5735());
    }

    private static ChestResult findExistingChest(class_3218 world, class_2338 center, boolean needDouble) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    class_2338 checkPos = center.method_10069(x, y, z);
                    class_2586 class_25862 = world.method_8321(checkPos);
                    if (!(class_25862 instanceof class_2595)) continue;
                    class_2595 chest = (class_2595)class_25862;
                    class_2680 state = world.method_8320(checkPos);
                    if (!(state.method_26204() instanceof class_2281)) continue;
                    class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                    if (type != class_2745.field_12569) {
                        class_2350 facing = class_2281.method_9758((class_2680)state);
                        class_2338 otherPos = checkPos.method_10093(facing);
                        class_2586 class_25863 = world.method_8321(otherPos);
                        if (!(class_25863 instanceof class_2595)) continue;
                        class_2595 otherChest = (class_2595)class_25863;
                        class_1258 doubleInv = new class_1258((class_1263)chest, (class_1263)otherChest);
                        return new ChestResult((class_1263)doubleInv, checkPos, otherPos);
                    }
                    if (needDouble) continue;
                    return new ChestResult((class_1263)chest, checkPos, null);
                }
            }
        }
        return null;
    }

    private static ChestResult createSingleChest(class_3218 world, class_2338 playerPos, class_2350 facing) {
        class_2586 class_25862;
        class_2338 pos;
        class_2350[] tryDirs;
        for (class_2350 dir : tryDirs = new class_2350[]{facing, facing.method_10170(), facing.method_10160(), facing.method_10153()}) {
            pos = playerPos.method_10079(dir, 2);
            if (!ChestHelper.isValidSingleChestPosition((class_1937)world, pos)) continue;
            world.method_8501(pos, class_2246.field_10034.method_9564());
            class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof class_2595)) continue;
            class_2595 chest = (class_2595)class_25862;
            return new ChestResult((class_1263)chest, pos, null);
        }
        for (class_2350 dir : tryDirs) {
            pos = playerPos.method_10084().method_10079(dir, 2);
            if (!ChestHelper.isValidSingleChestPosition((class_1937)world, pos)) continue;
            world.method_8501(pos, class_2246.field_10034.method_9564());
            class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof class_2595)) continue;
            class_2595 chest = (class_2595)class_25862;
            return new ChestResult((class_1263)chest, pos, null);
        }
        return null;
    }

    private static ChestResult createDoubleChest(class_3218 world, class_2338 playerPos, class_2350 facing) {
        class_2586 doubleInv;
        class_2595 chest1;
        class_2680 chestState2;
        class_2680 chestState1;
        class_2338 pos2;
        class_2338 pos1;
        class_2350[] tryDirs;
        for (class_2350 dir : tryDirs = new class_2350[]{facing, facing.method_10170(), facing.method_10160(), facing.method_10153()}) {
            pos1 = playerPos.method_10079(dir, 2);
            for (class_2350 sideDir : new class_2350[]{dir.method_10170(), dir.method_10160()}) {
                pos2 = pos1.method_10093(sideDir);
                if (!ChestHelper.isValidDoubleChestPosition((class_1937)world, pos1, pos2)) continue;
                chestState1 = (class_2680)((class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir.method_10153())).method_11657((class_2769)class_2281.field_10770, (Comparable)(sideDir == dir.method_10170() ? class_2745.field_12571 : class_2745.field_12574));
                world.method_8501(pos1, chestState1);
                chestState2 = (class_2680)((class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir.method_10153())).method_11657((class_2769)class_2281.field_10770, (Comparable)(sideDir == dir.method_10170() ? class_2745.field_12574 : class_2745.field_12571));
                world.method_8501(pos2, chestState2);
                class_2586 class_25862 = world.method_8321(pos1);
                if (!(class_25862 instanceof class_2595)) continue;
                chest1 = (class_2595)class_25862;
                class_25862 = world.method_8321(pos2);
                if (!(class_25862 instanceof class_2595)) continue;
                class_2595 chest2 = (class_2595)class_25862;
                doubleInv = new class_1258((class_1263)chest1, (class_1263)chest2);
                return new ChestResult((class_1263)doubleInv, pos1, pos2);
            }
        }
        for (class_2350 dir : tryDirs) {
            pos1 = playerPos.method_10084().method_10079(dir, 2);
            for (class_2350 sideDir : new class_2350[]{dir.method_10170(), dir.method_10160()}) {
                pos2 = pos1.method_10093(sideDir);
                if (!ChestHelper.isValidDoubleChestPosition((class_1937)world, pos1, pos2)) continue;
                chestState1 = (class_2680)((class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir.method_10153())).method_11657((class_2769)class_2281.field_10770, (Comparable)(sideDir == dir.method_10170() ? class_2745.field_12571 : class_2745.field_12574));
                world.method_8501(pos1, chestState1);
                chestState2 = (class_2680)((class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir.method_10153())).method_11657((class_2769)class_2281.field_10770, (Comparable)(sideDir == dir.method_10170() ? class_2745.field_12574 : class_2745.field_12571));
                world.method_8501(pos2, chestState2);
                doubleInv = world.method_8321(pos1);
                if (!(doubleInv instanceof class_2595)) continue;
                chest1 = (class_2595)doubleInv;
                doubleInv = world.method_8321(pos2);
                if (!(doubleInv instanceof class_2595)) continue;
                class_2595 chest2 = (class_2595)doubleInv;
                doubleInv = new class_1258((class_1263)chest1, (class_1263)chest2);
                return new ChestResult((class_1263)doubleInv, pos1, pos2);
            }
        }
        return null;
    }

    private static boolean isValidSingleChestPosition(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos).method_26215()) {
            return false;
        }
        class_2338 above = pos.method_10084();
        class_2680 aboveState = world.method_8320(above);
        return aboveState.method_26215() || !aboveState.method_26225();
    }

    private static boolean isValidDoubleChestPosition(class_1937 world, class_2338 pos1, class_2338 pos2) {
        if (!ChestHelper.isValidSingleChestPosition(world, pos1)) {
            return false;
        }
        return ChestHelper.isValidSingleChestPosition(world, pos2);
    }

    public static int storeItems(class_1263 chest, List<class_1799> items) {
        int stored = 0;
        for (class_1799 item : items) {
            int i;
            if (item.method_7960()) continue;
            class_1799 toStore = item.method_7972();
            for (i = 0; i < chest.method_5439() && !toStore.method_7960(); ++i) {
                class_1799 slotStack = chest.method_5438(i);
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)toStore) || slotStack.method_7947() >= slotStack.method_7914()) continue;
                int space = slotStack.method_7914() - slotStack.method_7947();
                int toAdd = Math.min(space, toStore.method_7947());
                slotStack.method_7933(toAdd);
                toStore.method_7934(toAdd);
            }
            for (i = 0; i < chest.method_5439() && !toStore.method_7960(); ++i) {
                if (!chest.method_5438(i).method_7960()) continue;
                chest.method_5447(i, toStore.method_7972());
                toStore = class_1799.field_8037;
            }
            if (!toStore.method_7960() && toStore.method_7947() >= item.method_7947()) continue;
            ++stored;
        }
        return stored;
    }

    public static void dropOverflow(class_1937 world, class_2338 chestPos, List<class_1799> items, class_1263 chest) {
        for (class_1799 item : items) {
            if (item.method_7960()) continue;
            class_1799 remaining = item.method_7972();
            for (int i = 0; i < chest.method_5439() && !remaining.method_7960(); ++i) {
                class_1799 slotStack = chest.method_5438(i);
                if (slotStack.method_7960()) {
                    chest.method_5447(i, remaining.method_7972());
                    remaining = class_1799.field_8037;
                    continue;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)remaining) || slotStack.method_7947() >= slotStack.method_7914()) continue;
                int space = slotStack.method_7914() - slotStack.method_7947();
                int toAdd = Math.min(space, remaining.method_7947());
                slotStack.method_7933(toAdd);
                remaining.method_7934(toAdd);
            }
            if (remaining.method_7960()) continue;
            class_1542 itemEntity = new class_1542(world, (double)chestPos.method_10263() + 0.5, (double)(chestPos.method_10264() + 1), (double)chestPos.method_10260() + 0.5, remaining);
            world.method_8649((class_1297)itemEntity);
        }
    }

    public static class ChestResult {
        public final class_1263 inventory;
        public final class_2338 primaryPos;
        public final class_2338 secondaryPos;
        public final boolean isDouble;

        public ChestResult(class_1263 inventory, class_2338 primaryPos, class_2338 secondaryPos) {
            this.inventory = inventory;
            this.primaryPos = primaryPos;
            this.secondaryPos = secondaryPos;
            this.isDouble = secondaryPos != null;
        }
    }
}

