/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.util;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class TeleportHelper {
    public static boolean isPassable(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_51366();
    }

    public static boolean isLiquid(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_26227().method_15769();
    }

    public static boolean isWater(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_27852(class_2246.field_10382);
    }

    public static boolean isLava(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_27852(class_2246.field_10164);
    }

    public static boolean hasTwoBlockGap(class_1937 world, class_2338 feetPos) {
        return TeleportHelper.isPassable(world, feetPos) && TeleportHelper.isPassable(world, feetPos.method_10084());
    }

    public static boolean hasSolidFloor(class_1937 world, class_2338 feetPos) {
        class_2680 below = world.method_8320(feetPos.method_10074());
        return below.method_51366() && !TeleportHelper.isLiquid(world, feetPos.method_10074());
    }

    public static ScanResult scanUp(class_1937 world, class_2338 startPos) {
        int maxY = world.method_31600();
        class_2338 scanPos = startPos.method_10086(2);
        while (scanPos.method_10264() < maxY - 1) {
            if (TeleportHelper.hasTwoBlockGap(world, scanPos) && TeleportHelper.hasSolidFloor(world, scanPos)) {
                LiquidType liquid = TeleportHelper.checkLiquidAt(world, scanPos);
                if (liquid != LiquidType.NONE) {
                    return ScanResult.liquidWarning(scanPos, liquid);
                }
                return ScanResult.success(scanPos);
            }
            scanPos = scanPos.method_10084();
        }
        return ScanResult.notFound();
    }

    public static ScanResult scanDown(class_1937 world, class_2338 startPos) {
        int minY = world.method_31607();
        class_2338 scanPos = startPos.method_10087(2);
        while (scanPos.method_10264() > minY) {
            class_2338 feetPos;
            class_2680 state = world.method_8320(scanPos);
            if (state.method_51366() && !TeleportHelper.isLiquid(world, scanPos) && TeleportHelper.hasTwoBlockGap(world, feetPos = scanPos.method_10084())) {
                LiquidType liquid = TeleportHelper.checkLiquidAt(world, feetPos);
                if (liquid != LiquidType.NONE) {
                    return ScanResult.liquidWarning(feetPos, liquid);
                }
                return ScanResult.success(feetPos);
            }
            scanPos = scanPos.method_10074();
        }
        return ScanResult.notFound();
    }

    private static LiquidType checkLiquidAt(class_1937 world, class_2338 feetPos) {
        if (TeleportHelper.isLava(world, feetPos) || TeleportHelper.isLava(world, feetPos.method_10084())) {
            return LiquidType.LAVA;
        }
        if (TeleportHelper.isWater(world, feetPos) || TeleportHelper.isWater(world, feetPos.method_10084())) {
            return LiquidType.WATER;
        }
        return LiquidType.NONE;
    }

    public static void teleportPlayer(class_3222 player, class_2338 feetPos) {
        player.method_20620((double)feetPos.method_10263() + 0.5, (double)feetPos.method_10264(), (double)feetPos.method_10260() + 0.5);
    }

    public static enum LiquidType {
        NONE,
        WATER,
        LAVA;

    }

    public static class ScanResult {
        public final boolean found;
        public final class_2338 position;
        public final LiquidType liquidFound;

        public ScanResult(boolean found, class_2338 position, LiquidType liquidFound) {
            this.found = found;
            this.position = position;
            this.liquidFound = liquidFound;
        }

        public static ScanResult notFound() {
            return new ScanResult(false, null, LiquidType.NONE);
        }

        public static ScanResult success(class_2338 pos) {
            return new ScanResult(true, pos, LiquidType.NONE);
        }

        public static ScanResult liquidWarning(class_2338 pos, LiquidType liquid) {
            return new ScanResult(true, pos, liquid);
        }
    }
}

