/*
 * Decompiled with CFR 0.152.
 */
package zadudoder.spmhelper.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zadudoder.spmhelper.utils.types.Card;

public class SPWorldsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPWorldsApi.class);
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final String API_URL = "https://spworlds.ru/api/public/";

    public static int getBalance(Card card) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://spworlds.ru/api/public/card")).header("Authorization", SPWorldsApi.getAuthorizationHeader(card)).timeout(Duration.ofSeconds(10L)).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("HTTP error: " + response.statusCode());
            }
            JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
            return json.get("balance").getAsInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static JsonObject createTransfer(Card senderCard, String receiverCardNumber, int amount, String comment) {
        try {
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("receiver", receiverCardNumber);
            requestBody.addProperty("amount", (Number)amount);
            if (comment.isEmpty()) {
                comment = " ";
            }
            requestBody.addProperty("comment", class_310.method_1551().method_1548().method_1676() + ": " + comment);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://spworlds.ru/api/public/transactions")).header("Authorization", SPWorldsApi.getAuthorizationHeader(senderCard)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return JsonParser.parseString((String)response.body()).getAsJsonObject();
        }
        catch (Exception e) {
            JsonObject error = new JsonObject();
            error.addProperty("error", e.getMessage());
            return error;
        }
    }

    public static JsonObject getCardInfo(Card card) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://spworlds.ru/api/public/card")).header("Authorization", SPWorldsApi.getAuthorizationHeader(card)).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return JsonParser.parseString((String)response.body()).getAsJsonObject();
        }
        catch (Exception e) {
            JsonObject error = new JsonObject();
            error.addProperty("error", e.getMessage());
            return error;
        }
    }

    private static String getAuthorizationHeader(Card card) {
        return "Bearer " + card.getBase64Key();
    }
}

