/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visoressentials.core.client.gui.overlays;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.VRClientPlayer;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlays.framework.screen.VROverlayScreenInScreen;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visoressentials.core.client.mcmodified.AbstractContainerScreenModified;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayContainer
extends VROverlayScreenInScreen<AbstractContainerScreen<?>> {
    public static final String ID = "container";
    private Vector3f sourcePos;
    private Vector3f sourceBlockPos;
    private Entity sourceEntity;
    private final float extraXForBlock = 0.5f;
    private final float extraYForBlock = 0.0f;
    private final float extraZForBlock = 0.5f;
    private long lastManualClose;
    private boolean orientInitialized;

    public VROverlayContainer(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.LOW, 1.0f, null);
    }

    protected void m_7856_() {
    }

    protected boolean updateVisibility() {
        return true;
    }

    protected void onTick() {
        if (this.f_96541_.f_91080_ != null || this.f_96541_.f_91074_ == null) {
            this.setEnabled(false);
            return;
        }
        if (this.f_96541_.f_91074_.f_36096_ == this.f_96541_.f_91074_.f_36095_) {
            this.setEnabled(false);
            return;
        }
        if (!this.isOverlayNearPlayer()) {
            this.setEnabled(false);
            return;
        }
        AbstractContainerScreenModified vrContainer = (AbstractContainerScreenModified)this.screen;
        this.cursorBoundsX = vrContainer.visorEssentials$getEdgeX();
        this.cursorBoundsY = vrContainer.visorEssentials$getEdgeY();
        this.cursorBoundsWidth = vrContainer.visorEssentials$getEdgeWidth();
        this.cursorBoundsHeight = vrContainer.visorEssentials$getEdgeHeight();
        super.onTick();
    }

    public void onUpdatePose(float partialTick) {
        Vector3f newPosition;
        boolean aimedAtBlock;
        boolean aimedAtEntity;
        if (this.orientInitialized) {
            aimedAtEntity = this.sourceEntity != null;
            aimedAtBlock = !aimedAtEntity;
        } else {
            aimedAtEntity = this.f_96541_.f_91077_ instanceof EntityHitResult && (((EntityHitResult)this.f_96541_.f_91077_).m_82443_() instanceof ContainerEntity || ((EntityHitResult)this.f_96541_.f_91077_).m_82443_() instanceof InventoryCarrier || ((EntityHitResult)this.f_96541_.f_91077_).m_82443_() instanceof HasCustomInventoryScreen);
            aimedAtBlock = !aimedAtEntity && this.f_96541_.f_91077_ != null && this.f_96541_.f_91077_.m_6662_() == HitResult.Type.BLOCK;
        }
        PoseElement facingElement = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER).getHmd();
        if (aimedAtBlock || aimedAtEntity || this.sourcePos != null) {
            if (this.sourcePos == null) {
                if (aimedAtEntity) {
                    EntityHitResult entityHitResult = (EntityHitResult)this.f_96541_.f_91077_;
                    this.sourceEntity = entityHitResult.m_82443_();
                    Vector3f pos = this.sourceEntity.m_20318_(partialTick).m_252839_();
                    this.sourcePos = new Vector3f(pos.x, pos.y, pos.z);
                } else {
                    BlockHitResult blockHitResult = (BlockHitResult)this.f_96541_.f_91077_;
                    this.sourcePos = new Vector3f((float)blockHitResult.m_82425_().m_123341_() + 0.5f, (float)blockHitResult.m_82425_().m_123342_() + 0.0f, (float)blockHitResult.m_82425_().m_123343_() + 0.5f);
                    this.sourceBlockPos = new Vector3f((float)blockHitResult.m_82425_().m_123341_(), (float)blockHitResult.m_82425_().m_123342_(), (float)blockHitResult.m_82425_().m_123343_());
                }
            } else if (this.sourceEntity != null && this.sourceEntity.m_6084_()) {
                Vector3f pos = this.sourceEntity.m_20318_(partialTick).m_252839_();
                this.sourcePos = new Vector3f(pos.x, pos.y, pos.z);
            }
            float yPos = this.findYPos(this.sourcePos.y, (float)(aimedAtEntity ? this.sourceEntity.m_20299_((float)partialTick).f_82480_ : (double)this.sourcePos.y + 1.1), VisorAPI.client().getPlayer().getPoseData((PoseDataType)PoseDataType.RENDER).convertPositionFrom((PoseDataType)PoseDataType.ROOM, (Vector3fc)facingElement.getPosition()).y);
            newPosition = new Vector3f(this.sourcePos.x, yPos, this.sourcePos.z);
        } else {
            Vector3f vec3 = new Vector3f(0.0f, 0.0f, -2.0f);
            Vector3fc hmdPos = facingElement.getPosition();
            Vector3f vec32 = facingElement.getCustomVector((Vector3fc)vec3);
            newPosition = new Vector3f(vec32.x / 2.0f + hmdPos.x(), vec32.y / 2.0f + hmdPos.y(), vec32.z / 2.0f + hmdPos.z());
        }
        Vector3fc hmdPos = facingElement.getPosition();
        Vector3f look = new Vector3f();
        look.x = newPosition.x - hmdPos.x();
        look.y = newPosition.y - hmdPos.y();
        look.z = newPosition.z - hmdPos.z();
        float pitch = (float)Math.asin(look.y() / look.length());
        float yaw = (float)(Math.PI + Mth.m_14136_((double)look.x(), (double)look.z()));
        Matrix4f rotation = new Matrix4f().rotationY(yaw);
        Matrix4f tilt = new Matrix4f().rotationX(pitch);
        Matrix4f newRotation = rotation.mul((Matrix4fc)tilt);
        this.getPose().update((Vector3fc)newPosition, (Matrix4fc)newRotation, this.getPose().getScale());
        this.orientInitialized = true;
    }

    public void onEnable() {
        this.f_96541_.f_91074_.f_36096_ = ((AbstractContainerScreen)this.screen).m_6262_();
        VRKeyboardAccessor keyboard = VisorAPI.client().getGuiManager().getOverlayManager().getKeyboardAccessor();
        if (keyboard.getAttachedTo() == this) {
            keyboard.setVisible(false);
        }
    }

    public void onDisable() {
        if (this.screen != null) {
            ((AbstractContainerScreen)this.screen).m_7379_();
            ((AbstractContainerScreen)this.screen).m_7861_();
            this.screen = null;
            this.sourcePos = null;
            this.sourceBlockPos = null;
            this.sourceEntity = null;
            this.orientInitialized = false;
        }
    }

    private boolean isOverlayNearPlayer() {
        Vector3fc hmdPos;
        if (this.sourcePos == null) {
            return true;
        }
        VRClientPlayer clientPlayer = VisorAPI.client().getPlayer();
        Vector3f roomPos = clientPlayer.getPoseData(PoseDataType.ROOM).convertPositionFrom(PoseDataType.PRE_TICK, (Vector3fc)this.sourcePos);
        double distance = roomPos.sub(hmdPos = clientPlayer.getPoseData(PoseDataType.ROOM).getHmd().getPosition()).length();
        return distance < 4.0;
    }

    private float findYPos(float lowerBound, float upperBound, float hmdPos) {
        return Math.max(lowerBound, Math.min(hmdPos, upperBound)) + 0.25f * this.getPose().getScale();
    }

    public void openMenu(AbstractContainerScreen<?> newScreen) {
        ((AbstractContainerScreenModified)newScreen).visorEssentials$setVRContainer(true);
        this.screen = newScreen;
        if (this.isEnabled()) {
            this.sourcePos = null;
            this.sourceBlockPos = null;
            this.sourceEntity = null;
            this.orientInitialized = false;
            this.onEnable();
        } else {
            this.setEnabled(true);
        }
        ((AbstractContainerScreen)this.screen).m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.updatePose(1.0f);
    }

    public boolean isAttachedTo(BlockPos blockPos) {
        if (this.sourceBlockPos == null) {
            return false;
        }
        return this.sourceBlockPos.x == (float)blockPos.m_123341_() && this.sourceBlockPos.y == (float)blockPos.m_123342_() && this.sourceBlockPos.z == (float)blockPos.m_123343_();
    }

    public Vector3f getSourcePos() {
        return this.sourcePos;
    }

    public Vector3f getSourceBlockPos() {
        return this.sourceBlockPos;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public long getLastManualClose() {
        return this.lastManualClose;
    }

    public void setLastManualClose(long lastManualClose) {
        this.lastManualClose = lastManualClose;
    }
}

