/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visoressentials.core.client.gui.overlays;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.events.AllowClientFeatureVREvent;
import me.phoenixra.visor.api.client.gui.VRCursorHandler;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlay.VROverlay;
import me.phoenixra.visor.api.client.gui.overlay.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlay.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.overlay.framework.screen.VROverlayScreenInScreen;
import me.phoenixra.visor.api.client.gui.overlay.template.framework.VROverlayTemplateScreenInScreen;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.eventbus.listener.VREventHandler;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayDraggedItem
extends VROverlayScreen
implements VREventListener {
    public static final String ID = "dragged_item";
    private Vector3f orientPosOffset = new Vector3f(0.0f, 0.0f, -0.6f);
    private Vector3f orientRotationOffset = new Vector3f(0.0f, 0.0f, 0.0f);

    public VROverlayDraggedItem(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.HIGHER, 0.1f);
        this.setEnabled(true);
        this.cursorEdgeX = this.f_96543_ / 2 - 8;
        this.cursorEdgeY = this.f_96544_ / 2 - 8;
        this.cursorEdgeWidth = 16;
        this.cursorEdgeHeight = 16;
        VisorAPI.eventBus().registerListener(owner, (VREventListener)this);
    }

    @VREventHandler
    public void disableWorldHands(AllowClientFeatureVREvent event) {
        ClientFeature featureToDisable;
        ClientFeature clientFeature = featureToDisable = VisorAPI.client().getGuiManager().getCursorHandler().getCursorHand() == ControllerHand.MAIN ? ClientFeature.VR_WORLD_HAND_MAIN : ClientFeature.VR_WORLD_HAND_OFFHAND;
        if (event.getFeature() == featureToDisable && VROverlayDraggedItem.isDraggingItem()) {
            event.setCanceled(true);
        }
    }

    protected void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        VRKeyboardAccessor keyboard = VisorAPI.client().getGuiManager().getOverlayManager().getKeyboardAccessor();
        if (keyboard.isVisible()) {
            keyboard.setVisible(false);
        }
        this.renderFloatingItem(guiGraphics, this.f_96541_.f_91074_.f_36096_.m_142621_(), this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8, null);
    }

    private void renderFloatingItem(GuiGraphics guiGraphics, ItemStack itemStack, int posX, int posY, String string) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280480_(itemStack, posX, posY);
        guiGraphics.m_280302_(this.f_96547_, itemStack, posX, posY, string);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean updateVisibility() {
        VRCursorHandler.CursorResult cursorResult;
        if (!VROverlayDraggedItem.isDraggingItem()) {
            return false;
        }
        VRCursorHandler cursorHandler = VisorAPI.client().getGuiManager().getCursorHandler();
        if (this.supportsDragging(cursorHandler.getFocusedOverlay())) {
            return false;
        }
        if (!VisorAPI.client().getPlayer().getControllerRaw(cursorHandler.getCursorHand()).isTracking()) {
            return false;
        }
        return !this.isVisible() || !this.supportsDragging((cursorResult = cursorHandler.getCursorResult(cursorHandler.getCursorHand(), VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER), it -> it != this, false)).focusedOverlay());
    }

    public void updatePose(float partialTicks) {
        PoseAnchor anchor = VisorAPI.client().getGuiManager().getCursorHandler().getCursorHand() == ControllerHand.MAIN ? PoseAnchor.MAIN_HAND : PoseAnchor.OFFHAND;
        VROverlayHelper.applyPose((VROverlay)this, (PoseAnchor)anchor, (PoseAnchor)anchor, (float)1.0f, (boolean)true, (Vector3fc)this.orientPosOffset, (Vector3fc)this.orientRotationOffset);
    }

    public boolean m_6375_(double d, double e, int i) {
        AbstractContainerMenu abstractContainerMenu = this.f_96541_.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
            CreativeModeInventoryScreen.ItemPickerMenu itemPickerMenu = (CreativeModeInventoryScreen.ItemPickerMenu)abstractContainerMenu;
            if (i == 0) {
                this.f_96541_.f_91074_.m_36176_(itemPickerMenu.m_142621_(), true);
                this.f_96541_.f_91072_.m_105239_(itemPickerMenu.m_142621_());
                itemPickerMenu.m_142503_(ItemStack.f_41583_);
            }
            if (i == 1) {
                ItemStack itemstack5 = itemPickerMenu.m_142621_().m_41620_(1);
                this.f_96541_.f_91074_.m_36176_(itemstack5, true);
                this.f_96541_.f_91072_.m_105239_(itemstack5);
            }
        } else {
            this.f_96541_.f_91072_.m_171799_(this.f_96541_.f_91074_.f_36096_.f_38840_, -999, i, ClickType.PICKUP, (Player)this.f_96541_.f_91074_);
        }
        return true;
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    private boolean supportsDragging(VROverlay overlay) {
        VROverlayScreenInScreen screenInScreen;
        if (overlay != null && overlay.getId().equals("game_screen") && this.f_96541_.f_91080_ instanceof AbstractContainerScreen) {
            return true;
        }
        if (overlay instanceof VROverlayScreenInScreen && (screenInScreen = (VROverlayScreenInScreen)overlay).getScreen() instanceof AbstractContainerScreen) {
            return true;
        }
        return overlay instanceof VROverlayTemplateScreenInScreen && (screenInScreen = (VROverlayTemplateScreenInScreen)overlay).getScreen() instanceof AbstractContainerScreen;
    }

    public static boolean isDraggingItem() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.f_36096_ != null && mc.f_91074_.f_36096_.m_142621_() != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_();
    }
}

