/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visoressentials.core.client.gui.screens;

import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class VRInvEffectInvScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    protected boolean fullInventory;
    protected boolean hasEffects;

    public VRInvEffectInvScreen(AbstractContainerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderEffects(guiGraphics, mouseX, mouseY);
    }

    private void renderEffects(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int startPos = this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - (startPos -= -(this.fullInventory ? 0 : 36));
        Collection collection = this.f_96541_.f_91074_.m_21220_();
        if (!collection.isEmpty() && j >= 32) {
            boolean bl = j >= 120;
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            List iterable = Ordering.natural().sortedCopy((Iterable)collection);
            this.hasEffects = iterable.iterator().hasNext();
            this.renderBackgrounds(guiGraphics, startPos, k, iterable, bl);
            this.renderIcons(guiGraphics, startPos, k, iterable, bl);
            if (bl) {
                this.renderLabels(guiGraphics, startPos, k, iterable);
            } else if (mouseX >= startPos && mouseX <= startPos + 33) {
                int l = this.f_97736_;
                MobEffectInstance mobEffectInstance = null;
                for (MobEffectInstance mobEffectInstance2 : iterable) {
                    if (mouseY >= l && mouseY <= l + k) {
                        mobEffectInstance = mobEffectInstance2;
                    }
                    l += k;
                }
                if (mobEffectInstance != null) {
                    List<Component> list = List.of(this.getEffectName(mobEffectInstance), MobEffectUtil.m_267641_(mobEffectInstance, (float)1.0f));
                    guiGraphics.m_280677_(this.f_96547_, list, Optional.empty(), mouseX, mouseY);
                }
            }
        } else {
            this.hasEffects = false;
        }
    }

    private void renderBackgrounds(GuiGraphics guiGraphics, int renderX, int yOffset, Iterable<MobEffectInstance> effects, boolean isSmall) {
        int i = this.f_97736_;
        for (MobEffectInstance mobEffectInstance : effects) {
            if (isSmall) {
                guiGraphics.m_280218_(f_97725_, renderX, i, 0, 166, 120, 32);
            } else {
                guiGraphics.m_280218_(f_97725_, renderX, i, 0, 198, 32, 32);
            }
            i += yOffset;
        }
    }

    private void renderIcons(GuiGraphics guiGraphics, int renderX, int yOffset, Iterable<MobEffectInstance> effects, boolean isSmall) {
        MobEffectTextureManager mobEffectTextureManager = this.f_96541_.m_91306_();
        int i = this.f_97736_;
        for (MobEffectInstance mobEffectInstance : effects) {
            MobEffect mobEffect = mobEffectInstance.m_19544_();
            TextureAtlasSprite textureAtlasSprite = mobEffectTextureManager.m_118732_(mobEffect);
            guiGraphics.m_280159_(renderX + (isSmall ? 6 : 7), i + 7, 0, 18, 18, textureAtlasSprite);
            i += yOffset;
        }
    }

    private void renderLabels(GuiGraphics guiGraphics, int renderX, int yOffset, Iterable<MobEffectInstance> effects) {
        int i = this.f_97736_;
        for (MobEffectInstance mobEffectInstance : effects) {
            Component component = this.getEffectName(mobEffectInstance);
            guiGraphics.m_280430_(this.f_96547_, component, renderX + 10 + 18, i + 6, 0xFFFFFF);
            Component component2 = MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f);
            guiGraphics.m_280430_(this.f_96547_, component2, renderX + 10 + 18, i + 6 + 10, 0x7F7F7F);
            i += yOffset;
        }
    }

    private Component getEffectName(MobEffectInstance effect) {
        MutableComponent mutableComponent = effect.m_19544_().m_19482_().m_6881_();
        if (effect.m_19564_() >= 1 && effect.m_19564_() <= 9) {
            MutableComponent var10000 = mutableComponent.m_7220_(CommonComponents.f_263701_);
            int var10001 = effect.m_19564_();
            var10000.m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }

    public boolean canSeeEffects() {
        int i = this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - i;
        return j >= 32;
    }

    public void setFullInventory(boolean fullInventory) {
        this.fullInventory = fullInventory;
    }

    public boolean isFullInventory() {
        return this.fullInventory;
    }
}

