/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.client;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BladeProtector {
    private static boolean isProtectedBlade(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            String displayName = stack.m_41786_().getString();
            return displayName.contains("\u65e0\u94ed") && displayName.contains("\u6709\u540d");
        }
        return false;
    }

    private static boolean isSlashBladeEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        String className = entity.getClass().getName().toLowerCase();
        if (!(className.contains("slashblade") || className.contains("blade") || className.contains("sword"))) {
            String customName;
            if (entity.m_8077_() && (customName = entity.m_7770_().getString()).contains("\u65e0\u94ed") && customName.contains("\u6709\u540d")) {
                return true;
            }
            return entity.m_19880_().contains("shizuku:protected_blade");
        }
        return true;
    }

    private static void fixSilenceWitherBladeEffects(ItemStack stack) {
        try {
            if (stack.m_41782_()) {
                CompoundTag sbTag;
                String[] silenceWitherTags;
                CompoundTag tag = stack.m_41783_();
                if (tag.m_128441_("shizuku:silence_wither_repaired")) {
                    long lastRepairTime = tag.m_128454_("shizuku:last_repaired_time");
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastRepairTime < 5000L) {
                        return;
                    }
                }
                boolean needsRepair = false;
                for (String badTag : silenceWitherTags = new String[]{"silence_wither_damage", "wither_damage", "silence_damage", "silence_wither:corrupted", "silence_wither:weakened", "silence_wither:damaged", "silence_wither:modified", "silence_wither:cursed", "silence_wither:tainted"}) {
                    if (!tag.m_128441_(badTag)) continue;
                    needsRepair = true;
                    break;
                }
                if (tag.m_128441_("SlashBlade")) {
                    sbTag = tag.m_128469_("SlashBlade");
                    if (sbTag.m_128441_("KillCount") && sbTag.m_128451_("KillCount") < 0) {
                        needsRepair = true;
                    }
                    if (sbTag.m_128441_("ProudSoul") && sbTag.m_128451_("ProudSoul") < 0) {
                        needsRepair = true;
                    }
                    if (sbTag.m_128441_("RepairCount") && sbTag.m_128451_("RepairCount") < 0) {
                        needsRepair = true;
                    }
                    if (sbTag.m_128441_("Refine") && sbTag.m_128451_("Refine") < 0) {
                        needsRepair = true;
                    }
                }
                if (!needsRepair) {
                    return;
                }
                tag.m_128473_("shizuku:silence_wither_protected");
                tag.m_128473_("silence_wither_protected");
                tag.m_128473_("silence_wither_damage");
                tag.m_128473_("wither_damage");
                tag.m_128473_("silence_damage");
                tag.m_128473_("net.wzz.silence_wither");
                tag.m_128473_("silence_wither");
                tag.m_128473_("silence_wither:corrupted");
                tag.m_128473_("silence_wither:weakened");
                tag.m_128473_("silence_wither:damaged");
                tag.m_128473_("silence_wither:modified");
                tag.m_128473_("silence_wither:cursed");
                tag.m_128473_("silence_wither:tainted");
                tag.m_128473_("SilenceWither");
                tag.m_128473_("wzz_silence_wither");
                tag.m_128473_("wzz_wither");
                tag.m_128473_("corruption");
                tag.m_128473_("tainted");
                tag.m_128473_("cursed");
                tag.m_128473_("debuffed");
                tag.m_128473_("weakened");
                tag.m_128473_("damaged");
                tag.m_128473_("silence_wither:corruption_level");
                tag.m_128473_("silence_wither:corruption_source");
                tag.m_128473_("silence_wither:effect_duration");
                tag.m_128473_("silence_wither:effect_amplifier");
                tag.m_128473_("silence_wither:last_hit_by_wither");
                tag.m_128473_("silence_wither:wither_curse");
                tag.m_128473_("silence_wither:wither_decay");
                tag.m_128473_("silence_wither:wither_aura");
                tag.m_128473_("silence_wither:wither_mark");
                tag.m_128473_("silence_wither:wither_essence");
                tag.m_128473_("silence_wither:wither_soul");
                tag.m_128473_("silence_wither:wither_fragment");
                tag.m_128473_("silence_wither:wither_shard");
                tag.m_128473_("silence_wither:wither_power");
                tag.m_128473_("silence_wither:wither_touch");
                tag.m_128473_("silence_wither:wither_blast");
                tag.m_128473_("silence_wither:wither_storm");
                tag.m_128473_("silence_wither:wither_effect");
                tag.m_128473_("silence_wither:wither_damage");
                tag.m_128473_("silence_wither:wither_debuff");
                tag.m_128473_("silence_wither:wither_curse_level");
                tag.m_128473_("silence_wither:wither_curse_source");
                tag.m_128473_("silence_wither:wither_curse_duration");
                tag.m_128473_("silence_wither:wither_curse_amplifier");
                tag.m_128473_("silence_wither:wither_curse_active");
                if (tag.m_128441_("SlashBlade")) {
                    sbTag = tag.m_128469_("SlashBlade");
                    if (sbTag.m_128441_("KillCount") && sbTag.m_128451_("KillCount") < 0) {
                        sbTag.m_128405_("KillCount", 0);
                    }
                    if (sbTag.m_128441_("ProudSoul") && sbTag.m_128451_("ProudSoul") < 0) {
                        sbTag.m_128405_("ProudSoul", 0);
                    }
                    if (sbTag.m_128441_("RepairCount") && sbTag.m_128451_("RepairCount") < 0) {
                        sbTag.m_128405_("RepairCount", 0);
                    }
                    if (sbTag.m_128441_("Refine") && sbTag.m_128451_("Refine") < 0) {
                        sbTag.m_128405_("Refine", 0);
                    }
                    if (!sbTag.m_128441_("Attack") || sbTag.m_128457_("Attack") < 1.0f) {
                        sbTag.m_128350_("Attack", 1.0f);
                    }
                    if (!sbTag.m_128441_("BaseAttackModifier") || sbTag.m_128457_("BaseAttackModifier") < 0.0f) {
                        sbTag.m_128350_("BaseAttackModifier", 0.0f);
                    }
                    if (!sbTag.m_128441_("CurrentMaxAttack") || sbTag.m_128457_("CurrentMaxAttack") < 1.0f) {
                        sbTag.m_128350_("CurrentMaxAttack", 1.0f);
                    }
                    if (!sbTag.m_128441_("MaxAttack") || sbTag.m_128457_("MaxAttack") < 1.0f) {
                        sbTag.m_128350_("MaxAttack", 1.0f);
                    }
                    if (!sbTag.m_128441_("Rank") || sbTag.m_128451_("Rank") < 0) {
                        sbTag.m_128405_("Rank", 0);
                    }
                    if (!sbTag.m_128441_("SpecialAttack") || sbTag.m_128457_("SpecialAttack") < 0.0f) {
                        sbTag.m_128350_("SpecialAttack", 0.0f);
                    }
                    if (!sbTag.m_128441_("TextureName")) {
                        sbTag.m_128359_("TextureName", "slashblade:model/named/nameless.png");
                    }
                    if (!sbTag.m_128441_("TranslationKey")) {
                        sbTag.m_128359_("TranslationKey", "item.slashblade.nameless.famous");
                    }
                    if (sbTag.m_128441_("IsBroken") && sbTag.m_128471_("IsBroken")) {
                        sbTag.m_128379_("IsBroken", false);
                    }
                    if (sbTag.m_128441_("IsSealed") && sbTag.m_128471_("IsSealed")) {
                        sbTag.m_128379_("IsSealed", false);
                    }
                    if (sbTag.m_128441_("IsSoulCorrupted") && sbTag.m_128471_("IsSoulCorrupted")) {
                        sbTag.m_128379_("IsSoulCorrupted", false);
                    }
                    sbTag.m_128356_("shizuku:last_repaired_time", System.currentTimeMillis());
                }
                tag.m_128379_("shizuku:silence_wither_repaired", true);
                tag.m_128356_("shizuku:last_repaired_time", System.currentTimeMillis());
                stack.m_41751_(tag);
                System.out.println("\u00a7a[BladeProtector] \u62d4\u5200\u5251NBT\u4fee\u590d\u5b8c\u6210: " + stack.m_41786_().getString());
            }
        }
        catch (Exception e) {
            System.err.println("\u00a7c[BladeProtector] \u4fee\u590d\u5f52\u5bc2\u51cb\u96f6\u5bf9\u62d4\u5200\u5251\u5f71\u54cd\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)event.player;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                try {
                    CompoundTag tag;
                    if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof ItemSlashBlade)) continue;
                    if (BladeProtector.isProtectedBlade(stack)) {
                        BladeProtector.fixSilenceWitherBladeEffects(stack);
                        tag = stack.m_41784_();
                        tag.m_128379_("shizuku:anti_disarm", true);
                        tag.m_128359_("shizuku:protected_blade", "true");
                        continue;
                    }
                    tag = stack.m_41784_();
                    tag.m_128473_("shizuku:anti_disarm");
                    tag.m_128473_("shizuku:protected_blade");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getEntity().m_32055_();
        if (BladeProtector.isProtectedBlade(stack)) {
            if (player.m_6144_()) {
                return;
            }
            event.setCanceled(true);
            if (!player.m_150109_().m_36063_(stack)) {
                player.m_36356_(stack);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\u8fd9\u628a\u5251\u53d7\u5230\u4fdd\u62a4\uff0c\u6309\u4f4fShift+Q\u624d\u80fd\u4e22\u5f03\uff01"), true);
        }
    }

    private static void protectAllItems(Player player) {
        CompoundTag tag;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (BladeProtector.isProtectedBlade(stack)) {
                BladeProtector.fixSilenceWitherBladeEffects(stack);
                tag = stack.m_41784_();
                tag.m_128379_("shizuku:anti_disarm", true);
                tag.m_128359_("shizuku:protected_blade", "true");
                continue;
            }
            tag = stack.m_41784_();
            tag.m_128473_("shizuku:anti_disarm");
            tag.m_128473_("shizuku:protected_blade");
        }
        ItemStack mainHand = player.m_21205_();
        if (BladeProtector.isProtectedBlade(mainHand)) {
            BladeProtector.fixSilenceWitherBladeEffects(mainHand);
            tag = mainHand.m_41784_();
            tag.m_128379_("shizuku:anti_disarm", true);
            tag.m_128359_("shizuku:protected_blade", "true");
        } else {
            tag = mainHand.m_41784_();
            tag.m_128473_("shizuku:anti_disarm");
            tag.m_128473_("shizuku:protected_blade");
        }
        ItemStack offHand = player.m_21206_();
        if (BladeProtector.isProtectedBlade(offHand)) {
            BladeProtector.fixSilenceWitherBladeEffects(offHand);
            tag = offHand.m_41784_();
            tag.m_128379_("shizuku:anti_disarm", true);
            tag.m_128359_("shizuku:protected_blade", "true");
        } else {
            tag = offHand.m_41784_();
            tag.m_128473_("shizuku:anti_disarm");
            tag.m_128473_("shizuku:protected_blade");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            BladeProtector.protectAllItems(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            BladeProtector.protectAllItems(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            BladeProtector.protectAllItems(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingEvent(LivingEvent.LivingTickEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).m_21223_() <= 2.0f) {
            BladeProtector.protectAllItems(player);
        }
    }
}

