/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.client;

import com.buwan.shizuku.core.JVMFeatureManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JVMChatCommand {
    private static final String JVM_COMMAND_PREFIX = "/shizuku jvm";
    private static final String JVM_SHORT_COMMAND_PREFIX = "/shizuku jvm";
    private static final String[] AVAILABLE_FEATURES = new String[]{"JVM_CORE", "CLASS_HELPER", "PLATFORM_INFO", "SHELLCODE_EXEC", "COREMOD_HELPER", "CLASS_OPTION"};

    @SubscribeEvent
    public static void onClientChat(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.startsWith("/shizuku jvm") || message.startsWith("/shizuku jvm")) {
            event.setCanceled(true);
            JVMChatCommand.handleJVMChatCommand(message);
        }
    }

    private static void handleJVMChatCommand(String message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        String command = message;
        if (message.startsWith("/shizuku jvm")) {
            command = message.substring("/shizuku jvm".length()).trim();
        } else if (message.startsWith("/shizuku jvm")) {
            command = message.substring("/shizuku jvm".length()).trim();
        }
        if (command.isEmpty()) {
            JVMChatCommand.showJVMHelp(mc);
            return;
        }
        String[] parts = command.split("\\s+");
        String action = parts[0].toLowerCase();
        try {
            switch (action) {
                case "help": 
                case "h": {
                    JVMChatCommand.showJVMHelp(mc);
                    break;
                }
                case "status": 
                case "s": {
                    JVMChatCommand.showJVMStatus(mc);
                    break;
                }
                case "reset": 
                case "r": {
                    JVMChatCommand.resetJVMFeatures(mc);
                    break;
                }
                case "stats": 
                case "stat": {
                    JVMChatCommand.showJVMStats(mc);
                    break;
                }
                case "on": {
                    JVMChatCommand.enableAllJVMFeatures(mc);
                    break;
                }
                case "off": {
                    JVMChatCommand.disableAllJVMFeatures(mc);
                    break;
                }
                default: {
                    if (JVMChatCommand.isValidFeature(action.toUpperCase())) {
                        JVMChatCommand.toggleJVMFeature(action.toUpperCase(), mc);
                        break;
                    }
                    JVMChatCommand.showUnknownCommand(mc, action);
                    break;
                }
            }
        }
        catch (Exception e) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7c[JVM\u547d\u4ee4] \u6267\u884c\u547d\u4ee4\u5931\u8d25: " + e.getMessage())));
            System.err.println("\u00a7c[JVM\u804a\u5929\u547d\u4ee4] \u6267\u884c\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void showJVMHelp(Minecraft mc) {
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=== JVM\u529f\u80fd\u5e2e\u52a9 ==="));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u57fa\u7840\u547d\u4ee4:"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm help \u00a7r- \u663e\u793a\u6b64\u5e2e\u52a9"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm status \u00a7r- \u663e\u793a\u529f\u80fd\u72b6\u6001"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm reset \u00a7r- \u91cd\u7f6e\u6240\u6709\u529f\u80fd"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm stats \u00a7r- \u663e\u793a\u4f7f\u7528\u7edf\u8ba1"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm on \u00a7r- \u5f00\u542f\u6240\u6709\u529f\u80fd"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm off \u00a7r- \u5173\u95ed\u6240\u6709\u529f\u80fd"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u529f\u80fd\u5207\u6362:"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77/shizuku jvm <\u529f\u80fd\u540d> \u00a7r- \u5207\u6362\u6307\u5b9a\u529f\u80fd"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u53ef\u7528\u529f\u80fd:"));
        for (String feature : AVAILABLE_FEATURES) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a77- " + feature.toLowerCase())));
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u5feb\u6377\u952e: \u00a77Shift+J \u00a7r- \u4e00\u952e\u5f00\u542f\u6240\u6709\u529f\u80fd"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=================="));
    }

    private static void showJVMStatus(Minecraft mc) {
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=== JVM\u529f\u80fd\u72b6\u6001 ==="));
        String systemStatus = JVMFeatureManager.getJVMSystemStatus();
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eJVM\u7cfb\u7edf: " + systemStatus)));
        for (String feature : AVAILABLE_FEATURES) {
            boolean active = JVMFeatureManager.isFeatureActive(feature);
            String status = active ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed";
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7e" + feature + ": " + status)));
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=================="));
    }

    private static void resetJVMFeatures(Minecraft mc) {
        JVMFeatureManager.resetAllFeatures();
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7a[JVM\u547d\u4ee4] \u6240\u6709\u529f\u80fd\u72b6\u6001\u5df2\u91cd\u7f6e"));
    }

    private static void showJVMStats(Minecraft mc) {
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=== JVM\u529f\u80fd\u7edf\u8ba1 ==="));
        Map<String, Integer> usageCount = JVMFeatureManager.getFeatureUsageCount();
        Map<String, Long> lastUsed = JVMFeatureManager.getFeatureLastUsed();
        for (String feature : AVAILABLE_FEATURES) {
            int count = usageCount.getOrDefault(feature, 0);
            Long lastUsedTime = lastUsed.get(feature);
            Object lastUsedStr = "\u4ece\u672a\u4f7f\u7528";
            if (lastUsedTime != null) {
                long timeDiff = System.currentTimeMillis() - lastUsedTime;
                lastUsedStr = timeDiff < 60000L ? timeDiff / 1000L + "\u79d2\u524d" : (timeDiff < 3600000L ? timeDiff / 60000L + "\u5206\u949f\u524d" : timeDiff / 3600000L + "\u5c0f\u65f6\u524d");
            }
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7e" + feature + ": \u00a7r\u4f7f\u7528" + count + "\u6b21, \u6700\u540e\u4f7f\u7528: " + (String)lastUsedStr)));
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76=================="));
    }

    private static void enableAllJVMFeatures(Minecraft mc) {
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76[JVM\u547d\u4ee4] \u6b63\u5728\u5f00\u542f\u6240\u6709JVM\u529f\u80fd..."));
        for (String feature : AVAILABLE_FEATURES) {
            try {
                JVMFeatureManager.toggleJVMFeature(feature, (Player)mc.f_91074_);
                Thread.sleep(100L);
            }
            catch (Exception e) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7c[JVM\u547d\u4ee4] \u5f00\u542f " + feature + " \u5931\u8d25: " + e.getMessage())));
            }
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7a[JVM\u547d\u4ee4] \u6240\u6709JVM\u529f\u80fd\u5df2\u5f00\u542f"));
    }

    private static void disableAllJVMFeatures(Minecraft mc) {
        JVMFeatureManager.resetAllFeatures();
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[JVM\u547d\u4ee4] \u6240\u6709JVM\u529f\u80fd\u5df2\u5173\u95ed"));
    }

    private static void toggleJVMFeature(String featureName, Minecraft mc) {
        JVMFeatureManager.toggleJVMFeature(featureName, (Player)mc.f_91074_);
    }

    private static void showUnknownCommand(Minecraft mc, String command) {
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7c[JVM\u547d\u4ee4] \u672a\u77e5\u547d\u4ee4: " + command)));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528 /shizuku jvm help \u67e5\u770b\u5e2e\u52a9"));
    }

    private static boolean isValidFeature(String featureName) {
        for (String feature : AVAILABLE_FEATURES) {
            if (!feature.equalsIgnoreCase(featureName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJVMCommand(String message) {
        return message.startsWith("/shizuku jvm") || message.startsWith("/shizuku jvm");
    }

    public static String[] getAllJVMCommands() {
        return new String[]{"/shizuku jvm", "/shizuku jvm help", "/shizuku jvm status", "/shizuku jvm reset", "/shizuku jvm stats", "/shizuku jvm on", "/shizuku jvm off"};
    }

    public static String[] getAllAvailableFeatures() {
        return (String[])AVAILABLE_FEATURES.clone();
    }
}

