/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.client;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class KeybindHelpCommand {
    private static final String HELP_COMMAND = "/shizuku help";
    private static final String SIMPLIFIED_COMMAND = "/shizuku simplified";

    @SubscribeEvent
    public static void onClientChat(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.equalsIgnoreCase(HELP_COMMAND)) {
            event.setCanceled(true);
            KeybindHelpCommand.showGeneralHelp();
        } else if (message.equalsIgnoreCase(SIMPLIFIED_COMMAND)) {
            event.setCanceled(true);
            KeybindHelpCommand.showSimplifiedHelp();
        }
    }

    private static void showGeneralHelp() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7d=== Shizuku \u6a21\u7ec4\u5e2e\u52a9 ==="));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e/shizuku help\u00a7r - \u663e\u793a\u6b64\u5e2e\u52a9\u4fe1\u606f"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e/shizuku simplified\u00a7r - \u663e\u793a\u7b80\u5316\u5feb\u6377\u952e\u5e2e\u52a9"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7d========================"));
    }

    private static void showSimplifiedHelp() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7d=== \u7b80\u5316\u5feb\u6377\u952e\u5e2e\u52a9 ==="));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u7b80\u5316\u5feb\u6377\u952e\u7cfb\u7edf\uff0c\u53ea\u5305\u542b\u4e24\u4e2a\u6838\u5fc3\u5feb\u6377\u952e"));
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        try {
            Class<?> simplifiedSystemClass = Class.forName("com.buwan.shizuku.client.SimplifiedKeybindSystem");
            Object helpText = simplifiedSystemClass.getMethod("getSimplifiedKeybindHelp", new Class[0]).invoke(null, new Object[0]);
            if (helpText != null) {
                String[] lines;
                for (String line : lines = helpText.toString().split("\n")) {
                    if (line.startsWith("\u00a7")) {
                        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)line));
                        continue;
                    }
                    mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7r" + line)));
                }
            }
        }
        catch (Exception e) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u65e0\u6cd5\u52a0\u8f7d\u7b80\u5316\u5feb\u6377\u952e\u5e2e\u52a9\u4fe1\u606f"));
        }
        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7d========================"));
    }

    public static boolean isHelpCommand(String message) {
        return message.equalsIgnoreCase(HELP_COMMAND) || message.equalsIgnoreCase(SIMPLIFIED_COMMAND);
    }

    public static String[] getAllHelpCommands() {
        return new String[]{HELP_COMMAND, SIMPLIFIED_COMMAND};
    }
}

