/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.client;

import com.buwan.shizuku.core.AdvancedProtectionSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SimplifiedKeybindSystem {
    private static final Map<String, Boolean> keybindStates = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Long> lastPressTime = new ConcurrentHashMap<String, Long>();
    private static final long PRESS_COOLDOWN = 200L;
    private static final Map<String, Integer> COMBINATION_KEYBINDS = Map.of("pk_mode", 82, "ofl_mode", 74);
    private static final Map<String, String> COMBINATION_KEYBIND_DESCRIPTIONS = Map.of("pk_mode", "SuperBadCore", "ofl_mode", "EntityEraser+AllReturn+JVM\u529f\u80fd");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        boolean isShiftPressed;
        if (event.getAction() != 1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null) {
            return;
        }
        int keyCode = event.getKey();
        long currentTime = System.currentTimeMillis();
        boolean bl = isShiftPressed = GLFW.glfwGetKey((long)mc.m_91268_().m_85439_(), (int)340) == 1 || GLFW.glfwGetKey((long)mc.m_91268_().m_85439_(), (int)344) == 1;
        if (isShiftPressed) {
            for (Map.Entry<String, Integer> entry : COMBINATION_KEYBINDS.entrySet()) {
                Long lastTime;
                String action = entry.getKey();
                int key = entry.getValue();
                if (keyCode != key || (lastTime = lastPressTime.get(action)) != null && currentTime - lastTime < 200L) continue;
                lastPressTime.put(action, currentTime);
                SimplifiedKeybindSystem.handleCombinationKeybindAction(action, mc);
                break;
            }
        }
    }

    private static void handleCombinationKeybindAction(String action, Minecraft mc) {
        if (!SimplifiedKeybindSystem.isHoldingUnnamedBlade(mc)) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[\u5feb\u6377\u952e] \u53ea\u6709\u624b\u6301\u65e0\u94ed\u6709\u540d\u62d4\u5200\u5251\u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd\uff01"));
            return;
        }
        switch (action) {
            case "pk_mode": {
                SimplifiedKeybindSystem.togglePKMode(mc);
                break;
            }
            case "ofl_mode": {
                SimplifiedKeybindSystem.toggleOFLMode(mc);
            }
        }
    }

    private static boolean isHoldingUnnamedBlade(Minecraft mc) {
        try {
            if (mc.f_91074_ == null) {
                return false;
            }
            ItemStack mainHand = mc.f_91074_.m_21205_();
            ItemStack offHand = mc.f_91074_.m_21206_();
            if (SimplifiedKeybindSystem.isUnnamedBlade(mainHand)) {
                return true;
            }
            return SimplifiedKeybindSystem.isUnnamedBlade(offHand);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] \u68c0\u67e5\u624b\u6301\u7269\u54c1\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    private static boolean isUnnamedBlade(ItemStack itemStack) {
        try {
            if (itemStack == null || itemStack.m_41619_()) {
                return false;
            }
            Item item = itemStack.m_41720_();
            if (item == null) {
                return false;
            }
            String className = item.getClass().getName();
            if (!className.contains("slashblade") && !className.contains("SlashBlade")) {
                return false;
            }
            Component displayName = itemStack.m_41786_();
            if (displayName == null) {
                return false;
            }
            String name = displayName.getString();
            if (name == null || name.isEmpty()) {
                return false;
            }
            String lowerName = name.toLowerCase();
            return name.contains("\u65e0\u94ed") && name.contains("\u6709\u540d") || lowerName.contains("nameless famous");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void togglePKMode(Minecraft mc) {
        AdvancedProtectionSystem.toggleProtectionMode("SUPER_BAD_CORE", (Player)mc.f_91074_);
        boolean currentState = keybindStates.get("pk_mode");
        keybindStates.put("pk_mode", !currentState);
        System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] \u73a9\u5bb6 " + mc.f_91074_.m_7755_().getString() + " \u5207\u6362SuperBadCore: " + (!currentState ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    private static void toggleOFLMode(Minecraft mc) {
        boolean newState;
        if (!SimplifiedKeybindSystem.isPlayerHoldingNamelessBlade((Player)mc.f_91074_)) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[\u5feb\u6377\u952e\u7cfb\u7edf] \u9700\u8981\u62ff\u7740\u65e0\u94ed\u6709\u540d\u62d4\u5200\u5251\u624d\u80fd\u6fc0\u6d3b\u6b64\u529f\u80fd"));
            return;
        }
        boolean currentState = keybindStates.get("ofl_mode");
        boolean bl = newState = !currentState;
        if (newState) {
            AdvancedProtectionSystem.toggleProtectionMode("ENTITY_ERASER", (Player)mc.f_91074_);
            AdvancedProtectionSystem.toggleProtectionMode("ALLRETURN", (Player)mc.f_91074_);
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("initialize", new Class[0]).invoke(entityEraserManager, new Object[0]);
                entityEraserManagerClass.getMethod("activateBothFeatures", Player.class).invoke(entityEraserManager, mc.f_91074_);
                System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] EntityEraser\u529f\u80fd\u5df2\u6fc0\u6d3b");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[\u5feb\u6377\u952e\u7cfb\u7edf] \u6fc0\u6d3bEntityEraser\u529f\u80fd\u5931\u8d25: " + e.getMessage());
            }
            try {
                Class<?> jvmManagerClass = Class.forName("com.buwan.shizuku.core.JVMFeatureManager");
                Object jvmManager = jvmManagerClass.newInstance();
                jvmManagerClass.getMethod("toggleJVMFeature", String.class, Player.class).invoke(null, "JVM_CORE", mc.f_91074_);
                jvmManagerClass.getMethod("toggleJVMFeature", String.class, Player.class).invoke(null, "CLASS_HELPER", mc.f_91074_);
                jvmManagerClass.getMethod("toggleJVMFeature", String.class, Player.class).invoke(null, "PLATFORM_INFO", mc.f_91074_);
                System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] JVM\u529f\u80fd\u5df2\u6fc0\u6d3b");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[\u5feb\u6377\u952e\u7cfb\u7edf] \u6fc0\u6d3bJVM\u529f\u80fd\u5931\u8d25: " + e.getMessage());
            }
        } else {
            AdvancedProtectionSystem.toggleProtectionMode("ENTITY_ERASER", (Player)mc.f_91074_);
            AdvancedProtectionSystem.toggleProtectionMode("ALLRETURN", (Player)mc.f_91074_);
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("deactivateBothFeatures", Player.class).invoke(entityEraserManager, mc.f_91074_);
                System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] EntityEraser\u529f\u80fd\u5df2\u5173\u95ed");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[\u5feb\u6377\u952e\u7cfb\u7edf] \u5173\u95edEntityEraser\u529f\u80fd\u5931\u8d25: " + e.getMessage());
            }
            try {
                Class<?> jvmManagerClass = Class.forName("com.buwan.shizuku.core.JVMFeatureManager");
                jvmManagerClass.getMethod("resetAllFeatures", new Class[0]).invoke(null, new Object[0]);
                System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] JVM\u529f\u80fd\u5df2\u5173\u95ed");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[\u5feb\u6377\u952e\u7cfb\u7edf] \u5173\u95edJVM\u529f\u80fd\u5931\u8d25: " + e.getMessage());
            }
        }
        keybindStates.put("ofl_mode", newState);
        System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] \u73a9\u5bb6 " + mc.f_91074_.m_7755_().getString() + " \u5207\u6362EntityEraser+AllReturn+JVM\u529f\u80fd: " + (newState ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    private static boolean isPlayerHoldingNamelessBlade(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41619_()) {
            return false;
        }
        String itemId = mainHandItem.m_41720_().toString().toLowerCase();
        String itemName = mainHandItem.m_41611_().getString().toLowerCase();
        boolean isSlashBlade = itemId.contains("slashblade") || itemId.contains("slash_blade") || itemId.contains("blade") || itemName.contains("\u5200") || itemName.contains("blade");
        boolean isNameless = itemName.contains("\u65e0\u94ed") || itemName.contains("\u6709\u540d") || itemName.contains("nameless") || itemName.contains("famous");
        return isSlashBlade && isNameless;
    }

    public static boolean isKeybindActive(String action) {
        return keybindStates.getOrDefault(action, false);
    }

    public static Map<String, Boolean> getAllKeybindStates() {
        return new HashMap<String, Boolean>(keybindStates);
    }

    public static void resetAllKeybinds() {
        keybindStates.clear();
        COMBINATION_KEYBINDS.keySet().forEach(key -> keybindStates.put((String)key, false));
        System.out.println("\u00a7d[\u5feb\u6377\u952e\u7cfb\u7edf] \u6240\u6709\u5feb\u6377\u952e\u72b6\u6001\u5df2\u91cd\u7f6e");
    }

    public static String getSimplifiedKeybindHelp() {
        StringBuilder help = new StringBuilder();
        help.append("\u00a76=== \u5feb\u6377\u952e\u5e2e\u52a9 ===\n");
        for (Map.Entry<String, String> entry : COMBINATION_KEYBIND_DESCRIPTIONS.entrySet()) {
            String key = entry.getKey();
            String description = entry.getValue();
            Integer keyCode = COMBINATION_KEYBINDS.get(key);
            String keyName = SimplifiedKeybindSystem.getKeyName(keyCode);
            help.append("\u00a7e").append(keyName).append(": ").append(description).append("\n");
        }
        help.append("\u00a76==================");
        return help.toString();
    }

    private static String getKeyName(int keyCode) {
        return switch (keyCode) {
            case 82 -> "Shift+R";
            case 74 -> "Shift+J";
            default -> "Unknown";
        };
    }

    static {
        COMBINATION_KEYBINDS.keySet().forEach(key -> keybindStates.put((String)key, false));
    }
}

