/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.command;

import com.buwan.shizuku.core.JVMFeatureManager;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class JVMCommand {
    private static final List<String> AVAILABLE_FEATURES = Arrays.asList("JVM_CORE", "CLASS_HELPER", "PLATFORM_INFO", "SHELLCODE_EXEC", "COREMOD_HELPER", "CLASS_OPTION");
    private static final List<String> AVAILABLE_COMMANDS = Arrays.asList("help", "status", "reset", "stats");

    private static int executeJVMHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            String help = JVMFeatureManager.getFeatureHelp();
            for (String line : help.split("\n")) {
                player.m_213846_((Component)Component.m_237113_((String)line));
            }
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"JVM\u529f\u80fd\u5e2e\u52a9\u4fe1\u606f\u5df2\u53d1\u9001\u5230\u63a7\u5236\u53f0"), false);
            System.out.println(JVMFeatureManager.getFeatureHelp());
        }
        return 1;
    }

    private static int executeJVMStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JVMFeatureManager.executeJVMCommand("status", (Player)player);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"JVM\u529f\u80fd\u72b6\u6001\u5df2\u53d1\u9001\u5230\u63a7\u5236\u53f0"), false);
            System.out.println("=== JVM\u529f\u80fd\u72b6\u6001 ===");
            JVMFeatureManager.getAllFeatureStates().forEach((feature, active) -> {
                String status = active != false ? "\u5f00\u542f" : "\u5173\u95ed";
                System.out.println(feature + ": " + status);
            });
        }
        return 1;
    }

    private static int executeJVMReset(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        JVMFeatureManager.resetAllFeatures();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[JVM\u529f\u80fd] \u6240\u6709\u529f\u80fd\u72b6\u6001\u5df2\u91cd\u7f6e"));
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[JVM\u529f\u80fd] \u6240\u6709\u529f\u80fd\u72b6\u6001\u5df2\u91cd\u7f6e"), false);
        }
        return 1;
    }

    private static int executeJVMStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JVMFeatureManager.executeJVMCommand("stats", (Player)player);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"JVM\u529f\u80fd\u7edf\u8ba1\u5df2\u53d1\u9001\u5230\u63a7\u5236\u53f0"), false);
            System.out.println("=== JVM\u529f\u80fd\u7edf\u8ba1 ===");
            JVMFeatureManager.getFeatureUsageCount().forEach((feature, count) -> {
                Long lastUsed = JVMFeatureManager.getFeatureLastUsed().get(feature);
                Object lastUsedStr = "\u4ece\u672a\u4f7f\u7528";
                if (lastUsed != null) {
                    long timeDiff = System.currentTimeMillis() - lastUsed;
                    lastUsedStr = timeDiff < 60000L ? timeDiff / 1000L + "\u79d2\u524d" : (timeDiff < 3600000L ? timeDiff / 60000L + "\u5206\u949f\u524d" : timeDiff / 3600000L + "\u5c0f\u65f6\u524d");
                }
                System.out.println(feature + ": \u4f7f\u7528" + count + "\u6b21, \u6700\u540e\u4f7f\u7528: " + (String)lastUsedStr);
            });
        }
        return 1;
    }

    private static int executeJVMFeature(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String feature = StringArgumentType.getString(context, (String)"feature").toUpperCase();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JVMFeatureManager.toggleJVMFeature(feature, (Player)player);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"JVM\u529f\u80fd\u5207\u6362\u547d\u4ee4\u5df2\u6267\u884c"), false);
            System.out.println("\u00a7d[JVM\u529f\u80fd] \u63a7\u5236\u53f0\u5207\u6362 " + feature + " \u529f\u80fd");
        }
        return 1;
    }

    private static int executeJVMAction(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String action = StringArgumentType.getString(context, (String)"action");
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JVMFeatureManager.executeJVMCommand(action, (Player)player);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"JVM\u52a8\u4f5c\u547d\u4ee4\u5df2\u6267\u884c"), false);
            System.out.println("\u00a7d[JVM\u529f\u80fd] \u63a7\u5236\u53f0\u6267\u884c\u52a8\u4f5c: " + action);
        }
        return 1;
    }

    private static int executeJVMAdmin(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== JVM\u7ba1\u7406\u5458\u547d\u4ee4 ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/shizuku jvm admin on \u00a7r- \u5f00\u542f\u6240\u6709JVM\u529f\u80fd"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/shizuku jvm admin off \u00a7r- \u5173\u95ed\u6240\u6709JVM\u529f\u80fd"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/shizuku jvm admin status \u00a7r- \u67e5\u770b\u7ba1\u7406\u5458\u72b6\u6001"), false);
        return 1;
    }

    private static int executeJVMAdminOn(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (String feature : AVAILABLE_FEATURES) {
            Entity entity = source.m_81373_();
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            JVMFeatureManager.toggleJVMFeature(feature, (Player)player);
        }
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[JVM\u7ba1\u7406\u5458] \u6240\u6709JVM\u529f\u80fd\u5df2\u5f00\u542f"), false);
        return 1;
    }

    private static int executeJVMAdminOff(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        JVMFeatureManager.resetAllFeatures();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[JVM\u7ba1\u7406\u5458] \u6240\u6709JVM\u529f\u80fd\u5df2\u5173\u95ed"), false);
        return 1;
    }

    private static int executeJVMAdminStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== JVM\u7ba1\u7406\u5458\u72b6\u6001 ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("JVM\u7cfb\u7edf\u72b6\u6001: " + JVMFeatureManager.getJVMSystemStatus())), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u529f\u80fd\u603b\u6570: " + AVAILABLE_FEATURES.size())), false);
        for (String feature : AVAILABLE_FEATURES) {
            boolean active = JVMFeatureManager.isFeatureActive(feature);
            String status = active ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed";
            source.m_288197_(() -> Component.m_237113_((String)(feature + ": " + status)), false);
        }
        return 1;
    }

    private static SuggestionProvider<CommandSourceStack> getFeatureSuggestions() {
        return (context, builder) -> {
            for (String feature : AVAILABLE_FEATURES) {
                builder.suggest(feature.toLowerCase());
            }
            return builder.buildFuture();
        };
    }

    private static SuggestionProvider<CommandSourceStack> getActionSuggestions() {
        return (context, builder) -> {
            for (String action : AVAILABLE_COMMANDS) {
                builder.suggest(action);
            }
            return builder.buildFuture();
        };
    }

    public static boolean isCommandAvailable(String command) {
        return command.equalsIgnoreCase("shizuku jvm") || command.startsWith("/shizuku jvm");
    }

    public static List<String> getAllAvailableCommands() {
        return Arrays.asList("/shizuku jvm", "/shizuku jvm help", "/shizuku jvm status", "/shizuku jvm reset", "/shizuku jvm stats", "/shizuku jvm <\u529f\u80fd\u540d>");
    }

    public static List<String> getAdminCommands() {
        return Arrays.asList("/shizuku jvm admin", "/shizuku jvm admin on", "/shizuku jvm admin off", "/shizuku jvm admin status");
    }
}

