/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.core;

import com.buwan.shizuku.jvm.ApphhzpLibMod;
import com.buwan.shizuku.jvm.ClassOption;
import com.buwan.shizuku.jvm.CoremodHelper;
import com.buwan.shizuku.jvm.PlatformInfo;
import com.buwan.shizuku.jvm.ShellcodeExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JVMFeatureManager {
    private static final Map<String, Boolean> JVM_FEATURE_STATES = new ConcurrentHashMap<String, Boolean>();
    private static final AtomicBoolean JVM_SYSTEM_INITIALIZED = new AtomicBoolean(false);
    private static final AtomicBoolean CLASS_HELPER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean PLATFORM_INFO_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean SHELLCODE_EXEC_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean COREMOD_HELPER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean CLASS_OPTION_ACTIVE = new AtomicBoolean(false);
    private static final Map<String, Integer> FEATURE_USAGE_COUNT = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Long> FEATURE_LAST_USED = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Object> FEATURE_CONFIGS = new ConcurrentHashMap<String, Object>();

    private static void initializeJVMFeatures() {
        try {
            ApphhzpLibMod.initialize();
            JVM_SYSTEM_INITIALIZED.set(true);
            JVM_FEATURE_STATES.put("JVM_CORE", true);
            JVM_FEATURE_STATES.put("CLASS_HELPER", false);
            JVM_FEATURE_STATES.put("PLATFORM_INFO", false);
            JVM_FEATURE_STATES.put("SHELLCODE_EXEC", false);
            JVM_FEATURE_STATES.put("COREMOD_HELPER", false);
            JVM_FEATURE_STATES.put("CLASS_OPTION", false);
            System.out.println("\u00a7d[JVM\u529f\u80fd\u7ba1\u7406\u5668] JVM\u7cfb\u7edf\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u00a7c[JVM\u529f\u80fd\u7ba1\u7406\u5668] JVM\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            JVM_SYSTEM_INITIALIZED.set(false);
        }
    }

    private static void initializeFeatureConfigs() {
        FEATURE_CONFIGS.put("CLASS_HELPER_DEBUG", false);
        FEATURE_CONFIGS.put("CLASS_HELPER_TIMEOUT", 5000);
        FEATURE_CONFIGS.put("PLATFORM_INFO_DETAILED", true);
        FEATURE_CONFIGS.put("PLATFORM_INFO_CACHE", true);
        FEATURE_CONFIGS.put("SHELLCODE_EXEC_SAFE_MODE", true);
        FEATURE_CONFIGS.put("SHELLCODE_EXEC_TIMEOUT", 30000);
        FEATURE_CONFIGS.put("COREMOD_HELPER_AUTO_LOAD", false);
        FEATURE_CONFIGS.put("COREMOD_HELPER_DEBUG", false);
        FEATURE_CONFIGS.put("CLASS_OPTION_PERSISTENT", true);
        FEATURE_CONFIGS.put("CLASS_OPTION_AUTO_SAVE", true);
    }

    public static void toggleJVMFeature(String featureName, Player player) {
        if (!JVM_SYSTEM_INITIALIZED.get()) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[JVM\u529f\u80fd] JVM\u7cfb\u7edf\u672a\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd"), true);
            return;
        }
        boolean currentState = JVM_FEATURE_STATES.getOrDefault(featureName, false);
        boolean newState = !currentState;
        try {
            switch (featureName) {
                case "CLASS_HELPER": {
                    JVMFeatureManager.toggleClassHelper(newState, player);
                    break;
                }
                case "PLATFORM_INFO": {
                    JVMFeatureManager.togglePlatformInfo(newState, player);
                    break;
                }
                case "SHELLCODE_EXEC": {
                    JVMFeatureManager.toggleShellcodeExecutor(newState, player);
                    break;
                }
                case "COREMOD_HELPER": {
                    JVMFeatureManager.toggleCoremodHelper(newState, player);
                    break;
                }
                case "CLASS_OPTION": {
                    JVMFeatureManager.toggleClassOption(newState, player);
                    break;
                }
                case "JVM_CORE": {
                    JVMFeatureManager.toggleJVMCore(newState, player);
                    break;
                }
                default: {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7c[JVM\u529f\u80fd] \u672a\u77e5\u529f\u80fd: " + featureName)), true);
                    return;
                }
            }
            JVM_FEATURE_STATES.put(featureName, newState);
            JVMFeatureManager.updateFeatureUsage(featureName);
            String status = newState ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed";
            player.m_5661_((Component)Component.m_237113_((String)("\u00a76[JVM\u529f\u80fd] " + featureName + ": " + status)), true);
            System.out.println("\u00a7d[JVM\u529f\u80fd\u7ba1\u7406\u5668] \u73a9\u5bb6 " + player.m_7755_().getString() + " \u5207\u6362 " + featureName + ": " + status);
        }
        catch (Exception e) {
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7c[JVM\u529f\u80fd] \u5207\u6362 " + featureName + " \u5931\u8d25: " + e.getMessage())), true);
            System.err.println("\u00a7c[JVM\u529f\u80fd\u7ba1\u7406\u5668] \u5207\u6362\u529f\u80fd\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void toggleClassHelper(boolean enable, Player player) {
        if (enable) {
            CLASS_HELPER_ACTIVE.set(true);
            System.out.println("\u00a7d[JVM\u529f\u80fd] ClassHelper\u529f\u80fd\u5df2\u6fc0\u6d3b");
        } else {
            CLASS_HELPER_ACTIVE.set(false);
            System.out.println("\u00a7d[JVM\u529f\u80fd] ClassHelper\u529f\u80fd\u5df2\u5173\u95ed");
        }
    }

    private static void togglePlatformInfo(boolean enable, Player player) {
        if (enable) {
            PLATFORM_INFO_ACTIVE.set(true);
            if (PlatformInfo.isSupported()) {
                String platformInfo = PlatformInfo.getPlatformDetails();
                String javaFeatures = PlatformInfo.getJavaFeatureSupport();
                player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== \u5e73\u53f0\u4fe1\u606f ==="), false);
                for (String line : platformInfo.split("\n")) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + line)), false);
                }
                player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== Java\u529f\u80fd\u652f\u6301 ==="), false);
                for (String line : javaFeatures.split("\n")) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + line)), false);
                }
            }
        } else {
            PLATFORM_INFO_ACTIVE.set(false);
        }
    }

    private static void toggleShellcodeExecutor(boolean enable, Player player) {
        if (enable) {
            SHELLCODE_EXEC_ACTIVE.set(true);
            if (ShellcodeExecutor.isSupported()) {
                String supportInfo = ShellcodeExecutor.getSupportInfo();
                player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== Shellcode\u6267\u884c\u652f\u6301 ==="), false);
                for (String line : supportInfo.split("\n")) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + line)), false);
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cShellcode\u6267\u884c\u4e0d\u652f\u6301\u5f53\u524d\u5e73\u53f0"), false);
            }
        } else {
            SHELLCODE_EXEC_ACTIVE.set(false);
        }
    }

    private static void toggleCoremodHelper(boolean enable, Player player) {
        if (enable) {
            COREMOD_HELPER_ACTIVE.set(true);
            String stats = CoremodHelper.getLoadingStatistics();
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== Coremod\u52a0\u8f7d\u7edf\u8ba1 ==="), false);
            for (String line : stats.split("\n")) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + line)), false);
            }
        } else {
            COREMOD_HELPER_ACTIVE.set(false);
        }
    }

    private static void toggleClassOption(boolean enable, Player player) {
        if (enable) {
            CLASS_OPTION_ACTIVE.set(true);
            int totalClasses = ClassOption.getAllClassNames().size();
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== \u7c7b\u9009\u9879\u7cfb\u7edf ==="), false);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7e\u5df2\u914d\u7f6e\u7c7b\u6570\u91cf: " + totalClasses)), false);
        } else {
            CLASS_OPTION_ACTIVE.set(false);
        }
    }

    private static void toggleJVMCore(boolean enable, Player player) {
        if (enable) {
            String statusReport = ApphhzpLibMod.getFullStatusReport();
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== JVM\u7cfb\u7edf\u72b6\u6001\u62a5\u544a ==="), false);
            String[] lines = statusReport.split("\n");
            for (int i = 0; i < Math.min(lines.length, 20); ++i) {
                String line = lines[i];
                if (line.startsWith("===")) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a76" + line)), false);
                    continue;
                }
                if (line.contains(":")) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + line)), false);
                    continue;
                }
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7r" + line)), false);
            }
            if (lines.length > 20) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a77... (\u66f4\u591a\u4fe1\u606f\u8bf7\u67e5\u770b\u63a7\u5236\u53f0)"), false);
            }
        }
    }

    private static void updateFeatureUsage(String featureName) {
        FEATURE_USAGE_COUNT.merge(featureName, 1, Integer::sum);
        FEATURE_LAST_USED.put(featureName, System.currentTimeMillis());
    }

    public static boolean isFeatureActive(String featureName) {
        return JVM_FEATURE_STATES.getOrDefault(featureName, false);
    }

    public static Map<String, Boolean> getAllFeatureStates() {
        return new HashMap<String, Boolean>(JVM_FEATURE_STATES);
    }

    public static Map<String, Integer> getFeatureUsageCount() {
        return new HashMap<String, Integer>(FEATURE_USAGE_COUNT);
    }

    public static Map<String, Long> getFeatureLastUsed() {
        return new HashMap<String, Long>(FEATURE_LAST_USED);
    }

    public static void resetAllFeatures() {
        JVM_FEATURE_STATES.clear();
        CLASS_HELPER_ACTIVE.set(false);
        PLATFORM_INFO_ACTIVE.set(false);
        SHELLCODE_EXEC_ACTIVE.set(false);
        COREMOD_HELPER_ACTIVE.set(false);
        CLASS_OPTION_ACTIVE.set(false);
        JVMFeatureManager.initializeJVMFeatures();
        System.out.println("\u00a7d[JVM\u529f\u80fd\u7ba1\u7406\u5668] \u6240\u6709\u529f\u80fd\u72b6\u6001\u5df2\u91cd\u7f6e");
    }

    public static String getFeatureHelp() {
        StringBuilder help = new StringBuilder();
        help.append("\u00a76=== JVM\u529f\u80fd\u5e2e\u52a9 ===\n");
        help.append("\u00a7eJVM_CORE: \u00a7rJVM\u6838\u5fc3\u7cfb\u7edf\u72b6\u6001\n");
        help.append("\u00a7eCLASS_HELPER: \u00a7r\u9ad8\u7ea7\u7c7b\u64cd\u4f5c\u52a9\u624b\n");
        help.append("\u00a7ePLATFORM_INFO: \u00a7r\u5e73\u53f0\u4fe1\u606f\u68c0\u6d4b\n");
        help.append("\u00a7eSHELLCODE_EXEC: \u00a7rShellcode\u6267\u884c\u5668\n");
        help.append("\u00a7eCOREMOD_HELPER: \u00a7rCoremod\u52a0\u8f7d\u52a9\u624b\n");
        help.append("\u00a7eCLASS_OPTION: \u00a7r\u7c7b\u9009\u9879\u914d\u7f6e\u7cfb\u7edf\n");
        help.append("\u00a76==================\n");
        help.append("\u00a77\u4f7f\u7528\u65b9\u6cd5: /shizuku jvm <\u529f\u80fd\u540d> \u6216 Shift+J\n");
        return help.toString();
    }

    public static void executeJVMCommand(String command, Player player) {
        String action;
        String[] parts = command.split("\\s+");
        if (parts.length == 0) {
            return;
        }
        switch (action = parts[0].toLowerCase()) {
            case "help": 
            case "h": {
                String help = JVMFeatureManager.getFeatureHelp();
                for (String line : help.split("\n")) {
                    player.m_5661_((Component)Component.m_237113_((String)line), false);
                }
                break;
            }
            case "status": 
            case "s": {
                JVMFeatureManager.showFeatureStatus(player);
                break;
            }
            case "reset": 
            case "r": {
                JVMFeatureManager.resetAllFeatures();
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7a[JVM\u529f\u80fd] \u6240\u6709\u529f\u80fd\u72b6\u6001\u5df2\u91cd\u7f6e"), true);
                break;
            }
            case "stats": 
            case "stat": {
                JVMFeatureManager.showFeatureStats(player);
                break;
            }
            default: {
                if (JVM_FEATURE_STATES.containsKey(action.toUpperCase())) {
                    JVMFeatureManager.toggleJVMFeature(action.toUpperCase(), player);
                    break;
                }
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c[JVM\u529f\u80fd] \u672a\u77e5\u547d\u4ee4: " + action)), false);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528 /jvm help \u67e5\u770b\u5e2e\u52a9"), false);
            }
        }
    }

    private static void showFeatureStatus(Player player) {
        player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== JVM\u529f\u80fd\u72b6\u6001 ==="), false);
        for (Map.Entry<String, Boolean> entry : JVM_FEATURE_STATES.entrySet()) {
            String feature = entry.getKey();
            boolean active = entry.getValue();
            String status = active ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed";
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + feature + ": " + status)), false);
        }
        player.m_5661_((Component)Component.m_237113_((String)"\u00a76=================="), false);
    }

    private static void showFeatureStats(Player player) {
        player.m_5661_((Component)Component.m_237113_((String)"\u00a76=== JVM\u529f\u80fd\u7edf\u8ba1 ==="), false);
        for (Map.Entry<String, Integer> entry : FEATURE_USAGE_COUNT.entrySet()) {
            String feature = entry.getKey();
            int count = entry.getValue();
            Long lastUsed = FEATURE_LAST_USED.get(feature);
            Object lastUsedStr = "\u4ece\u672a\u4f7f\u7528";
            if (lastUsed != null) {
                long timeDiff = System.currentTimeMillis() - lastUsed;
                lastUsedStr = timeDiff < 60000L ? timeDiff / 1000L + "\u79d2\u524d" : (timeDiff < 3600000L ? timeDiff / 60000L + "\u5206\u949f\u524d" : timeDiff / 3600000L + "\u5c0f\u65f6\u524d");
            }
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + feature + ": \u00a7r\u4f7f\u7528" + count + "\u6b21, \u6700\u540e\u4f7f\u7528: " + (String)lastUsedStr)), false);
        }
        player.m_5661_((Component)Component.m_237113_((String)"\u00a76=================="), false);
    }

    public static boolean isJVMSystemAvailable() {
        return JVM_SYSTEM_INITIALIZED.get();
    }

    public static String getJVMSystemStatus() {
        if (JVM_SYSTEM_INITIALIZED.get()) {
            return "\u00a7a\u53ef\u7528";
        }
        return "\u00a7c\u4e0d\u53ef\u7528";
    }

    static {
        JVMFeatureManager.initializeJVMFeatures();
        JVMFeatureManager.initializeFeatureConfigs();
    }
}

