/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.entity;

import com.buwan.shizuku.entity.eraserservice.AllReturnService;
import com.buwan.shizuku.entity.eraserservice.EntityEraserService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEraserManager {
    private static final AtomicBoolean MANAGER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ENTITY_ERASER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ALLRETURN_ACTIVE = new AtomicBoolean(false);
    private static EntityEraserService entityEraserService;
    private static AllReturnService allReturnService;
    private static final Map<String, Integer> FEATURE_USAGE_COUNTS;
    private static final Map<String, Long> FEATURE_ACTIVATION_TIMES;
    private static volatile EntityEraserManager instance;

    private EntityEraserManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntityEraserManager getInstance() {
        if (instance != null) return instance;
        Class<EntityEraserManager> clazz = EntityEraserManager.class;
        synchronized (EntityEraserManager.class) {
            if (instance != null) return instance;
            instance = new EntityEraserManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        if (MANAGER_ACTIVE.compareAndSet(false, true)) {
            try {
                entityEraserService = EntityEraserService.getInstance();
                allReturnService = AllReturnService.getInstance();
                entityEraserService.initialize();
                allReturnService.initialize();
                FEATURE_USAGE_COUNTS.put("ENTITY_ERASER", 0);
                FEATURE_USAGE_COUNTS.put("ALLRETURN", 0);
                ENTITY_ERASER_ACTIVE.set(false);
                ALLRETURN_ACTIVE.set(false);
                System.out.println("\u00a7d[EntityEraserManager] \u7ba1\u7406\u5668\u5df2\u521d\u59cb\u5316\uff08\u529f\u80fd\u672a\u81ea\u52a8\u6fc0\u6d3b\uff09");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
                MANAGER_ACTIVE.set(false);
            }
        }
    }

    public void activateEntityEraser(Player player) {
        block4: {
            try {
                if (entityEraserService != null) {
                    entityEraserService.activateEntityEraser();
                    ENTITY_ERASER_ACTIVE.set(true);
                    FEATURE_USAGE_COUNTS.put("ENTITY_ERASER", FEATURE_USAGE_COUNTS.get("ENTITY_ERASER") + 1);
                    FEATURE_ACTIVATION_TIMES.put("ENTITY_ERASER", System.currentTimeMillis());
                    if (player != null) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7d[EntityEraser] EntityEraser\u529f\u80fd\u5df2\u6fc0\u6d3b"));
                    }
                    System.out.println("\u00a7d[EntityEraserManager] EntityEraser\u529f\u80fd\u5df2\u6fc0\u6d3b");
                }
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u6fc0\u6d3bEntityEraser\u5931\u8d25: " + e.getMessage());
                if (player == null) break block4;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[EntityEraser] \u6fc0\u6d3b\u5931\u8d25: " + e.getMessage())));
            }
        }
    }

    public void deactivateEntityEraser(Player player) {
        block4: {
            try {
                if (entityEraserService != null) {
                    entityEraserService.deactivateEntityEraser();
                    ENTITY_ERASER_ACTIVE.set(false);
                    if (player != null) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7d[EntityEraser] EntityEraser\u529f\u80fd\u5df2\u505c\u7528"));
                    }
                    System.out.println("\u00a7d[EntityEraserManager] EntityEraser\u529f\u80fd\u5df2\u505c\u7528");
                }
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u505c\u7528EntityEraser\u5931\u8d25: " + e.getMessage());
                if (player == null) break block4;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[EntityEraser] \u505c\u7528\u5931\u8d25: " + e.getMessage())));
            }
        }
    }

    public void activateAllReturn(Player player) {
        block4: {
            try {
                if (allReturnService != null) {
                    allReturnService.activateAllReturn();
                    ALLRETURN_ACTIVE.set(true);
                    FEATURE_USAGE_COUNTS.put("ALLRETURN", FEATURE_USAGE_COUNTS.get("ALLRETURN") + 1);
                    FEATURE_ACTIVATION_TIMES.put("ALLRETURN", System.currentTimeMillis());
                    if (player != null) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7d[EntityEraser] AllReturn\u529f\u80fd\u5df2\u6fc0\u6d3b"));
                    }
                    System.out.println("\u00a7d[EntityEraserManager] AllReturn\u529f\u80fd\u5df2\u6fc0\u6d3b");
                }
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u6fc0\u6d3bAllReturn\u5931\u8d25: " + e.getMessage());
                if (player == null) break block4;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[EntityEraser] \u6fc0\u6d3b\u5931\u8d25: " + e.getMessage())));
            }
        }
    }

    public void deactivateAllReturn(Player player) {
        block4: {
            try {
                if (allReturnService != null) {
                    allReturnService.deactivateAllReturn();
                    ALLRETURN_ACTIVE.set(false);
                    if (player != null) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7d[EntityEraser] AllReturn\u529f\u80fd\u5df2\u505c\u7528"));
                    }
                    System.out.println("\u00a7d[EntityEraserManager] AllReturn\u529f\u80fd\u5df2\u505c\u7528");
                }
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u505c\u7528AllReturn\u5931\u8d25: " + e.getMessage());
                if (player == null) break block4;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[EntityEraser] \u505c\u7528\u5931\u8d25: " + e.getMessage())));
            }
        }
    }

    public void activateBothFeatures(Player player) {
        this.activateEntityEraser(player);
        this.activateAllReturn(player);
    }

    public void deactivateBothFeatures(Player player) {
        this.deactivateEntityEraser(player);
        this.deactivateAllReturn(player);
    }

    public void toggleEntityEraser(Player player) {
        if (ENTITY_ERASER_ACTIVE.get()) {
            this.deactivateEntityEraser(player);
        } else {
            this.activateEntityEraser(player);
        }
    }

    public void toggleAllReturn(Player player) {
        if (ALLRETURN_ACTIVE.get()) {
            this.deactivateAllReturn(player);
        } else {
            this.activateAllReturn(player);
        }
    }

    public boolean isEntityEraserActive() {
        return ENTITY_ERASER_ACTIVE.get();
    }

    public boolean isAllReturnActive() {
        return ALLRETURN_ACTIVE.get();
    }

    public boolean isManagerActive() {
        return MANAGER_ACTIVE.get();
    }

    public Map<String, Object> getFeatureStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("manager_active", MANAGER_ACTIVE.get());
        stats.put("entity_eraser_active", ENTITY_ERASER_ACTIVE.get());
        stats.put("allreturn_active", ALLRETURN_ACTIVE.get());
        stats.put("entity_eraser_usage_count", FEATURE_USAGE_COUNTS.get("ENTITY_ERASER"));
        stats.put("allreturn_usage_count", FEATURE_USAGE_COUNTS.get("ALLRETURN"));
        stats.put("entity_eraser_last_activation", FEATURE_ACTIVATION_TIMES.get("ENTITY_ERASER"));
        stats.put("allreturn_last_activation", FEATURE_ACTIVATION_TIMES.get("ALLRETURN"));
        if (entityEraserService != null) {
            stats.put("entity_eraser_service_stats", entityEraserService.getErasureStats());
        }
        if (allReturnService != null) {
            stats.put("allreturn_service_stats", allReturnService.getStats());
        }
        return stats;
    }

    public String getHelpInfo() {
        StringBuilder help = new StringBuilder();
        help.append("\u00a76=== EntityEraser \u5e2e\u52a9 ===\n");
        help.append("\u00a7eEntityEraser: ").append(ENTITY_ERASER_ACTIVE.get() ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed").append("\n");
        help.append("\u00a7eAllReturn: ").append(ALLRETURN_ACTIVE.get() ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed").append("\n");
        help.append("\u00a76========================");
        return help.toString();
    }

    public void resetAllFeatures(Player player) {
        block5: {
            try {
                ENTITY_ERASER_ACTIVE.set(false);
                ALLRETURN_ACTIVE.set(false);
                if (entityEraserService != null) {
                    entityEraserService.resetAllFeatures();
                }
                if (allReturnService != null) {
                    allReturnService.resetAllFeatures();
                }
                FEATURE_USAGE_COUNTS.put("ENTITY_ERASER", 0);
                FEATURE_USAGE_COUNTS.put("ALLRETURN", 0);
                FEATURE_ACTIVATION_TIMES.clear();
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7d[EntityEraser] \u6240\u6709\u529f\u80fd\u5df2\u91cd\u7f6e"));
                }
                System.out.println("\u00a7d[EntityEraserManager] \u6240\u6709\u529f\u80fd\u5df2\u91cd\u7f6e");
            }
            catch (Exception e) {
                System.err.println("\u00a7c[EntityEraserManager] \u91cd\u7f6e\u529f\u80fd\u5931\u8d25: " + e.getMessage());
                if (player == null) break block5;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[EntityEraser] \u91cd\u7f6e\u5931\u8d25: " + e.getMessage())));
            }
        }
    }

    public void shutdown() {
        try {
            MANAGER_ACTIVE.set(false);
            ENTITY_ERASER_ACTIVE.set(false);
            ALLRETURN_ACTIVE.set(false);
            if (entityEraserService != null) {
                entityEraserService.shutdown();
            }
            if (allReturnService != null) {
                allReturnService.shutdown();
            }
            System.out.println("\u00a7d[EntityEraserManager] \u7ba1\u7406\u5668\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[EntityEraserManager] \u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player == null) {
            return;
        }
        EntityEraserManager.checkPlayerStatus(player);
    }

    private static void checkPlayerStatus(Player player) {
    }

    static {
        FEATURE_USAGE_COUNTS = new ConcurrentHashMap<String, Integer>();
        FEATURE_ACTIVATION_TIMES = new ConcurrentHashMap<String, Long>();
    }
}

