/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.entity.eraserservice;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AllReturnService {
    private static final AtomicBoolean SERVICE_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ALLRETURN_ACTIVE = new AtomicBoolean(false);
    private static final Set<UUID> REPLACED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> PROTECTED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> ENTITY_REPLACEMENT_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, String> ENTITY_REPLACEMENT_SOURCES = new ConcurrentHashMap<UUID, String>();
    private static final Map<UUID, String> ENTITY_REPLACEMENT_TARGETS = new ConcurrentHashMap<UUID, String>();
    private static final WeakHashMap<Entity, Object> DEAD_ENTITIES = new WeakHashMap();
    private static final Object NULL_OBJECT = new Object();
    private static final Set<UUID> FORCE_REMOVAL_QUEUE = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Integer> PENDING_FORCE_REMOVALS = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Long> RECENTLY_CONVERTED = new ConcurrentHashMap<UUID, Long>();
    private static final ScheduledExecutorService ALLRETURN_SCHEDULER = Executors.newScheduledThreadPool(4);
    private static final String[] REPLACEMENT_KEYWORDS = new String[]{"agentgodpower", "agent_godpower", "\u795e\u529b", "\u62e6\u622a", "agent", "chaoswither", "chaos_wither", "\u6df7\u6c8c\u51cb\u96f6", "chaos", "chaotic", "silence_wither", "silencewither", "\u5f52\u5bc2", "silence", "silent", "super_bee", "superbee", "\u8d85\u7ea7\u871c\u8702", "bee", "queen", "execution_dragon", "executiondragon", "\u6267\u884c\u4e4b\u9f99", "execution", "execute", "witherzilla", "wither_zilla", "\u51cb\u96f6\u65af\u62c9", "zilla", "wither", "dragon", "\u9f99", "boss", "monster", "demon", "devil", "god", "\u795e", "ancient", "\u8fdc\u53e4", "legendary", "\u4f20\u8bf4", "mythic", "\u795e\u8bdd", "void", "\u865a\u7a7a", "shadow", "\u9634\u5f71", "dark", "\u9ed1\u6697", "crystal", "\u6c34\u6676", "elemental", "\u5143\u7d20", "guardian", "\u5b88\u62a4\u8005", "titan", "\u6cf0\u5766", "golem", "\u5080\u5121", "construct", "\u6784\u9020\u4f53", "abomination", "\u618e\u6076", "horror", "\u6050\u6016", "nightmare", "\u5669\u68a6"};
    private static final Set<ResourceLocation> BANNED_ENTITY_TYPES = Set.of(new ResourceLocation("witherzilla", "execution_dragon"), new ResourceLocation("chaoswither", "chaos_wither"), new ResourceLocation("silence_wither", "silence_wither"), new ResourceLocation("super_bee", "super_bee"), new ResourceLocation("agentgodpower", "agent_godpower"));
    private static final Map<String, String> ENTITY_REPLACEMENT_MAP = Map.ofEntries(Map.entry("wither", "minecraft:ender_dragon"), Map.entry("\u51cb\u96f6", "minecraft:ender_dragon"), Map.entry("dragon", "minecraft:ender_dragon"), Map.entry("\u9f99", "minecraft:ender_dragon"), Map.entry("boss", "minecraft:wither"), Map.entry("chaos", "minecraft:ender_dragon"), Map.entry("\u6df7\u6c8c", "minecraft:ender_dragon"), Map.entry("silence", "minecraft:ender_dragon"), Map.entry("\u5f52\u5bc2", "minecraft:ender_dragon"), Map.entry("bee", "minecraft:ender_dragon"), Map.entry("\u871c\u8702", "minecraft:ender_dragon"), Map.entry("execution", "minecraft:ender_dragon"), Map.entry("\u6267\u884c", "minecraft:ender_dragon"), Map.entry("zilla", "minecraft:ender_dragon"), Map.entry("\u65af\u62c9", "minecraft:ender_dragon"), Map.entry("god", "minecraft:ender_dragon"), Map.entry("\u795e", "minecraft:ender_dragon"), Map.entry("ancient", "minecraft:ender_dragon"), Map.entry("\u8fdc\u53e4", "minecraft:ender_dragon"), Map.entry("legendary", "minecraft:ender_dragon"), Map.entry("\u4f20\u8bf4", "minecraft:ender_dragon"), Map.entry("mythic", "minecraft:ender_dragon"), Map.entry("\u795e\u8bdd", "minecraft:ender_dragon"), Map.entry("void", "minecraft:ender_dragon"), Map.entry("\u865a\u7a7a", "minecraft:ender_dragon"), Map.entry("shadow", "minecraft:ender_dragon"), Map.entry("\u9634\u5f71", "minecraft:ender_dragon"), Map.entry("dark", "minecraft:ender_dragon"), Map.entry("\u9ed1\u6697", "minecraft:ender_dragon"), Map.entry("crystal", "minecraft:ender_dragon"), Map.entry("\u6c34\u6676", "minecraft:ender_dragon"), Map.entry("elemental", "minecraft:ender_dragon"), Map.entry("\u5143\u7d20", "minecraft:ender_dragon"), Map.entry("guardian", "minecraft:ender_dragon"), Map.entry("\u5b88\u62a4\u8005", "minecraft:ender_dragon"), Map.entry("titan", "minecraft:ender_dragon"), Map.entry("\u6cf0\u5766", "minecraft:ender_dragon"), Map.entry("golem", "minecraft:ender_dragon"), Map.entry("\u5080\u5121", "minecraft:ender_dragon"), Map.entry("construct", "minecraft:ender_dragon"), Map.entry("\u6784\u9020\u4f53", "minecraft:ender_dragon"), Map.entry("abomination", "minecraft:ender_dragon"), Map.entry("\u618e\u6076", "minecraft:ender_dragon"), Map.entry("horror", "minecraft:ender_dragon"), Map.entry("\u6050\u6016", "minecraft:ender_dragon"), Map.entry("nightmare", "minecraft:ender_dragon"), Map.entry("\u5669\u68a6", "minecraft:ender_dragon"));
    private static volatile AllReturnService instance;

    private AllReturnService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AllReturnService getInstance() {
        if (instance != null) return instance;
        Class<AllReturnService> clazz = AllReturnService.class;
        synchronized (AllReturnService.class) {
            if (instance != null) return instance;
            instance = new AllReturnService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        if (SERVICE_ACTIVE.compareAndSet(false, true)) {
            this.startCoreThreads();
            MinecraftForge.EVENT_BUS.register((Object)this);
            ALLRETURN_ACTIVE.set(false);
            System.out.println("\u00a7d[AllReturnService] \u670d\u52a1\u5df2\u521d\u59cb\u5316\uff08\u529f\u80fd\u672a\u81ea\u52a8\u6fc0\u6d3b\uff09");
        }
    }

    private void startCoreThreads() {
        ALLRETURN_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ALLRETURN_ACTIVE.get()) {
                    this.executeAllReturnCore();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[AllReturnService] \u6838\u5fc3\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
        ALLRETURN_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ALLRETURN_ACTIVE.get()) {
                    this.executeForceCleanup();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[AllReturnService] \u5f3a\u5236\u6e05\u7406\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private void executeAllReturnCore() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                this.scanAndReplaceEntities(level);
                this.cleanupDeadEntities(level);
                this.executeForceRemovals(level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u6838\u5fc3\u6267\u884c\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void executeForceCleanup() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                this.cleanupDeadEntityCache();
                this.cleanupExpiredConversions();
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u5f3a\u5236\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void scanAndReplaceEntities(ServerLevel level) {
        try {
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_()) continue;
                if (this.shouldForceRemove(entity)) {
                    this.forceRemoveEntity(entity);
                    continue;
                }
                if (!this.shouldReplaceEntity(entity)) continue;
                this.replaceEntityWithVanilla(entity, level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u5b9e\u4f53\u626b\u63cf\u5f02\u5e38: " + e.getMessage());
        }
    }

    private boolean shouldForceRemove(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (DEAD_ENTITIES.containsKey(entity)) {
            return true;
        }
        if (FORCE_REMOVAL_QUEUE.contains(entity.m_20148_())) {
            return true;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (key != null && BANNED_ENTITY_TYPES.contains(key)) {
            return true;
        }
        String className = entity.getClass().getName().toLowerCase();
        return className.contains("execution_dragon") || className.contains("chaos_wither") || className.contains("silence_wither") || className.contains("super_bee") || className.contains("agent_godpower");
    }

    private void forceRemoveEntity(Entity entity) {
        try {
            if (entity == null || entity.m_213877_()) {
                return;
            }
            System.out.println("\u00a7d[AllReturnService] \u5f3a\u5236\u79fb\u9664\u5b9e\u4f53: " + entity.m_7755_().getString() + " \u7c7b\u540d: " + entity.getClass().getName());
            DEAD_ENTITIES.put(entity, NULL_OBJECT);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_21219_();
                living.m_20331_(false);
                living.getPersistentData().m_128473_("Immortal");
                living.getPersistentData().m_128473_("Protected");
                living.getPersistentData().m_128473_("Invincible");
                living.m_21153_(0.0f);
                living.m_6469_(living.m_269291_().m_269264_(), Float.MAX_VALUE);
                living.m_6469_(living.m_269291_().m_269425_(), Float.MAX_VALUE);
                living.m_6469_(living.m_269291_().m_269341_(), Float.MAX_VALUE);
                living.m_142687_(Entity.RemovalReason.KILLED);
                living.m_146870_();
                if (!living.m_213877_()) {
                    living.m_6021_(living.m_20185_(), -2048.0, living.m_20189_());
                }
            } else {
                entity.m_142687_(Entity.RemovalReason.KILLED);
                entity.m_146870_();
            }
            PENDING_FORCE_REMOVALS.put(entity.m_20148_(), 600);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u5f3a\u5236\u79fb\u9664\u5f02\u5e38: " + e.getMessage());
            try {
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_21153_(0.0f);
                    ((LivingEntity)entity).m_6074_();
                }
                entity.m_146870_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean shouldReplaceEntity(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (REPLACED_ENTITIES.contains(entity.m_20148_())) {
            return false;
        }
        if (DEAD_ENTITIES.containsKey(entity)) {
            return false;
        }
        return this.isModEntity(entity);
    }

    private boolean isModEntity(Entity entity) {
        try {
            String namespace;
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            if (key != null && !"minecraft".equals(namespace = key.m_135827_())) {
                return true;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        String className = entity.getClass().getName();
        if (!className.startsWith("net.minecraft") && !className.startsWith("net.minecraftforge")) {
            return true;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        for (String keyword : REPLACEMENT_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase())) continue;
            return true;
        }
        String classNameLower = className.toLowerCase();
        for (String keyword : REPLACEMENT_KEYWORDS) {
            if (!classNameLower.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void replaceEntityWithVanilla(Entity entity, ServerLevel level) {
        try {
            if (entity.m_213877_()) {
                return;
            }
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            float yRot = entity.m_146908_();
            float xRot = entity.m_146909_();
            String replacementTypeName = this.selectReplacementEntityType(entity);
            if (replacementTypeName == null) {
                return;
            }
            String[] parts = replacementTypeName.split(":");
            if (parts.length != 2) {
                return;
            }
            EntityType replacementType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(parts[0], parts[1]));
            if (replacementType == null) {
                return;
            }
            Entity replacement = replacementType.m_20615_((Level)level);
            if (replacement == null) {
                return;
            }
            replacement.m_6034_(x, y, z);
            replacement.m_146922_(yRot);
            replacement.m_146926_(xRot);
            replacement.getPersistentData().m_128359_("allreturn_replaced", "true");
            replacement.getPersistentData().m_128359_("allreturn_source", entity.m_6095_().toString());
            replacement.getPersistentData().m_128356_("allreturn_time", System.currentTimeMillis());
            UUID entityId = entity.m_20148_();
            REPLACED_ENTITIES.add(entityId);
            ENTITY_REPLACEMENT_TIMES.put(entityId, System.currentTimeMillis());
            ENTITY_REPLACEMENT_SOURCES.put(entityId, entity.m_6095_().toString());
            ENTITY_REPLACEMENT_TARGETS.put(entityId, replacementTypeName);
            RECENTLY_CONVERTED.put(entityId, System.currentTimeMillis());
            entity.m_142687_(Entity.RemovalReason.KILLED);
            level.m_7967_(replacement);
            System.out.println("\u00a7d[AllReturnService] \u66ff\u6362\u5b9e\u4f53: " + entity.m_7755_().getString() + " -> " + replacementTypeName);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u5b9e\u4f53\u66ff\u6362\u5931\u8d25: " + e.getMessage());
        }
    }

    private String selectReplacementEntityType(Entity original) {
        try {
            String namespace;
            String entityName = original.m_7755_().getString().toLowerCase();
            String className = original.getClass().getName().toLowerCase();
            for (Map.Entry<String, String> entry : ENTITY_REPLACEMENT_MAP.entrySet()) {
                String keyword = entry.getKey();
                if (!entityName.contains(keyword) && !className.contains(keyword)) continue;
                return entry.getValue();
            }
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)original.m_6095_());
            if (key != null && ("chaoswither".equals(namespace = key.m_135827_()) || "silence_wither".equals(namespace) || "super_bee".equals(namespace) || "witherzilla".equals(namespace) || "agentgodpower".equals(namespace))) {
                return "minecraft:ender_dragon";
            }
            return "minecraft:ender_dragon";
        }
        catch (Exception e) {
            return "minecraft:ender_dragon";
        }
    }

    private void cleanupDeadEntities(ServerLevel level) {
        try {
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_() || !this.shouldCleanupEntity(entity)) continue;
                entity.m_142687_(Entity.RemovalReason.KILLED);
                System.out.println("\u00a7d[AllReturnService] \u6e05\u7406\u6b7b\u4ea1\u5b9e\u4f53: " + entity.m_7755_().getString());
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private boolean shouldCleanupEntity(Entity entity) {
        LivingEntity living;
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21224_()) {
            return true;
        }
        return REPLACED_ENTITIES.contains(entity.m_20148_());
    }

    private void executeForceRemovals(ServerLevel level) {
        try {
            Iterator<Map.Entry<UUID, Integer>> iterator = PENDING_FORCE_REMOVALS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Integer> entry = iterator.next();
                UUID entityId = entry.getKey();
                int ticks = entry.getValue();
                if (ticks <= 0) {
                    iterator.remove();
                    continue;
                }
                Entity entity = level.m_8791_(entityId);
                if (entity != null && !entity.m_213877_()) {
                    this.forceRemoveEntity(entity);
                }
                entry.setValue(ticks - 1);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u5f3a\u5236\u79fb\u9664\u6267\u884c\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void cleanupDeadEntityCache() {
        try {
            DEAD_ENTITIES.entrySet().removeIf(entry -> {
                Entity entity = (Entity)entry.getKey();
                return entity == null || entity.m_213877_();
            });
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u6b7b\u4ea1\u5b9e\u4f53\u7f13\u5b58\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void cleanupExpiredConversions() {
        try {
            long currentTime = System.currentTimeMillis();
            long expireTime = 300000L;
            RECENTLY_CONVERTED.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > expireTime);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturnService] \u8f6c\u6362\u8bb0\u5f55\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.shouldInterceptEntity(entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[AllReturnService] \u62e6\u622a\u5b9e\u4f53: " + entity.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public void onMobSpawnFinalize(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.shouldPreventSpawn((Entity)entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[AllReturnService] \u963b\u6b62\u5b9e\u4f53\u751f\u6210: " + entity.m_7755_().getString());
        }
    }

    private boolean shouldInterceptEntity(Entity entity) {
        String namespace;
        if (!ALLRETURN_ACTIVE.get()) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        for (String keyword : REPLACEMENT_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase()) && !className.contains(keyword.toLowerCase())) continue;
            return true;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return key != null && !"minecraft".equals(namespace = key.m_135827_());
    }

    private boolean shouldPreventSpawn(Entity entity) {
        if (!ALLRETURN_ACTIVE.get()) {
            return false;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (key != null && BANNED_ENTITY_TYPES.contains(key)) {
            return true;
        }
        String className = entity.getClass().getName().toLowerCase();
        return className.contains("execution_dragon") || className.contains("chaos_wither") || className.contains("silence_wither") || className.contains("super_bee") || className.contains("agent_godpower");
    }

    public void activateAllReturn() {
        ALLRETURN_ACTIVE.set(true);
        System.out.println("\u00a7d[AllReturnService] AllReturn\u529f\u80fd\u5df2\u6fc0\u6d3b");
    }

    public void deactivateAllReturn() {
        ALLRETURN_ACTIVE.set(false);
        System.out.println("\u00a7d[AllReturnService] AllReturn\u529f\u80fd\u5df2\u505c\u7528");
    }

    public boolean isAllReturnActive() {
        return ALLRETURN_ACTIVE.get();
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("service_active", SERVICE_ACTIVE.get());
        stats.put("allreturn_active", ALLRETURN_ACTIVE.get());
        stats.put("replaced_entities_count", REPLACED_ENTITIES.size());
        stats.put("protected_entities_count", PROTECTED_ENTITIES.size());
        stats.put("dead_entities_count", DEAD_ENTITIES.size());
        stats.put("force_removal_queue_size", FORCE_REMOVAL_QUEUE.size());
        stats.put("pending_force_removals", PENDING_FORCE_REMOVALS.size());
        stats.put("recently_converted", RECENTLY_CONVERTED.size());
        return stats;
    }

    public void resetAllFeatures() {
        ALLRETURN_ACTIVE.set(false);
        REPLACED_ENTITIES.clear();
        PROTECTED_ENTITIES.clear();
        ENTITY_REPLACEMENT_TIMES.clear();
        ENTITY_REPLACEMENT_SOURCES.clear();
        ENTITY_REPLACEMENT_TARGETS.clear();
        DEAD_ENTITIES.clear();
        FORCE_REMOVAL_QUEUE.clear();
        PENDING_FORCE_REMOVALS.clear();
        RECENTLY_CONVERTED.clear();
        System.out.println("\u00a7d[AllReturnService] \u6240\u6709\u529f\u80fd\u5df2\u91cd\u7f6e");
    }

    public void shutdown() {
        SERVICE_ACTIVE.set(false);
        ALLRETURN_ACTIVE.set(false);
        try {
            ALLRETURN_SCHEDULER.shutdown();
            if (!ALLRETURN_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                ALLRETURN_SCHEDULER.shutdownNow();
            }
            System.out.println("\u00a7d[AllReturnService] \u670d\u52a1\u5df2\u5173\u95ed");
        }
        catch (InterruptedException e) {
            System.out.println("\u00a7d[AllReturnService] \u5173\u95ed\u65f6\u88ab\u4e2d\u65ad: " + e.getMessage());
        }
    }
}

