/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import com.buwan.shizuku.jvm.CoremodHelper;
import com.buwan.shizuku.jvm.PlatformInfo;
import com.buwan.shizuku.jvm.ShellcodeExecutor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ApphhzpLibMod {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final boolean DEBUG = false;
    public static final String MOD_ID = "apphhzp_lib";
    public static final String MOD_NAME = "Apphhzp Library";
    public static final String MOD_VERSION = "1.0.7";
    public static final String MOD_DESCRIPTION = "Advanced JVM and bytecode manipulation library";
    private static final List<String> LOADED_MODULES = new ArrayList<String>();
    private static final List<String> FAILED_MODULES = new ArrayList<String>();

    private ApphhzpLibMod() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void initialize() {
        if (INITIALIZED.compareAndSet(false, true)) {
            try {
                ApphhzpLibMod.initializeCoreModules();
                ApphhzpLibMod.initializeJVMFeatures();
                ApphhzpLibMod.initializePlatformDetection();
                ApphhzpLibMod.initializeSecurityFeatures();
            }
            catch (Exception e) {
                INITIALIZED.set(false);
                throw new RuntimeException("Failed to initialize Apphhzp Library", e);
            }
        }
    }

    private static void initializeCoreModules() {
        try {
            if (ApphhzpLibMod.initializeModule("ClassHelperSpecial")) {
                LOADED_MODULES.add("ClassHelperSpecial");
            } else {
                FAILED_MODULES.add("ClassHelperSpecial");
            }
            if (ApphhzpLibMod.initializeModule("OnlyInDefineClassHelper")) {
                LOADED_MODULES.add("OnlyInDefineClassHelper");
            } else {
                FAILED_MODULES.add("OnlyInDefineClassHelper");
            }
            if (ApphhzpLibMod.initializeModule("PlatformInfo")) {
                LOADED_MODULES.add("PlatformInfo");
            } else {
                FAILED_MODULES.add("PlatformInfo");
            }
            if (ApphhzpLibMod.initializeModule("ShellcodeExecutor")) {
                LOADED_MODULES.add("ShellcodeExecutor");
            } else {
                FAILED_MODULES.add("ShellcodeExecutor");
            }
            if (ApphhzpLibMod.initializeModule("CoremodHelper")) {
                LOADED_MODULES.add("CoremodHelper");
            } else {
                FAILED_MODULES.add("CoremodHelper");
            }
            if (ApphhzpLibMod.initializeModule("ClassOption")) {
                LOADED_MODULES.add("ClassOption");
            } else {
                FAILED_MODULES.add("ClassOption");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initializeJVMFeatures() {
        try {
            String[] jvmClasses;
            if (ApphhzpLibMod.initializeModule("JVM")) {
                LOADED_MODULES.add("JVM");
            } else {
                FAILED_MODULES.add("JVM");
            }
            if (ApphhzpLibMod.initializeModule("Type")) {
                LOADED_MODULES.add("Type");
            } else {
                FAILED_MODULES.add("Type");
            }
            if (ApphhzpLibMod.initializeModule("JVMObject")) {
                LOADED_MODULES.add("JVMObject");
            } else {
                FAILED_MODULES.add("JVMObject");
            }
            for (String className : jvmClasses = new String[]{"Symbol", "AccessFlags", "ClassLoaderData", "Klass", "InstanceKlass", "Field", "Method", "Dictionary", "HashtableEntry", "HashtableBucket", "Hashtable"}) {
                if (ApphhzpLibMod.initializeModule(className)) {
                    LOADED_MODULES.add(className);
                    continue;
                }
                FAILED_MODULES.add(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializePlatformDetection() {
        try {
            if (!PlatformInfo.isSupported()) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initializeSecurityFeatures() {
        try {
            if (System.getSecurityManager() != null) {
                // empty if block
            }
            ApphhzpLibMod.checkPermissions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkPermissions() {
        try {
            File tempFile = File.createTempFile("apphhzp_test", ".tmp");
            tempFile.deleteOnExit();
            Class<String> testClass = String.class;
            Field field = testClass.getDeclaredField("value");
            field.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean initializeModule(String moduleName) {
        try {
            String fullClassName = "com.buwan.shizuku.jvm." + moduleName;
            Class<?> moduleClass = Class.forName(fullClassName);
            try {
                Method initMethod = moduleClass.getDeclaredMethod("initialize", new Class[0]);
                if (Modifier.isStatic(initMethod.getModifiers())) {
                    initMethod.invoke(null, new Object[0]);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getModInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Mod Information:\n");
        info.append("ID: ").append(MOD_ID).append("\n");
        info.append("Name: ").append(MOD_NAME).append("\n");
        info.append("Version: ").append(MOD_VERSION).append("\n");
        info.append("Description: ").append(MOD_DESCRIPTION).append("\n");
        info.append("Initialized: ").append(INITIALIZED.get()).append("\n");
        info.append("Loaded Modules: ").append(LOADED_MODULES.size()).append("\n");
        info.append("Failed Modules: ").append(FAILED_MODULES.size()).append("\n");
        if (!LOADED_MODULES.isEmpty()) {
            info.append("\nLoaded Modules:\n");
            for (String module : LOADED_MODULES) {
                info.append("  - ").append(module).append("\n");
            }
        }
        if (!FAILED_MODULES.isEmpty()) {
            info.append("\nFailed Modules:\n");
            for (String module : FAILED_MODULES) {
                info.append("  - ").append(module).append("\n");
            }
        }
        return info.toString();
    }

    public static String getPlatformInfo() {
        try {
            if (PlatformInfo.isSupported()) {
                return PlatformInfo.getPlatformDetails();
            }
            return "Platform detection not available";
        }
        catch (Exception e) {
            return "Error getting platform info: " + e.getMessage();
        }
    }

    public static String getJavaFeatureSupport() {
        try {
            if (PlatformInfo.isSupported()) {
                return PlatformInfo.getJavaFeatureSupport();
            }
            return "Java feature detection not available";
        }
        catch (Exception e) {
            return "Error getting Java feature support: " + e.getMessage();
        }
    }

    public static boolean isShellcodeExecutionSupported() {
        try {
            return ShellcodeExecutor.isSupported();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getShellcodeExecutionInfo() {
        try {
            if (ShellcodeExecutor.isSupported()) {
                return ShellcodeExecutor.getSupportInfo();
            }
            return "Shellcode execution not supported";
        }
        catch (Exception e) {
            return "Error getting shellcode execution info: " + e.getMessage();
        }
    }

    public static String getCoremodLoadingStatistics() {
        try {
            return CoremodHelper.getLoadingStatistics();
        }
        catch (Exception e) {
            return "Error getting coremod loading statistics: " + e.getMessage();
        }
    }

    public static boolean isInitialized() {
        return INITIALIZED.get();
    }

    public static List<String> getLoadedModules() {
        return new ArrayList<String>(LOADED_MODULES);
    }

    public static List<String> getFailedModules() {
        return new ArrayList<String>(FAILED_MODULES);
    }

    public static void reinitialize() {
        if (INITIALIZED.get()) {
            LOADED_MODULES.clear();
            FAILED_MODULES.clear();
            INITIALIZED.set(false);
        }
        ApphhzpLibMod.initialize();
    }

    public static void reset() {
        LOADED_MODULES.clear();
        FAILED_MODULES.clear();
        INITIALIZED.set(false);
    }

    public static void enableDebug() {
        try {
            Field debugField = ApphhzpLibMod.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disableDebug() {
        try {
            Field debugField = ApphhzpLibMod.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFullStatusReport() {
        StringBuilder report = new StringBuilder();
        report.append("=== ").append(MOD_NAME).append(" Status Report ===\n\n");
        report.append(ApphhzpLibMod.getModInfo()).append("\n\n");
        report.append("=== Platform Information ===\n");
        report.append(ApphhzpLibMod.getPlatformInfo()).append("\n\n");
        report.append("=== Java Feature Support ===\n");
        report.append(ApphhzpLibMod.getJavaFeatureSupport()).append("\n\n");
        report.append("=== Shellcode Execution Support ===\n");
        report.append(ApphhzpLibMod.getShellcodeExecutionInfo()).append("\n\n");
        report.append("=== Coremod Loading Statistics ===\n");
        report.append(ApphhzpLibMod.getCoremodLoadingStatistics()).append("\n\n");
        report.append("=== Module Status ===\n");
        report.append("Total Modules: ").append(LOADED_MODULES.size() + FAILED_MODULES.size()).append("\n");
        report.append("Successfully Loaded: ").append(LOADED_MODULES.size()).append("\n");
        report.append("Failed to Load: ").append(FAILED_MODULES.size()).append("\n");
        report.append("Success Rate: ").append(ApphhzpLibMod.calculateSuccessRate()).append("%\n");
        return report.toString();
    }

    private static double calculateSuccessRate() {
        int total = LOADED_MODULES.size() + FAILED_MODULES.size();
        if (total == 0) {
            return 0.0;
        }
        return (double)Math.round((double)LOADED_MODULES.size() / (double)total * 100.0 * 100.0) / 100.0;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Starting Apphhzp Library v1.0.7");
            ApphhzpLibMod.initialize();
            System.out.println(ApphhzpLibMod.getFullStatusReport());
        }
        catch (Exception e) {
            System.err.println("Error in main method: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

