/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class CoremodHelper {
    private static final boolean DEBUG = false;
    private static final List<String> LOADED_COREMODS = new ArrayList<String>();
    private static final List<String> FAILED_COREMODS = new ArrayList<String>();

    private CoremodHelper() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static boolean loadCoremod(String jarFile) {
        return CoremodHelper.loadCoremod(new File(jarFile));
    }

    public static boolean loadCoremod(File jarFile) {
        if (jarFile == null || !jarFile.exists()) {
            return false;
        }
        try {
            if (!CoremodHelper.isValidJarFile(jarFile)) {
                return false;
            }
            if (!CoremodHelper.hasCoremodConfig(jarFile)) {
                return false;
            }
            if (CoremodHelper.loadCoremodClasses(jarFile)) {
                LOADED_COREMODS.add(jarFile.getName());
                return true;
            }
            FAILED_COREMODS.add(jarFile.getName());
            return false;
        }
        catch (Exception e) {
            FAILED_COREMODS.add(jarFile.getName());
            return false;
        }
    }

    private static boolean isValidJarFile(File jarFile) {
        boolean bl;
        JarFile jar = new JarFile(jarFile);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jar.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCoremodConfig(File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            ZipEntry modsToml = jar.getEntry("META-INF/mods.toml");
            if (modsToml != null) {
                boolean bl = true;
                return bl;
            }
            ZipEntry mcmodInfo = jar.getEntry("mcmod.info");
            if (mcmodInfo != null) {
                boolean bl = true;
                return bl;
            }
            ZipEntry packMcmeta = jar.getEntry("pack.mcmeta");
            if (packMcmeta != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = CoremodHelper.hasCoremodClass(jar);
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean hasCoremodClass(JarFile jar) {
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || !CoremodHelper.isCoremodClass(className = name.substring(0, name.length() - 6).replace('/', '.'))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isCoremodClass(String className) {
        return className.contains("CoreMod") || className.contains("coremod") || className.contains("Core") || className.contains("Transformer") || className.contains("transformer");
    }

    private static boolean loadCoremodClasses(File jarFile) {
        try {
            URL jarUrl = jarFile.toURI().toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl}, CoremodHelper.class.getClassLoader());
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    String className = name.substring(0, name.length() - 6).replace('/', '.');
                    try {
                        Class<?> clazz = classLoader.loadClass(className);
                        if (!CoremodHelper.isValidCoremodClass(clazz)) continue;
                        CoremodHelper.initializeCoremod(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidCoremodClass(Class<?> clazz) {
        try {
            Field[] fields;
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                String methodName = method.getName().toLowerCase();
                if (!methodName.contains("transform") && !methodName.contains("inject") && !methodName.contains("modify") && !methodName.contains("patch")) continue;
                return true;
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName = field.getName().toLowerCase();
                if (!fieldName.contains("coremod") && !fieldName.contains("transformer") && !fieldName.contains("mod")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void initializeCoremod(Class<?> coremodClass) {
        try {
            Method[] methods;
            for (Method method : methods = coremodClass.getDeclaredMethods()) {
                String methodName = method.getName().toLowerCase();
                if (!methodName.contains("init") && !methodName.contains("setup") && !methodName.contains("start") && !methodName.contains("load")) continue;
                try {
                    method.setAccessible(true);
                    if (Modifier.isStatic(method.getModifiers())) {
                        method.invoke(null, new Object[0]);
                        continue;
                    }
                    Object instance = coremodClass.newInstance();
                    method.invoke(instance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int loadCoremods(List<File> jarFiles) {
        if (jarFiles == null || jarFiles.isEmpty()) {
            return 0;
        }
        int successCount = 0;
        for (File jarFile : jarFiles) {
            if (!CoremodHelper.loadCoremod(jarFile)) continue;
            ++successCount;
        }
        return successCount;
    }

    public static int loadCoremodsFromPaths(List<String> jarPaths) {
        if (jarPaths == null || jarPaths.isEmpty()) {
            return 0;
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String path : jarPaths) {
            File file = new File(path);
            if (!file.exists()) continue;
            jarFiles.add(file);
        }
        return CoremodHelper.loadCoremods(jarFiles);
    }

    public static int loadCoremodsFromDirectory(String directory) {
        return CoremodHelper.loadCoremodsFromDirectory(new File(directory));
    }

    public static int loadCoremodsFromDirectory(File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return 0;
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar")) continue;
                jarFiles.add(file);
            }
        }
        return CoremodHelper.loadCoremods(jarFiles);
    }

    public static List<String> getLoadedCoremods() {
        return new ArrayList<String>(LOADED_COREMODS);
    }

    public static List<String> getFailedCoremods() {
        return new ArrayList<String>(FAILED_COREMODS);
    }

    public static String getLoadingStatistics() {
        StringBuilder stats = new StringBuilder();
        stats.append("Coremod Loading Statistics:\n");
        stats.append("Successfully loaded: ").append(LOADED_COREMODS.size()).append("\n");
        stats.append("Failed to load: ").append(FAILED_COREMODS.size()).append("\n");
        stats.append("Total attempted: ").append(LOADED_COREMODS.size() + FAILED_COREMODS.size()).append("\n");
        if (!LOADED_COREMODS.isEmpty()) {
            stats.append("\nLoaded coremods:\n");
            for (String coremod : LOADED_COREMODS) {
                stats.append("  - ").append(coremod).append("\n");
            }
        }
        if (!FAILED_COREMODS.isEmpty()) {
            stats.append("\nFailed coremods:\n");
            for (String coremod : FAILED_COREMODS) {
                stats.append("  - ").append(coremod).append("\n");
            }
        }
        return stats.toString();
    }

    public static void clearLoadingRecords() {
        LOADED_COREMODS.clear();
        FAILED_COREMODS.clear();
    }

    public static boolean isCoremodLoaded(String coremodName) {
        return LOADED_COREMODS.contains(coremodName);
    }

    public static boolean isCoremodFailed(String coremodName) {
        return FAILED_COREMODS.contains(coremodName);
    }

    public static boolean reloadCoremod(String jarFile) {
        LOADED_COREMODS.remove(jarFile);
        FAILED_COREMODS.remove(jarFile);
        return CoremodHelper.loadCoremod(jarFile);
    }

    public static boolean reloadCoremod(File jarFile) {
        return CoremodHelper.reloadCoremod(jarFile.getName());
    }

    public static String getCoremodInfo(String jarFile) {
        try {
            File file = new File(jarFile);
            if (!file.exists()) {
                return "File does not exist: " + jarFile;
            }
            StringBuilder info = new StringBuilder();
            info.append("Coremod File: ").append(file.getName()).append("\n");
            info.append("File Size: ").append(file.length()).append(" bytes\n");
            info.append("Last Modified: ").append(new Date(file.lastModified())).append("\n");
            info.append("Valid JAR: ").append(CoremodHelper.isValidJarFile(file)).append("\n");
            info.append("Has Coremod Config: ").append(CoremodHelper.hasCoremodConfig(file)).append("\n");
            info.append("Loading Status: ");
            if (CoremodHelper.isCoremodLoaded(file.getName())) {
                info.append("Loaded");
            } else if (CoremodHelper.isCoremodFailed(file.getName())) {
                info.append("Failed");
            } else {
                info.append("Not Attempted");
            }
            return info.toString();
        }
        catch (Exception e) {
            return "Error getting coremod info: " + e.getMessage();
        }
    }

    public static void enableDebug() {
        try {
            Field debugField = CoremodHelper.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disableDebug() {
        try {
            Field debugField = CoremodHelper.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

