/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.lang.reflect.Field;

public class OnlyInDefineClassHelper {
    private static final boolean DEBUG = false;

    private OnlyInDefineClassHelper() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void setClassAccessFlags(Class<?> clazz, int accessFlags) {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSuperClass(Class<?> clazz, Class<?> superClass) {
    }

    public static void setInterfaces(Class<?> clazz, Class<?>[] interfaces) {
    }

    public static void addField(Class<?> clazz, String fieldName, Class<?> fieldType, int accessFlags) {
    }

    public static void addMethod(Class<?> clazz, String methodName, Class<?> returnType, Class<?>[] parameterTypes, int accessFlags) {
    }

    public static void modifyBytecode(Class<?> clazz, byte[] newBytecode) {
    }

    public static void setAnnotation(Class<?> clazz, String annotationName, Object annotationValue) {
    }

    public static void setSignature(Class<?> clazz, String signature) {
    }

    public static void setSourceFile(Class<?> clazz, String sourceFile) {
    }

    public static void setDebugInfo(Class<?> clazz, boolean hasDebugInfo) {
    }

    public static boolean isInDefineClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                if (!element.getMethodName().contains("defineClass")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDefineClassContext() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuilder context = new StringBuilder();
            for (StackTraceElement element : stackTrace) {
                if (!element.getMethodName().contains("defineClass")) continue;
                context.append("defineClass context: ").append(element.getClassName()).append(".").append(element.getMethodName()).append(" at line ").append(element.getLineNumber());
                break;
            }
            return context.toString();
        }
        catch (Exception e) {
            return "Unable to get defineClass context";
        }
    }

    public static void enableDebug() {
        try {
            Field debugField = OnlyInDefineClassHelper.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disableDebug() {
        try {
            Field debugField = OnlyInDefineClassHelper.class.getDeclaredField("DEBUG");
            debugField.setAccessible(true);
            debugField.set(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

