/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Properties;

public class PlatformInfo {
    private static final String OS_NAME = System.getProperty("os.name", "unknown").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch", "unknown").toLowerCase();
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String JAVA_VENDOR = System.getProperty("java.vendor", "unknown");
    private static final String JAVA_HOME = System.getProperty("java.home", "unknown");

    private PlatformInfo() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static boolean isSupported() {
        try {
            return !OS_NAME.equals("unknown") && !OS_ARCH.equals("unknown") && !JAVA_VERSION.equals("unknown") && !JAVA_VENDOR.equals("unknown") && !JAVA_HOME.equals("unknown");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux");
    }

    public static boolean isMacOS() {
        return OS_NAME.contains("mac") || OS_NAME.contains("darwin");
    }

    public static boolean isUnix() {
        return PlatformInfo.isLinux() || PlatformInfo.isMacOS() || OS_NAME.contains("unix");
    }

    public static boolean isAndroid() {
        try {
            return Class.forName("android.os.Build") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isIOS() {
        try {
            return Class.forName("com.apple.ios") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String getOSName() {
        return OS_NAME;
    }

    public static String getOSArch() {
        return OS_ARCH;
    }

    public static boolean is64Bit() {
        return OS_ARCH.contains("64") || OS_ARCH.contains("amd64") || OS_ARCH.contains("x86_64");
    }

    public static boolean is32Bit() {
        return !PlatformInfo.is64Bit();
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaHome() {
        return JAVA_HOME;
    }

    public static boolean isOracleJDK() {
        return JAVA_VENDOR.toLowerCase().contains("oracle");
    }

    public static boolean isOpenJDK() {
        return JAVA_VENDOR.toLowerCase().contains("openjdk") || JAVA_VENDOR.toLowerCase().contains("adoptopenjdk") || JAVA_VENDOR.toLowerCase().contains("eclipse");
    }

    public static boolean isIBMJDK() {
        return JAVA_VENDOR.toLowerCase().contains("ibm");
    }

    public static boolean isAzulZuluJDK() {
        return JAVA_VENDOR.toLowerCase().contains("azul");
    }

    public static int getJavaMajorVersion() {
        try {
            String version = JAVA_VERSION;
            if (version.startsWith("1.")) {
                return Integer.parseInt(version.substring(2, version.indexOf(46, 2)));
            }
            return Integer.parseInt(version.substring(0, version.indexOf(46)));
        }
        catch (Exception e) {
            return 8;
        }
    }

    public static boolean isJava8() {
        return PlatformInfo.getJavaMajorVersion() == 8;
    }

    public static boolean isJava11() {
        return PlatformInfo.getJavaMajorVersion() == 11;
    }

    public static boolean isJava17() {
        return PlatformInfo.getJavaMajorVersion() == 17;
    }

    public static boolean isJava21() {
        return PlatformInfo.getJavaMajorVersion() == 21;
    }

    public static boolean supportsModules() {
        return PlatformInfo.getJavaMajorVersion() >= 9;
    }

    public static boolean supportsRecords() {
        return PlatformInfo.getJavaMajorVersion() >= 14;
    }

    public static boolean supportsSealedClasses() {
        return PlatformInfo.getJavaMajorVersion() >= 17;
    }

    public static boolean supportsPatternMatching() {
        return PlatformInfo.getJavaMajorVersion() >= 16;
    }

    public static boolean supportsVirtualThreads() {
        return PlatformInfo.getJavaMajorVersion() >= 19;
    }

    public static boolean isJRE() {
        try {
            Class.forName("com.sun.tools.javac.Main");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public static boolean isJDK() {
        return !PlatformInfo.isJRE();
    }

    public static boolean supportsJVMTI() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsAttachAPI() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsManagement() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsUnsafe() {
        try {
            Class.forName("sun.misc.Unsafe");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsMethodHandles() {
        try {
            Class.forName("java.lang.invoke.MethodHandles");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsVarHandle() {
        try {
            Class.forName("java.lang.invoke.VarHandle");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean supportsFFI() {
        try {
            Class.forName("java.lang.foreign.MemorySegment");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isDevelopmentEnvironment() {
        try {
            return new File("src").exists() || new File("build.gradle").exists() || new File("pom.xml").exists() || new File("build.xml").exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isProductionEnvironment() {
        return !PlatformInfo.isDevelopmentEnvironment();
    }

    public static boolean supportsDebugging() {
        try {
            return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(arg -> arg.contains("-agentlib:jdwp") || arg.contains("-Xdebug") || arg.contains("-Xrunjdwp"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean supportsHotDeploy() {
        try {
            return Class.forName("org.springframework.boot.devtools.restart.RestartListener") != null || Class.forName("org.springframework.boot.devtools.autoconfigure.DevToolsProperties") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Properties getSystemProperties() {
        return System.getProperties();
    }

    public static Map<String, String> getEnvironmentVariables() {
        return System.getenv();
    }

    public static String getUserHome() {
        return System.getProperty("user.home", "unknown");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir", "unknown");
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir", "unknown");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator", "/");
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator", ":");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static String getPlatformDetails() {
        StringBuilder details = new StringBuilder();
        details.append("OS: ").append(PlatformInfo.getOSName()).append(" (").append(PlatformInfo.getOSArch()).append(")\n");
        details.append("Java: ").append(PlatformInfo.getJavaVersion()).append(" by ").append(PlatformInfo.getJavaVendor()).append("\n");
        details.append("Java Home: ").append(PlatformInfo.getJavaHome()).append("\n");
        details.append("User Home: ").append(PlatformInfo.getUserHome()).append("\n");
        details.append("Working Dir: ").append(PlatformInfo.getUserDir()).append("\n");
        details.append("Temp Dir: ").append(PlatformInfo.getTempDir()).append("\n");
        details.append("File Separator: ").append(PlatformInfo.getFileSeparator()).append("\n");
        details.append("Path Separator: ").append(PlatformInfo.getPathSeparator()).append("\n");
        details.append("Line Separator: ").append(PlatformInfo.getLineSeparator().replace("\n", "\\n").replace("\r", "\\r"));
        return details.toString();
    }

    public static String getJavaFeatureSupport() {
        StringBuilder features = new StringBuilder();
        features.append("Modules: ").append(PlatformInfo.supportsModules()).append("\n");
        features.append("Records: ").append(PlatformInfo.supportsRecords()).append("\n");
        features.append("Sealed Classes: ").append(PlatformInfo.supportsSealedClasses()).append("\n");
        features.append("Pattern Matching: ").append(PlatformInfo.supportsPatternMatching()).append("\n");
        features.append("Virtual Threads: ").append(PlatformInfo.supportsVirtualThreads()).append("\n");
        features.append("JVMTI: ").append(PlatformInfo.supportsJVMTI()).append("\n");
        features.append("Attach API: ").append(PlatformInfo.supportsAttachAPI()).append("\n");
        features.append("Management: ").append(PlatformInfo.supportsManagement()).append("\n");
        features.append("Unsafe: ").append(PlatformInfo.supportsUnsafe()).append("\n");
        features.append("MethodHandles: ").append(PlatformInfo.supportsMethodHandles()).append("\n");
        features.append("VarHandle: ").append(PlatformInfo.supportsVarHandle()).append("\n");
        features.append("FFI: ").append(PlatformInfo.supportsFFI());
        return features.toString();
    }
}

