/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.gc;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.Unsafe;

public class MemoryManager {
    private static volatile MemoryManager instance;
    private static final AtomicBoolean initialized;
    private static Unsafe unsafe;
    private volatile boolean memoryManagerEnabled = false;
    private volatile boolean memoryOptimizationEnabled = false;
    private volatile boolean memoryMonitoringEnabled = false;
    private volatile boolean memoryCompactionEnabled = false;
    private volatile long memoryThreshold = 80L;
    private volatile long memoryCompactionThreshold = 90L;
    private volatile long memoryMonitoringInterval = 5000L;
    private volatile long memoryCompactionInterval = 30000L;
    private volatile long totalMemoryAllocated = 0L;
    private volatile long totalMemoryFreed = 0L;
    private volatile long totalMemoryCompactions = 0L;
    private volatile long totalMemoryOptimizations = 0L;
    private volatile long lastMemoryUsage = 0L;
    private volatile long peakMemoryUsage = 0L;
    private final Map<String, MemoryRegion> memoryRegions = new ConcurrentHashMap<String, MemoryRegion>();
    private final Map<Long, MemoryOperation> memoryOperations = new ConcurrentHashMap<Long, MemoryOperation>();
    private final ScheduledExecutorService monitoringExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService compactionExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, MemoryCache> memoryCache = new ConcurrentHashMap<String, MemoryCache>();

    public MemoryManager() {
        this.initializeMemoryManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemoryManager getInstance() {
        if (instance != null) return instance;
        Class<MemoryManager> clazz = MemoryManager.class;
        synchronized (MemoryManager.class) {
            if (instance != null) return instance;
            instance = new MemoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initializeMemoryManager() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
            if (unsafe != null) {
                this.checkMemoryManagerCapabilities();
                this.initializeMemoryRegions();
                this.startMemoryMonitoring();
                initialized.set(true);
                System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u7ba1\u7406\u5668\u652f\u6301\u521d\u59cb\u5316\u6210\u529f");
            }
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u7ba1\u7406\u5668\u652f\u6301\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            initialized.set(false);
        }
    }

    private void checkMemoryManagerCapabilities() {
        try {
            this.memoryManagerEnabled = this.checkMemoryManagerAvailable();
            this.memoryOptimizationEnabled = this.checkMemoryOptimizationAvailable();
            this.memoryMonitoringEnabled = this.checkMemoryMonitoringAvailable();
            this.memoryCompactionEnabled = this.checkMemoryCompactionAvailable();
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u68c0\u67e5\u5185\u5b58\u7ba1\u7406\u5668\u529f\u80fd\u5931\u8d25: " + e.getMessage());
        }
    }

    private boolean checkMemoryManagerAvailable() {
        try {
            return unsafe != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkMemoryOptimizationAvailable() {
        try {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkMemoryMonitoringAvailable() {
        try {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkMemoryCompactionAvailable() {
        try {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initializeMemoryRegions() {
        try {
            this.memoryRegions.put("heap", new MemoryRegion("heap", "Java\u5806", 0L, 0L));
            this.memoryRegions.put("metaspace", new MemoryRegion("metaspace", "\u5143\u7a7a\u95f4", 0L, 0L));
            this.memoryRegions.put("codecache", new MemoryRegion("codecache", "\u4ee3\u7801\u7f13\u5b58", 0L, 0L));
            this.memoryRegions.put("compressed", new MemoryRegion("compressed", "\u538b\u7f29\u7c7b\u7a7a\u95f4", 0L, 0L));
            this.memoryRegions.put("native", new MemoryRegion("native", "\u672c\u5730\u5185\u5b58", 0L, 0L));
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u533a\u57df\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u521d\u59cb\u5316\u5185\u5b58\u533a\u57df\u5931\u8d25: " + e.getMessage());
        }
    }

    private void startMemoryMonitoring() {
        if (!this.isMemoryMonitoringEnabled()) {
            return;
        }
        try {
            this.monitoringExecutor.scheduleAtFixedRate(this::performMemoryMonitoring, this.memoryMonitoringInterval, this.memoryMonitoringInterval, TimeUnit.MILLISECONDS);
            this.compactionExecutor.scheduleAtFixedRate(this::performMemoryCompaction, this.memoryCompactionInterval, this.memoryCompactionInterval, TimeUnit.MILLISECONDS);
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u76d1\u63a7\u4efb\u52a1\u5df2\u542f\u52a8");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u542f\u52a8\u5185\u5b58\u76d1\u63a7\u4efb\u52a1\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean isInitialized() {
        return initialized.get() && unsafe != null;
    }

    public boolean isMemoryManagerEnabled() {
        return this.memoryManagerEnabled;
    }

    public boolean isMemoryOptimizationEnabled() {
        return this.memoryOptimizationEnabled;
    }

    public boolean isMemoryMonitoringEnabled() {
        return this.memoryMonitoringEnabled;
    }

    public boolean isMemoryCompactionEnabled() {
        return this.memoryCompactionEnabled;
    }

    public long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMemoryCompactionThreshold() {
        return this.memoryCompactionThreshold;
    }

    public long getMemoryMonitoringInterval() {
        return this.memoryMonitoringInterval;
    }

    public long getMemoryCompactionInterval() {
        return this.memoryCompactionInterval;
    }

    public boolean setMemoryThreshold(long threshold) {
        if (threshold < 50L || threshold > 95L) {
            return false;
        }
        try {
            this.memoryThreshold = threshold;
            System.out.println("\u00a7d[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u9608\u503c: " + threshold + "%");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u9608\u503c\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public boolean setMemoryCompactionThreshold(long threshold) {
        if (threshold < 70L || threshold > 98L) {
            return false;
        }
        try {
            this.memoryCompactionThreshold = threshold;
            System.out.println("\u00a7d[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u538b\u7f29\u9608\u503c: " + threshold + "%");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u538b\u7f29\u9608\u503c\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public boolean setMemoryMonitoringInterval(long interval) {
        if (interval < 1000L || interval > 60000L) {
            return false;
        }
        try {
            this.memoryMonitoringInterval = interval;
            System.out.println("\u00a7d[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u76d1\u63a7\u95f4\u9694: " + interval + "ms");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u76d1\u63a7\u95f4\u9694\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public boolean setMemoryCompactionInterval(long interval) {
        if (interval < 10000L || interval > 300000L) {
            return false;
        }
        try {
            this.memoryCompactionInterval = interval;
            System.out.println("\u00a7d[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u538b\u7f29\u95f4\u9694: " + interval + "ms");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u8bbe\u7f6e\u5185\u5b58\u538b\u7f29\u95f4\u9694\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public long allocateMemory(long size, String region) {
        if (!this.isMemoryManagerEnabled() || size <= 0L) {
            return -1L;
        }
        try {
            if (this.getCurrentMemoryUsage() > this.memoryThreshold) {
                System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u4f7f\u7528\u7387\u8fc7\u9ad8\uff0c\u65e0\u6cd5\u5206\u914d: " + this.formatSize(size));
                return -1L;
            }
            long memoryAddress = unsafe.allocateMemory(size);
            if (memoryAddress == 0L) {
                System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u5206\u914d\u5931\u8d25");
                return -1L;
            }
            this.totalMemoryAllocated += size;
            this.lastMemoryUsage = this.getCurrentMemoryUsage();
            if (this.lastMemoryUsage > this.peakMemoryUsage) {
                this.peakMemoryUsage = this.lastMemoryUsage;
            }
            this.updateMemoryRegion(region, size, true);
            this.recordMemoryOperation("ALLOCATE", region, size, true);
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u5206\u914d\u6210\u529f: " + this.formatSize(size) + " (\u533a\u57df: " + region + ", \u5730\u5740: 0x" + Long.toHexString(memoryAddress) + ")");
            return memoryAddress;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u5206\u914d\u5931\u8d25: " + e.getMessage());
            return -1L;
        }
    }

    public boolean freeMemory(long memoryAddress, long size, String region) {
        if (!this.isMemoryManagerEnabled() || memoryAddress <= 0L || size <= 0L) {
            return false;
        }
        try {
            unsafe.freeMemory(memoryAddress);
            this.totalMemoryFreed += size;
            this.lastMemoryUsage = this.getCurrentMemoryUsage();
            this.updateMemoryRegion(region, size, false);
            this.recordMemoryOperation("FREE", region, size, true);
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u91ca\u653e\u6210\u529f: " + this.formatSize(size) + " (\u533a\u57df: " + region + ", \u5730\u5740: 0x" + Long.toHexString(memoryAddress) + ")");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u91ca\u653e\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public long reallocateMemory(long oldAddress, long oldSize, long newSize, String region) {
        if (!this.isMemoryManagerEnabled() || oldAddress <= 0L || newSize <= 0L) {
            return -1L;
        }
        try {
            long newAddress = this.allocateMemory(newSize, region);
            if (newAddress == -1L) {
                return -1L;
            }
            if (oldSize > 0L) {
                long copySize = Math.min(oldSize, newSize);
                unsafe.copyMemory(oldAddress, newAddress, copySize);
            }
            this.freeMemory(oldAddress, oldSize, region);
            this.recordMemoryOperation("REALLOCATE", region, newSize, true);
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u91cd\u65b0\u5206\u914d\u6210\u529f: " + this.formatSize(oldSize) + " -> " + this.formatSize(newSize));
            return newAddress;
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u91cd\u65b0\u5206\u914d\u5931\u8d25: " + e.getMessage());
            return -1L;
        }
    }

    public long getCurrentMemoryUsage() {
        try {
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            return totalMemory > 0L ? usedMemory * 100L / totalMemory : 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public MemoryRegion getMemoryRegion(String region) {
        return this.memoryRegions.get(region);
    }

    public Map<String, MemoryRegion> getAllMemoryRegions() {
        return new ConcurrentHashMap<String, MemoryRegion>(this.memoryRegions);
    }

    private void updateMemoryRegion(String region, long size, boolean isAllocation) {
        try {
            MemoryRegion memoryRegion = this.memoryRegions.get(region);
            if (memoryRegion != null) {
                if (isAllocation) {
                    memoryRegion.addAllocatedMemory(size);
                } else {
                    memoryRegion.addFreedMemory(size);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void performMemoryMonitoring() {
        try {
            long currentUsage = this.getCurrentMemoryUsage();
            if (currentUsage > this.memoryThreshold) {
                System.out.println("\u00a7e[MemoryManager] \u5185\u5b58\u4f7f\u7528\u7387\u8b66\u544a: " + currentUsage + "%");
                if (this.isMemoryOptimizationEnabled()) {
                    this.performMemoryOptimization();
                }
            }
            if (currentUsage > this.memoryCompactionThreshold) {
                System.out.println("\u00a7c[MemoryManager] \u5185\u5b58\u4f7f\u7528\u7387\u4e25\u91cd: " + currentUsage + "%");
                if (this.isMemoryCompactionEnabled()) {
                    this.performMemoryCompaction();
                }
            }
            this.updateMemoryRegionsInfo();
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u76d1\u63a7\u5931\u8d25: " + e.getMessage());
        }
    }

    private void performMemoryOptimization() {
        try {
            System.out.println("\u00a7d[MemoryManager] \u5f00\u59cb\u6267\u884c\u5185\u5b58\u4f18\u5316...");
            Thread.sleep(100L);
            ++this.totalMemoryOptimizations;
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u4f18\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u4f18\u5316\u5931\u8d25: " + e.getMessage());
        }
    }

    private void performMemoryCompaction() {
        try {
            System.out.println("\u00a7d[MemoryManager] \u5f00\u59cb\u6267\u884c\u5185\u5b58\u538b\u7f29...");
            Thread.sleep(500L);
            ++this.totalMemoryCompactions;
            System.out.println("\u00a7d[MemoryManager] \u5185\u5b58\u538b\u7f29\u5b8c\u6210");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u5185\u5b58\u538b\u7f29\u5931\u8d25: " + e.getMessage());
        }
    }

    private void updateMemoryRegionsInfo() {
        try {
            Runtime runtime = Runtime.getRuntime();
            MemoryRegion heapRegion = this.memoryRegions.get("heap");
            if (heapRegion != null) {
                heapRegion.setTotalMemory(runtime.totalMemory());
                heapRegion.setUsedMemory(runtime.totalMemory() - runtime.freeMemory());
            }
            for (Map.Entry<String, MemoryRegion> entry : this.memoryRegions.entrySet()) {
                String regionName = entry.getKey();
                if ("heap".equals(regionName)) continue;
                MemoryRegion region = entry.getValue();
                region.setTotalMemory(0x4000000L);
                region.setUsedMemory(0x2000000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMemoryManagerStatistics() {
        StringBuilder stats = new StringBuilder();
        stats.append("\u5185\u5b58\u7ba1\u7406\u5668\u7edf\u8ba1\u4fe1\u606f:\n");
        stats.append("\u603b\u5206\u914d\u5185\u5b58: ").append(this.formatSize(this.totalMemoryAllocated)).append("\n");
        stats.append("\u603b\u91ca\u653e\u5185\u5b58: ").append(this.formatSize(this.totalMemoryFreed)).append("\n");
        stats.append("\u603b\u5185\u5b58\u4f18\u5316\u6b21\u6570: ").append(this.totalMemoryOptimizations).append("\n");
        stats.append("\u603b\u5185\u5b58\u538b\u7f29\u6b21\u6570: ").append(this.totalMemoryCompactions).append("\n");
        stats.append("\u5f53\u524d\u5185\u5b58\u4f7f\u7528\u7387: ").append(this.getCurrentMemoryUsage()).append("%\n");
        stats.append("\u5cf0\u503c\u5185\u5b58\u4f7f\u7528\u7387: ").append(this.peakMemoryUsage).append("%\n");
        stats.append("\n\u5185\u5b58\u7ba1\u7406\u5668\u914d\u7f6e:\n");
        stats.append("\u5185\u5b58\u9608\u503c: ").append(this.memoryThreshold).append("%\n");
        stats.append("\u5185\u5b58\u538b\u7f29\u9608\u503c: ").append(this.memoryCompactionThreshold).append("%\n");
        stats.append("\u5185\u5b58\u76d1\u63a7\u95f4\u9694: ").append(this.memoryMonitoringInterval).append("ms\n");
        stats.append("\u5185\u5b58\u538b\u7f29\u95f4\u9694: ").append(this.memoryCompactionInterval).append("ms\n");
        stats.append("\n\u5185\u5b58\u533a\u57df\u4fe1\u606f:\n");
        for (Map.Entry<String, MemoryRegion> entry : this.memoryRegions.entrySet()) {
            MemoryRegion region = entry.getValue();
            stats.append(region.getName()).append(": ").append(this.formatSize(region.getUsedMemory())).append(" / ").append(this.formatSize(region.getTotalMemory())).append(" (").append(region.getTotalMemory() > 0L ? String.format("%.1f%%", (double)region.getUsedMemory() / (double)region.getTotalMemory() * 100.0) : "0%").append(")\n");
        }
        stats.append("\n\u64cd\u4f5c\u5386\u53f2: ").append(this.memoryOperations.size()).append(" \u6b21\n");
        return stats.toString();
    }

    private long recordMemoryOperation(String operation, String region, long size, boolean result) {
        try {
            long operationId = System.nanoTime();
            MemoryOperation memoryOp = new MemoryOperation(operationId, operation, region, size, result, System.currentTimeMillis());
            this.memoryOperations.put(operationId, memoryOp);
            return operationId;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public Map<Long, MemoryOperation> getMemoryOperations() {
        return new ConcurrentHashMap<Long, MemoryOperation>(this.memoryOperations);
    }

    public String getSystemInfo() {
        if (!this.isInitialized()) {
            return "\u5185\u5b58\u7ba1\u7406\u5668\u652f\u6301\u672a\u521d\u59cb\u5316";
        }
        StringBuilder info = new StringBuilder();
        info.append("\u5185\u5b58\u7ba1\u7406\u5668\u652f\u6301\u7cfb\u7edf\u4fe1\u606f:\n");
        info.append("\u521d\u59cb\u5316\u72b6\u6001: ").append(this.isInitialized() ? "\u5df2\u521d\u59cb\u5316" : "\u672a\u521d\u59cb\u5316").append("\n");
        info.append("\u5185\u5b58\u7ba1\u7406\u5668\u529f\u80fd: ").append(this.isMemoryManagerEnabled() ? "\u542f\u7528" : "\u7981\u7528").append("\n");
        info.append("\u5185\u5b58\u4f18\u5316\u529f\u80fd: ").append(this.isMemoryOptimizationEnabled() ? "\u542f\u7528" : "\u7981\u7528").append("\n");
        info.append("\u5185\u5b58\u76d1\u63a7\u529f\u80fd: ").append(this.isMemoryMonitoringEnabled() ? "\u542f\u7528" : "\u7981\u7528").append("\n");
        info.append("\u5185\u5b58\u538b\u7f29\u529f\u80fd: ").append(this.isMemoryCompactionEnabled() ? "\u542f\u7528" : "\u7981\u7528").append("\n");
        info.append("Unsafe\u53ef\u7528: ").append(unsafe != null ? "\u662f" : "\u5426").append("\n");
        info.append("\n").append(this.getMemoryManagerStatistics());
        return info.toString();
    }

    private String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    public void cleanup() {
        try {
            if (this.monitoringExecutor != null && !this.monitoringExecutor.isShutdown()) {
                this.monitoringExecutor.shutdown();
            }
            if (this.compactionExecutor != null && !this.compactionExecutor.isShutdown()) {
                this.compactionExecutor.shutdown();
            }
            this.memoryOperations.clear();
            this.memoryCache.clear();
            initialized.set(false);
            System.out.println("\u00a7d[MemoryManager] \u8d44\u6e90\u6e05\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            System.err.println("\u00a7c[MemoryManager] \u8d44\u6e90\u6e05\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    static {
        initialized = new AtomicBoolean(false);
    }

    public static class MemoryRegion {
        private final String id;
        private final String name;
        private volatile long totalMemory;
        private volatile long usedMemory;
        private volatile long allocatedMemory;
        private volatile long freedMemory;

        public MemoryRegion(String id, String name, long totalMemory, long usedMemory) {
            this.id = id;
            this.name = name;
            this.totalMemory = totalMemory;
            this.usedMemory = usedMemory;
            this.allocatedMemory = 0L;
            this.freedMemory = 0L;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getUsedMemory() {
            return this.usedMemory;
        }

        public long getAllocatedMemory() {
            return this.allocatedMemory;
        }

        public long getFreedMemory() {
            return this.freedMemory;
        }

        public void setTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
        }

        public void setUsedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
        }

        public void addAllocatedMemory(long size) {
            this.allocatedMemory += size;
            this.usedMemory += size;
        }

        public void addFreedMemory(long size) {
            this.freedMemory += size;
            this.usedMemory = Math.max(0L, this.usedMemory - size);
        }

        public String toString() {
            return String.format("MemoryRegion{id=%s, name=%s, total=%d, used=%d, allocated=%d, freed=%d}", this.id, this.name, this.totalMemory, this.usedMemory, this.allocatedMemory, this.freedMemory);
        }
    }

    public static class MemoryOperation {
        private final long operationId;
        private final String operation;
        private final String region;
        private final long size;
        private final boolean result;
        private final long timestamp;

        public MemoryOperation(long operationId, String operation, String region, long size, boolean result, long timestamp) {
            this.operationId = operationId;
            this.operation = operation;
            this.region = region;
            this.size = size;
            this.result = result;
            this.timestamp = timestamp;
        }

        public long getOperationId() {
            return this.operationId;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getRegion() {
            return this.region;
        }

        public long getSize() {
            return this.size;
        }

        public boolean getResult() {
            return this.result;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return String.format("MemoryOperation{id=%d, op=%s, region=%s, size=%d, result=%s, time=%d}", this.operationId, this.operation, this.region, this.size, this.result, this.timestamp);
        }
    }

    public static class MemoryCache {
        private final String key;
        private final Object value;
        private final long timestamp;

        public MemoryCache(String key, Object value, long timestamp) {
            this.key = key;
            this.value = value;
            this.timestamp = timestamp;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

