/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot;

import com.buwan.shizuku.jvm.helfy.Type;

public abstract class JVMObject {
    protected final Type type;
    protected final long address;
    protected final int hashCode;

    protected JVMObject(Type type) {
        this.type = type;
        this.address = System.identityHashCode(this);
        this.hashCode = (int)(this.address ^ this.address >>> 32);
    }

    public Type getType() {
        return this.type;
    }

    public long getAddress() {
        return this.address;
    }

    public abstract long getSize();

    public abstract long getMark();

    public abstract void setMark(long var1);

    public abstract long getKlass();

    public abstract void setKlass(long var1);

    public boolean isNull() {
        return this == null;
    }

    public boolean isValid() {
        return this != null && this.type != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + String.valueOf(this.type) + ", address=0x" + Long.toHexString(this.address) + ", hashCode=" + this.hashCode + "}";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JVMObject that = (JVMObject)obj;
        return this.address == that.address && this.type.equals(that.type);
    }

    public String getDetails() {
        return String.format("Type: %s, Address: 0x%x, Size: %d bytes", this.type.getTypeName(), this.address, this.getSize());
    }
}

