/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;

public class AccessFlags
extends JVMObject {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MODULE = 32768;
    private int flags;

    public AccessFlags() {
        super(JVM.type("AccessFlags"));
        this.flags = 0;
    }

    public AccessFlags(int flags) {
        super(JVM.type("AccessFlags"));
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlag(int flag) {
        this.flags |= flag;
    }

    public void removeFlag(int flag) {
        this.flags &= ~flag;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isPublic() {
        return this.hasFlag(1);
    }

    public boolean isPrivate() {
        return this.hasFlag(2);
    }

    public boolean isProtected() {
        return this.hasFlag(4);
    }

    public boolean isStatic() {
        return this.hasFlag(8);
    }

    public boolean isFinal() {
        return this.hasFlag(16);
    }

    public boolean isSynchronized() {
        return this.hasFlag(32);
    }

    public boolean isVolatile() {
        return this.hasFlag(64);
    }

    public boolean isNative() {
        return this.hasFlag(256);
    }

    public boolean isInterface() {
        return this.hasFlag(512);
    }

    public boolean isAbstract() {
        return this.hasFlag(1024);
    }

    public boolean isSynthetic() {
        return this.hasFlag(4096);
    }

    public boolean isAnnotation() {
        return this.hasFlag(8192);
    }

    public boolean isEnum() {
        return this.hasFlag(16384);
    }

    public boolean isModule() {
        return this.hasFlag(32768);
    }

    public boolean isTransient() {
        return this.hasFlag(128);
    }

    public boolean isBridge() {
        return this.hasFlag(64);
    }

    public boolean isVarargs() {
        return this.hasFlag(128);
    }

    public boolean isStrict() {
        return this.hasFlag(2048);
    }

    public String getModifierString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPublic()) {
            sb.append("public ");
        }
        if (this.isPrivate()) {
            sb.append("private ");
        }
        if (this.isProtected()) {
            sb.append("protected ");
        }
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        if (this.isSynchronized()) {
            sb.append("synchronized ");
        }
        if (this.isVolatile()) {
            sb.append("volatile ");
        }
        if (this.isTransient()) {
            sb.append("transient ");
        }
        if (this.isNative()) {
            sb.append("native ");
        }
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.isInterface()) {
            sb.append("interface ");
        }
        if (this.isAnnotation()) {
            sb.append("@interface ");
        }
        if (this.isEnum()) {
            sb.append("enum ");
        }
        if (this.isModule()) {
            sb.append("module ");
        }
        if (this.isSynthetic()) {
            sb.append("synthetic ");
        }
        if (this.isBridge()) {
            sb.append("bridge ");
        }
        if (this.isVarargs()) {
            sb.append("varargs ");
        }
        if (this.isStrict()) {
            sb.append("strictfp ");
        }
        return sb.toString().trim();
    }

    public String getHexString() {
        return String.format("0x%04X", this.flags);
    }

    @Override
    public long getSize() {
        return 28L;
    }

    @Override
    public long getMark() {
        return this.flags;
    }

    @Override
    public void setMark(long mark) {
        this.flags = (int)mark;
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "AccessFlags{flags=" + this.getHexString() + ", modifiers='" + this.getModifierString() + "'}";
    }
}

