/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderData
extends JVMObject {
    private final String loaderName;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> loadedClasses;
    private final Set<String> loadedClassNames;
    private final long loaderId;
    private final boolean isSystemLoader;

    public ClassLoaderData(String loaderName, ClassLoader classLoader) {
        super(JVM.type("ClassLoaderData"));
        this.loaderName = loaderName;
        this.classLoader = classLoader;
        this.loadedClasses = new ConcurrentHashMap();
        this.loadedClassNames = ConcurrentHashMap.newKeySet();
        this.loaderId = System.identityHashCode(classLoader);
        this.isSystemLoader = classLoader == null || classLoader == ClassLoader.getSystemClassLoader();
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public long getLoaderId() {
        return this.loaderId;
    }

    public boolean isSystemLoader() {
        return this.isSystemLoader;
    }

    public void addLoadedClass(String className, Class<?> clazz) {
        if (className != null && clazz != null) {
            this.loadedClasses.put(className, clazz);
            this.loadedClassNames.add(className);
        }
    }

    public void removeLoadedClass(String className) {
        if (className != null) {
            this.loadedClasses.remove(className);
            this.loadedClassNames.remove(className);
        }
    }

    public boolean isClassLoaded(String className) {
        return className != null && this.loadedClassNames.contains(className);
    }

    public Class<?> getLoadedClass(String className) {
        return className != null ? this.loadedClasses.get(className) : null;
    }

    public Set<String> getLoadedClassNames() {
        return this.loadedClassNames;
    }

    public int getLoadedClassCount() {
        return this.loadedClasses.size();
    }

    public void clearLoadedClasses() {
        this.loadedClasses.clear();
        this.loadedClassNames.clear();
    }

    public String getStatistics() {
        return String.format("Loader: %s, Classes: %d, System: %s", this.loaderName, this.getLoadedClassCount(), this.isSystemLoader);
    }

    public boolean isEmpty() {
        return this.loadedClasses.isEmpty();
    }

    public long getMemoryUsage() {
        long baseSize = 64L;
        long classNamesSize = this.loadedClassNames.stream().mapToLong(name -> name != null ? (long)(name.length() * 2) : 0L).sum();
        return baseSize + classNamesSize;
    }

    @Override
    public long getSize() {
        return this.getMemoryUsage();
    }

    @Override
    public long getMark() {
        return this.loaderId;
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "ClassLoaderData{loaderName='" + this.loaderName + "', loaderId=" + this.loaderId + ", loadedClasses=" + this.getLoadedClassCount() + ", isSystemLoader=" + this.isSystemLoader + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassLoaderData that = (ClassLoaderData)obj;
        return this.loaderId == that.loaderId;
    }

    @Override
    public int hashCode() {
        return (int)this.loaderId;
    }
}

