/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Dictionary
extends JVMObject {
    private final Map<Object, Object> entries;
    private final String name;
    private final int capacity;
    private final int size;

    public Dictionary(String name, int capacity) {
        super(JVM.type("Dictionary"));
        this.name = name;
        this.capacity = capacity;
        this.entries = new ConcurrentHashMap<Object, Object>(capacity);
        this.size = 0;
    }

    public Dictionary(String name) {
        this(name, 16);
    }

    public String getName() {
        return this.name;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean isFull() {
        return this.getEntryCount() >= this.capacity;
    }

    public void put(Object key, Object value) {
        if (key != null) {
            this.entries.put(key, value);
        }
    }

    public Object get(Object key) {
        return key != null ? this.entries.get(key) : null;
    }

    public Object remove(Object key) {
        return key != null ? this.entries.remove(key) : null;
    }

    public boolean containsKey(Object key) {
        return key != null && this.entries.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    public Set<Object> keySet() {
        return this.entries.keySet();
    }

    public Collection<Object> values() {
        return this.entries.values();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.entries.entrySet();
    }

    public void clear() {
        this.entries.clear();
    }

    public String getStatistics() {
        return String.format("Dictionary: %s, Size: %d/%d, Load: %.2f%%", this.name, this.getEntryCount(), this.capacity, (double)this.getEntryCount() / (double)this.capacity * 100.0);
    }

    public long getMemoryUsage() {
        long baseSize = 64L;
        long entriesSize = this.entries.entrySet().stream().mapToLong(entry -> {
            long keySize = entry.getKey() != null ? (long)(entry.getKey().toString().length() * 2) : 0L;
            long valueSize = entry.getValue() != null ? (long)(entry.getValue().toString().length() * 2) : 0L;
            return keySize + valueSize + 16L;
        }).sum();
        return baseSize + entriesSize;
    }

    @Override
    public long getSize() {
        return this.getMemoryUsage();
    }

    @Override
    public long getMark() {
        return System.identityHashCode(this);
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "Dictionary{name='" + this.name + "', size=" + this.getEntryCount() + ", capacity=" + this.capacity + "}";
    }
}

