/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Hashtable
extends JVMObject {
    private final Map<Object, Object> entries;
    private final String name;
    private final int initialCapacity;
    private final float loadFactor;
    private final int threshold;

    public Hashtable(String name, int initialCapacity, float loadFactor) {
        super(JVM.type("Hashtable"));
        this.name = name;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.entries = new ConcurrentHashMap<Object, Object>(initialCapacity, loadFactor);
    }

    public Hashtable(String name, int initialCapacity) {
        this(name, initialCapacity, 0.75f);
    }

    public Hashtable(String name) {
        this(name, 16, 0.75f);
    }

    public String getName() {
        return this.name;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean isFull() {
        return this.entries.size() >= this.threshold;
    }

    public void put(Object key, Object value) {
        if (key != null) {
            this.entries.put(key, value);
        }
    }

    public Object get(Object key) {
        return key != null ? this.entries.get(key) : null;
    }

    public Object remove(Object key) {
        return key != null ? this.entries.remove(key) : null;
    }

    public boolean containsKey(Object key) {
        return key != null && this.entries.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    public Set<Object> keySet() {
        return this.entries.keySet();
    }

    public Collection<Object> values() {
        return this.entries.values();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.entries.entrySet();
    }

    public void clear() {
        this.entries.clear();
    }

    public String getStatistics() {
        return String.format("Hashtable: %s, Size: %d/%d, Load: %.2f%%, Threshold: %d", this.name, this.getEntryCount(), this.initialCapacity, (double)this.getEntryCount() / (double)this.initialCapacity * 100.0, this.threshold);
    }

    public long getMemoryUsage() {
        long baseSize = 64L;
        long entriesSize = this.entries.entrySet().stream().mapToLong(entry -> {
            long keySize = entry.getKey() != null ? (long)(entry.getKey().toString().length() * 2) : 0L;
            long valueSize = entry.getValue() != null ? (long)(entry.getValue().toString().length() * 2) : 0L;
            return keySize + valueSize + 16L;
        }).sum();
        return baseSize + entriesSize;
    }

    public String getPerformanceMetrics() {
        int capacity;
        int size = this.getEntryCount();
        double loadFactor = (double)size / (double)(capacity = this.initialCapacity);
        String status = loadFactor > 0.8 ? "High Load" : (loadFactor > 0.5 ? "Medium Load" : "Low Load");
        return String.format("Performance: %s, Load Factor: %.2f, Efficiency: %s", status, loadFactor, loadFactor < 0.7 ? "Good" : "Needs Attention");
    }

    @Override
    public long getSize() {
        return this.getMemoryUsage();
    }

    @Override
    public long getMark() {
        return System.identityHashCode(this);
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "Hashtable{name='" + this.name + "', size=" + this.getEntryCount() + ", capacity=" + this.initialCapacity + ", loadFactor=" + this.loadFactor + "}";
    }
}

