/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;

public class Symbol
extends JVMObject {
    private final String name;
    private final byte[] bytes;
    private final int length;
    private final int identityHash;

    public Symbol(String name) {
        super(JVM.type("Symbol"));
        this.name = name;
        this.bytes = name.getBytes();
        this.length = this.bytes.length;
        this.identityHash = name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public int getLength() {
        return this.length;
    }

    public int getIdentityHash() {
        return this.identityHash;
    }

    public boolean isEmpty() {
        return this.name == null || this.name.isEmpty();
    }

    public boolean startsWith(String prefix) {
        return this.name != null && this.name.startsWith(prefix);
    }

    public boolean endsWith(String suffix) {
        return this.name != null && this.name.endsWith(suffix);
    }

    public boolean contains(String str) {
        return this.name != null && this.name.contains(str);
    }

    public String substring(int beginIndex) {
        return this.name != null ? this.name.substring(beginIndex) : null;
    }

    public String substring(int beginIndex, int endIndex) {
        return this.name != null ? this.name.substring(beginIndex, endIndex) : null;
    }

    public String toLowerCase() {
        return this.name != null ? this.name.toLowerCase() : null;
    }

    public String toUpperCase() {
        return this.name != null ? this.name.toUpperCase() : null;
    }

    public String replace(char oldChar, char newChar) {
        return this.name != null ? this.name.replace(oldChar, newChar) : null;
    }

    public String replace(CharSequence target, CharSequence replacement) {
        return this.name != null ? this.name.replace(target, replacement) : null;
    }

    @Override
    public long getSize() {
        return 24 + (this.bytes != null ? this.bytes.length : 0);
    }

    @Override
    public long getMark() {
        return this.identityHash;
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "Symbol{name='" + this.name + "', length=" + this.length + ", identityHash=" + this.identityHash + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)obj;
        return this.name.equals(symbol.name);
    }

    @Override
    public int hashCode() {
        return this.identityHash;
    }
}

