/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops.klass;

import com.buwan.shizuku.jvm.hotspot.oops.AccessFlags;
import com.buwan.shizuku.jvm.hotspot.oops.Symbol;

public class Field {
    private final Symbol name;
    private final Symbol signature;
    private final AccessFlags accessFlags;
    private final Object defaultValue;
    private final int offset;
    private final boolean isStatic;

    public Field(Symbol name, Symbol signature, AccessFlags accessFlags, Object defaultValue, int offset) {
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
        this.defaultValue = defaultValue;
        this.offset = offset;
        this.isStatic = accessFlags != null && accessFlags.isStatic();
    }

    public Symbol getName() {
        return this.name;
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public AccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getFieldName() {
        return this.name != null ? this.name.getName() : "Unknown";
    }

    public String getFieldSignature() {
        return this.signature != null ? this.signature.getName() : "";
    }

    public String getFieldType() {
        String sig = this.getFieldSignature();
        if (sig.startsWith("L") && sig.endsWith(";")) {
            return sig.substring(1, sig.length() - 1).replace('/', '.');
        }
        return sig;
    }

    public boolean isPublic() {
        return this.accessFlags != null && this.accessFlags.isPublic();
    }

    public boolean isPrivate() {
        return this.accessFlags != null && this.accessFlags.isPrivate();
    }

    public boolean isProtected() {
        return this.accessFlags != null && this.accessFlags.isProtected();
    }

    public boolean isFinal() {
        return this.accessFlags != null && this.accessFlags.isFinal();
    }

    public boolean isVolatile() {
        return this.accessFlags != null && this.accessFlags.isVolatile();
    }

    public boolean isTransient() {
        return this.accessFlags != null && this.accessFlags.isTransient();
    }

    public String getModifierString() {
        if (this.accessFlags == null) {
            return "";
        }
        return this.accessFlags.getModifierString();
    }

    public String getFullDeclaration() {
        return String.format("%s %s %s;", this.getModifierString(), this.getFieldType(), this.getFieldName());
    }

    public String toString() {
        return "Field{name='" + this.getFieldName() + "', type='" + this.getFieldType() + "', modifiers='" + this.getModifierString() + "', offset=" + this.offset + ", static=" + this.isStatic + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Field field = (Field)obj;
        return this.name.equals(field.name) && this.signature.equals(field.signature) && this.offset == field.offset;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.signature.hashCode() ^ this.offset;
    }
}

