/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops.klass;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;
import com.buwan.shizuku.jvm.hotspot.oops.AccessFlags;
import com.buwan.shizuku.jvm.hotspot.oops.Symbol;

public abstract class Klass
extends JVMObject {
    protected final Symbol name;
    protected final Symbol signature;
    protected final AccessFlags accessFlags;
    protected final Klass superKlass;
    protected final Klass[] interfaces;
    protected final long klassId;
    protected final int instanceSize;
    protected final int vtableLength;
    protected final int itableLength;

    protected Klass(Symbol name, Symbol signature, AccessFlags accessFlags) {
        super(JVM.type("Klass"));
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
        this.superKlass = null;
        this.interfaces = new Klass[0];
        this.klassId = System.identityHashCode(this);
        this.instanceSize = 0;
        this.vtableLength = 0;
        this.itableLength = 0;
    }

    protected Klass(Symbol name, Symbol signature, AccessFlags accessFlags, Klass superKlass, Klass[] interfaces) {
        super(JVM.type("Klass"));
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
        this.superKlass = superKlass;
        this.interfaces = interfaces != null ? interfaces : new Klass[]{};
        this.klassId = System.identityHashCode(this);
        this.instanceSize = this.calculateInstanceSize();
        this.vtableLength = this.calculateVTableLength();
        this.itableLength = this.calculateITableLength();
    }

    public Symbol getName() {
        return this.name;
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public AccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public Klass getSuperKlass() {
        return this.superKlass;
    }

    public Klass[] getInterfaces() {
        return (Klass[])this.interfaces.clone();
    }

    public long getKlassId() {
        return this.klassId;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getVTableLength() {
        return this.vtableLength;
    }

    public int getITableLength() {
        return this.itableLength;
    }

    public String getClassName() {
        return this.name != null ? this.name.getName() : "Unknown";
    }

    public String getClassSignature() {
        return this.signature != null ? this.signature.getName() : "";
    }

    public boolean isInterface() {
        return this.accessFlags != null && this.accessFlags.isInterface();
    }

    public boolean isAbstract() {
        return this.accessFlags != null && this.accessFlags.isAbstract();
    }

    public boolean isFinal() {
        return this.accessFlags != null && this.accessFlags.isFinal();
    }

    public boolean isPublic() {
        return this.accessFlags != null && this.accessFlags.isPublic();
    }

    public boolean isArray() {
        return this.getClassName().endsWith("[]");
    }

    public boolean isPrimitive() {
        String className = this.getClassName();
        return className.equals("boolean") || className.equals("char") || className.equals("byte") || className.equals("short") || className.equals("int") || className.equals("long") || className.equals("float") || className.equals("double");
    }

    public boolean isEnum() {
        return this.accessFlags != null && this.accessFlags.isEnum();
    }

    public boolean isAnnotation() {
        return this.accessFlags != null && this.accessFlags.isAnnotation();
    }

    public boolean isModule() {
        return this.accessFlags != null && this.accessFlags.isModule();
    }

    public String getHierarchy() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClassName());
        if (this.superKlass != null) {
            sb.append(" extends ").append(this.superKlass.getClassName());
        }
        if (this.interfaces.length > 0) {
            sb.append(" implements ");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.interfaces[i].getClassName());
            }
        }
        return sb.toString();
    }

    protected int calculateInstanceSize() {
        return 16;
    }

    protected int calculateVTableLength() {
        return 0;
    }

    protected int calculateITableLength() {
        return this.interfaces.length;
    }

    @Override
    public long getSize() {
        return 64 + (this.interfaces != null ? this.interfaces.length * 8 : 0);
    }

    @Override
    public long getMark() {
        return this.klassId;
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "Klass{name=" + this.getClassName() + ", signature='" + this.getClassSignature() + "', accessFlags=" + (this.accessFlags != null ? this.accessFlags.getModifierString() : "none") + ", superKlass=" + (this.superKlass != null ? this.superKlass.getClassName() : "none") + ", interfaces=" + this.interfaces.length + ", instanceSize=" + this.instanceSize + "}";
    }
}

