/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops.klass;

import com.buwan.shizuku.jvm.hotspot.oops.AccessFlags;
import com.buwan.shizuku.jvm.hotspot.oops.Symbol;

public class Method {
    private final Symbol name;
    private final Symbol signature;
    private final AccessFlags accessFlags;
    private final String returnType;
    private final String[] parameterTypes;
    private final int maxLocals;
    private final int maxStack;
    private final byte[] bytecode;

    public Method(Symbol name, Symbol signature, AccessFlags accessFlags, String returnType, String[] parameterTypes) {
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes != null ? (String[])parameterTypes.clone() : new String[]{};
        this.maxLocals = 0;
        this.maxStack = 0;
        this.bytecode = new byte[0];
    }

    public Method(Symbol name, Symbol signature, AccessFlags accessFlags, String returnType, String[] parameterTypes, int maxLocals, int maxStack, byte[] bytecode) {
        this.name = name;
        this.signature = signature;
        this.accessFlags = accessFlags;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes != null ? (String[])parameterTypes.clone() : new String[]{};
        this.maxLocals = maxLocals;
        this.maxStack = maxStack;
        this.bytecode = bytecode != null ? (byte[])bytecode.clone() : new byte[]{};
    }

    public Symbol getName() {
        return this.name;
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public AccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getParameterTypes() {
        return (String[])this.parameterTypes.clone();
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public byte[] getBytecode() {
        return (byte[])this.bytecode.clone();
    }

    public String getMethodName() {
        return this.name != null ? this.name.getName() : "Unknown";
    }

    public String getMethodSignature() {
        return this.signature != null ? this.signature.getName() : "";
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public boolean isStatic() {
        return this.accessFlags != null && this.accessFlags.isStatic();
    }

    public boolean isPublic() {
        return this.accessFlags != null && this.accessFlags.isPublic();
    }

    public boolean isPrivate() {
        return this.accessFlags != null && this.accessFlags.isPrivate();
    }

    public boolean isProtected() {
        return this.accessFlags != null && this.accessFlags.isProtected();
    }

    public boolean isFinal() {
        return this.accessFlags != null && this.accessFlags.isFinal();
    }

    public boolean isSynchronized() {
        return this.accessFlags != null && this.accessFlags.isSynchronized();
    }

    public boolean isNative() {
        return this.accessFlags != null && this.accessFlags.isNative();
    }

    public boolean isAbstract() {
        return this.accessFlags != null && this.accessFlags.isAbstract();
    }

    public boolean isBridge() {
        return this.accessFlags != null && this.accessFlags.isBridge();
    }

    public boolean isVarargs() {
        return this.accessFlags != null && this.accessFlags.isVarargs();
    }

    public boolean isSynthetic() {
        return this.accessFlags != null && this.accessFlags.isSynthetic();
    }

    public boolean isStrict() {
        return this.accessFlags != null && this.accessFlags.isStrict();
    }

    public String getModifierString() {
        if (this.accessFlags == null) {
            return "";
        }
        return this.accessFlags.getModifierString();
    }

    public String getFullDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getModifierString()).append(" ");
        sb.append(this.getReturnType()).append(" ");
        sb.append(this.getMethodName()).append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.parameterTypes[i]).append(" param").append(i);
        }
        sb.append(")");
        return sb.toString();
    }

    public String getDescriptor() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (String paramType : this.parameterTypes) {
            sb.append(paramType);
        }
        sb.append(")").append(this.returnType);
        return sb.toString();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getMethodName());
    }

    public boolean isStaticInitializer() {
        return "<clinit>".equals(this.getMethodName());
    }

    public String toString() {
        return "Method{name='" + this.getMethodName() + "', signature='" + this.getMethodSignature() + "', modifiers='" + this.getModifierString() + "', returnType='" + this.returnType + "', parameters=" + this.parameterTypes.length + ", maxLocals=" + this.maxLocals + ", maxStack=" + this.maxStack + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Method method = (Method)obj;
        return this.name.equals(method.name) && this.signature.equals(method.signature);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.signature.hashCode();
    }
}

