/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.network;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ToggleBladeFlagMessage {
    private final Flag flag;
    private static final ConcurrentHashMap<UUID, Boolean> ALLRETURN_ENABLED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> EVENTS_DISABLED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> ENTITY_ERASER_ENABLED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> INTERCEPTION_ENABLED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> SUPER_BAD_CORE_ENABLED = new ConcurrentHashMap();

    public ToggleBladeFlagMessage(Flag flag) {
        this.flag = flag;
    }

    public static void encode(ToggleBladeFlagMessage msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.flag);
    }

    public static ToggleBladeFlagMessage decode(FriendlyByteBuf buf) {
        return new ToggleBladeFlagMessage((Flag)buf.m_130066_(Flag.class));
    }

    public static void handle(ToggleBladeFlagMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            switch (msg.flag) {
                case ALLRETURN: {
                    ToggleBladeFlagMessage.toggleAllReturn(player);
                    break;
                }
                case DISABLE_EVENTS: {
                    ToggleBladeFlagMessage.toggleDisableEvents(player);
                    break;
                }
                case ENTITY_ERASER: {
                    ToggleBladeFlagMessage.toggleEntityEraser(player);
                    break;
                }
                case INTERCEPTION: {
                    ToggleBladeFlagMessage.toggleInterception(player);
                    break;
                }
                case SUPER_BAD_CORE: {
                    ToggleBladeFlagMessage.toggleSuperBadCore(player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void toggleAllReturn(ServerPlayer player) {
        boolean value = ALLRETURN_ENABLED.getOrDefault(player.m_20148_(), false) == false;
        ALLRETURN_ENABLED.put(player.m_20148_(), value);
    }

    private static void toggleDisableEvents(ServerPlayer player) {
        boolean value = EVENTS_DISABLED.getOrDefault(player.m_20148_(), false) == false;
        EVENTS_DISABLED.put(player.m_20148_(), value);
    }

    private static void toggleEntityEraser(ServerPlayer player) {
        boolean value = ENTITY_ERASER_ENABLED.getOrDefault(player.m_20148_(), false) == false;
        ENTITY_ERASER_ENABLED.put(player.m_20148_(), value);
    }

    private static void toggleInterception(ServerPlayer player) {
        boolean value = INTERCEPTION_ENABLED.getOrDefault(player.m_20148_(), false) == false;
        INTERCEPTION_ENABLED.put(player.m_20148_(), value);
    }

    private static void toggleSuperBadCore(ServerPlayer player) {
        boolean value = SUPER_BAD_CORE_ENABLED.getOrDefault(player.m_20148_(), false) == false;
        SUPER_BAD_CORE_ENABLED.put(player.m_20148_(), value);
    }

    public static boolean isAllReturnEnabled(ServerPlayer player) {
        return ALLRETURN_ENABLED.getOrDefault(player.m_20148_(), false);
    }

    public static boolean isEventsDisabled(ServerPlayer player) {
        return EVENTS_DISABLED.getOrDefault(player.m_20148_(), false);
    }

    public static boolean isEntityEraserEnabled(ServerPlayer player) {
        return ENTITY_ERASER_ENABLED.getOrDefault(player.m_20148_(), false);
    }

    public static boolean isInterceptionEnabled(ServerPlayer player) {
        return INTERCEPTION_ENABLED.getOrDefault(player.m_20148_(), false);
    }

    public static boolean isSuperBadCoreEnabled(ServerPlayer player) {
        return SUPER_BAD_CORE_ENABLED.getOrDefault(player.m_20148_(), false);
    }

    public static enum Flag {
        ALLRETURN,
        DISABLE_EVENTS,
        ENTITY_ERASER,
        INTERCEPTION,
        SUPER_BAD_CORE;

    }
}

