/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.sa;

import com.buwan.shizuku.shizuku;
import java.util.ArrayList;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.slasharts.Drive;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Shizukusa {
    private static final ResourceLocation[] LEISA_SOUNDS = new ResourceLocation[]{shizuku.LEISA_SOUND1.getId(), shizuku.LEISA_SOUND2.getId(), shizuku.LEISA_SOUND3.getId()};

    public static void doSlash(LivingEntity playerIn, float speed) {
        int colorCode = playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getColorCode).orElse(-13421569);
        Shizukusa.doSlash(playerIn, speed, colorCode, true);
    }

    public static void doSlash(LivingEntity playerIn, float speed, int colorCode, boolean playSound) {
        RandomSource random;
        ResourceLocation soundLoc;
        SoundEvent sound;
        if (playerIn.m_9236_().m_5776_()) {
            return;
        }
        if (playSound && (sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLoc = LEISA_SOUNDS[(random = playerIn.m_217043_()).m_188503_(LEISA_SOUNDS.length)])) != null) {
            playerIn.m_9236_().m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f + (random.m_188501_() - 0.5f) * 0.2f);
        }
        playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            Level worldIn = playerIn.m_9236_();
            RandomSource random = playerIn.m_217043_();
            Vec3 lookAngle = playerIn.m_20154_();
            for (int i = -1; i <= 1; ++i) {
                float angle = (float)i * 120.0f;
                Vec3 rotatedLook = Shizukusa.rotateY(lookAngle, angle);
                EntityDrive drive = Drive.doSlash((LivingEntity)playerIn, (float)(angle * 0.5f), (int)40, (Vec3)new Vec3(0.0, 0.5, 1.0).m_82490_(0.8 + (double)random.m_188501_() * 0.4), (boolean)true, (double)6.0, (float)(speed * (0.9f + random.m_188501_() * 0.2f)));
                if (drive == null) continue;
                drive.m_20225_(true);
            }
            Shizukusa.doFocusedJudgementCut(playerIn, 18.0f, 160.0f);
        });
    }

    private static Vec3 rotateY(Vec3 vec, float angleDegrees) {
        float angleRad = angleDegrees * ((float)Math.PI / 180);
        float cos = Mth.m_14089_((float)angleRad);
        float sin = Mth.m_14031_((float)angleRad);
        return new Vec3(vec.f_82479_ * (double)cos - vec.f_82481_ * (double)sin, vec.f_82480_, vec.f_82479_ * (double)sin + vec.f_82481_ * (double)cos);
    }

    private static void doFocusedJudgementCut(LivingEntity owner, float range, float angle) {
        Level level = owner.m_9236_();
        ItemStack stack = owner.m_21205_();
        Vec3 look = owner.m_20154_().m_82541_();
        ArrayList<Entity> founds = new ArrayList<Entity>();
        for (Entity entity : level.m_45933_((Entity)owner, owner.m_20191_().m_82400_((double)range))) {
            Vec3 toTarget;
            float targetAngle;
            if (!(entity instanceof LivingEntity) || !((targetAngle = (float)Math.toDegrees(Math.acos(look.m_82526_(toTarget = entity.m_20182_().m_82546_(owner.m_20182_()).m_82541_())))) <= angle / 2.0f)) continue;
            founds.add(entity);
        }
        for (Entity entity : founds) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 8));
            EntityJudgementCut judgementCut = new EntityJudgementCut(SlashBlade.RegistryEvents.JudgementCut, level);
            judgementCut.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            judgementCut.m_5602_((Entity)owner);
            judgementCut.m_20225_(true);
            stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> judgementCut.setColor(state.getColorCode()));
            owner.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> judgementCut.setRank(rank.getRankLevel(level.m_46467_())));
            level.m_7967_((Entity)judgementCut);
        }
    }
}

