/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.server;

import java.util.Set;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BladeProtectorServer {
    private static final Set<ResourceLocation> PROTECTED_BLADES = Set.of(new ResourceLocation("shizuku", "shizuku"), new ResourceLocation("shizuku", "el"), new ResourceLocation("shizuku", "ym"));

    public static boolean isProtectedBlade(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        try {
            if (stack.m_41720_() instanceof ItemSlashBlade) {
                String bladeName;
                String nbtName;
                CompoundTag display;
                String displayName = stack.m_41786_().getString();
                if (displayName.contains("\u65e0\u94ed") && displayName.contains("\u6709\u540d")) {
                    return true;
                }
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128441_("display") && (display = tag.m_128469_("display")).m_128441_("Name") && (nbtName = display.m_128461_("Name")).contains("\u65e0\u94ed") && nbtName.contains("\u6709\u540d")) {
                    return true;
                }
                if (tag.m_128441_("SB.SwordName") && (bladeName = tag.m_128461_("SB.SwordName")).contains("\u65e0\u94ed") && bladeName.contains("\u6709\u540d")) {
                    return true;
                }
                if (tag.m_128441_("shizuku:protected_blade") || tag.m_128441_("shizuku:keep_on_death")) {
                    return true;
                }
                return stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                    String bladeName = tag.m_128461_("SB.SwordName");
                    return bladeName != null && (bladeName.contains("shizuku") || bladeName.contains("el") || bladeName.contains("ym"));
                }).orElse(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        System.out.println("\u00a76[BladeProtectorServer] \u73a9\u5bb6\u767b\u5f55\uff0c\u786e\u4fdd\u4fdd\u62a4\u6807\u7b7e...");
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    if (stack == null || stack.m_41619_()) continue;
                    try {
                        if (!(stack.m_41720_() instanceof ItemSlashBlade) || !BladeProtectorServer.isProtectedBlade(stack)) continue;
                        CompoundTag tag = stack.m_41784_();
                        tag.m_128379_("shizuku:keep_on_death", true);
                        tag.m_128359_("shizuku:protected_blade", "true");
                        tag.m_128356_("shizuku:protection_timestamp", System.currentTimeMillis());
                        System.out.println("\u00a76[BladeProtectorServer] \u786e\u4fdd\u4fdd\u62a4\u7269\u54c1\u6807\u7b7e: " + stack.m_41786_().getString());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println("\u00a76[BladeProtectorServer] \u4fdd\u62a4\u6807\u7b7e\u786e\u4fdd\u5b8c\u6210\uff01");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ItemStack offHand;
        CompoundTag tag;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u6b7b\u4ea1\u4fdd\u62a4\u89e6\u53d1");
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!BladeProtectorServer.isProtectedBlade(stack)) continue;
            tag = stack.m_41784_();
            tag.m_128379_("shizuku:anti_disarm", true);
            tag.m_128359_("shizuku:protected_blade", "true");
            player.m_150109_().m_6836_(i, stack);
            System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u4fdd\u62a4\u7269\u54c1: " + stack.m_41786_().getString());
        }
        ItemStack mainHand = player.m_21205_();
        if (BladeProtectorServer.isProtectedBlade(mainHand)) {
            CompoundTag tag2 = mainHand.m_41784_();
            tag2.m_128379_("shizuku:anti_disarm", true);
            tag2.m_128359_("shizuku:protected_blade", "true");
            player.m_21008_(InteractionHand.MAIN_HAND, mainHand);
            System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u4fdd\u62a4\u4e3b\u624b\u7269\u54c1: " + mainHand.m_41786_().getString());
        }
        if (BladeProtectorServer.isProtectedBlade(offHand = player.m_21206_())) {
            tag = offHand.m_41784_();
            tag.m_128379_("shizuku:anti_disarm", true);
            tag.m_128359_("shizuku:protected_blade", "true");
            player.m_21008_(InteractionHand.OFF_HAND, offHand);
            System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u4fdd\u62a4\u526f\u624b\u7269\u54c1: " + offHand.m_41786_().getString());
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u6389\u843d\u62e6\u622a\u89e6\u53d1\uff0c\u6389\u843d\u6570\u91cf: " + event.getDrops().size());
        System.out.println("\u00a76[BladeProtectorServer] \u670d\u52a1\u5668\u7aef\u5141\u8bb8\u6240\u6709\u7269\u54c1\u6b63\u5e38\u6389\u843d");
    }
}

