/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.client;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipStyler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGatherComponents(RenderTooltipEvent.GatherComponents event) {
        String text;
        Component c;
        Either e;
        int i;
        ItemStack stack = event.getItemStack();
        if (!TooltipStyler.isOnlyNamelessFamous(stack)) {
            return;
        }
        List elements = event.getTooltipElements();
        boolean hasAnti = false;
        boolean hasKeep = false;
        for (Either e2 : elements) {
            String s0;
            if (!e2.left().isPresent()) continue;
            if (e2.left().get() instanceof Component) {
                Component c2 = (Component)e2.left().get();
                s0 = c2.getString();
            } else {
                s0 = ((FormattedText)e2.left().get()).toString();
            }
            if (s0.contains("\u9632\u7f34\u68b0\u4fdd\u62a4")) {
                hasAnti = true;
            }
            if (!s0.contains("\u6b7b\u4ea1\u4e0d\u6389\u843d")) continue;
            hasKeep = true;
        }
        boolean replacedAttack = false;
        for (i = 0; i < elements.size(); ++i) {
            e = (Either)elements.get(i);
            if (!e.left().isPresent()) continue;
            if (e.left().get() instanceof Component) {
                c = (Component)e.left().get();
                text = c.getString();
            } else {
                text = ((FormattedText)e.left().get()).toString();
            }
            if (!replacedAttack && text.contains("\u653b\u51fb\u4f24\u5bb3") && text.replace(" ", "").length() > 16) {
                elements.set(i, Either.left((Object)TooltipStyler.infiniteDamage()));
                replacedAttack = true;
                continue;
            }
            if (!TooltipStyler.looksLikeHugeNumber(text)) continue;
            elements.set(i, Either.left((Object)TooltipStyler.infiniteDamage()));
            replacedAttack = true;
        }
        for (i = 0; i < elements.size(); ++i) {
            e = (Either)elements.get(i);
            if (!e.left().isPresent()) continue;
            if (e.left().get() instanceof Component) {
                c = (Component)e.left().get();
                text = c.getString();
            } else {
                text = ((FormattedText)e.left().get()).toString();
            }
            elements.set(i, Either.left((Object)TooltipStyler.makeAllTextJump(text)));
        }
        int insertAt = Math.min(1, elements.size());
        if (!hasAnti) {
            elements.add(insertAt, Either.left((Object)TooltipStyler.gradient(" \u9632\u7f34\u68b0\u4fdd\u62a4 ")));
        }
        elements.add(Math.min(insertAt + 2, elements.size()), Either.left((Object)TooltipStyler.gradient(" Shift+R SuperBadCore")));
        elements.add(Math.min(insertAt + 3, elements.size()), Either.left((Object)TooltipStyler.gradient(" Shift+J EntityEraser+AllReturn")));
    }

    @SubscribeEvent
    public static void onColor(RenderTooltipEvent.Color event) {
        if (!TooltipStyler.isOnlyNamelessFamous(event.getItemStack())) {
            return;
        }
        event.setBackgroundStart(0x10000000);
        event.setBackgroundEnd(0x10000000);
        long time = System.currentTimeMillis();
        int borderStart = TooltipStyler.calculateGradientColor((float)((double)time * 0.001), 0.0f);
        int borderEnd = TooltipStyler.calculateGradientColor((float)((double)time * 0.001), 0.5f);
        event.setBorderStart(borderStart);
        event.setBorderEnd(borderEnd);
    }

    private static int calculateGradientColor(float time, float position) {
        float hue = (time + position * 0.3f) % 1.0f;
        float[] hueValues = new float[]{0.6f, 0.8f, 0.9f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f};
        float[] satValues = new float[]{0.9f, 0.8f, 0.7f, 0.9f, 0.9f, 0.9f, 0.8f, 0.9f};
        float[] valValues = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        int colorIndex = (int)(hue * (float)hueValues.length) % hueValues.length;
        int nextColorIndex = (colorIndex + 1) % hueValues.length;
        float factor = hue * (float)hueValues.length % 1.0f;
        float currentHue = hueValues[colorIndex] + (hueValues[nextColorIndex] - hueValues[colorIndex]) * factor;
        float currentSat = satValues[colorIndex] + (satValues[nextColorIndex] - satValues[colorIndex]) * factor;
        float currentVal = valValues[colorIndex] + (valValues[nextColorIndex] - valValues[colorIndex]) * factor;
        float flash = (float)Math.sin(time * 8.0f) * 0.1f + 0.9f;
        currentVal *= flash;
        float wave = (float)Math.sin(time * 3.0f + position * 6.28f) * 0.1f + 0.9f;
        currentVal *= wave;
        currentVal = Math.max(0.8f, currentVal);
        return TooltipStyler.hsvToRgb(currentHue, currentSat, currentVal);
    }

    private static boolean isOnlyNamelessFamous(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        try {
            String name = stack.m_41786_().getString();
            String lower = name.toLowerCase();
            if (name.contains("\u65e0\u94ed") && name.contains("\u6709\u540d")) {
                return true;
            }
            if (lower.contains("nameless famous")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean looksLikeHugeNumber(String text) {
        if (text == null) {
            return false;
        }
        String s = text.replaceAll("[^0-9]", "");
        return s.length() >= 12;
    }

    private static MutableComponent gradient(String text) {
        long t = System.currentTimeMillis() / 6L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            int hue = (int)((t + (long)(i * 18) + (long)(i % 2 * 180)) % 360L);
            float saturation = 0.9f + (float)(Math.sin((double)t / 80.0 + (double)i * 0.6) * 0.1);
            float brightness = 0.95f + (float)(Math.sin((double)t / 60.0 + (double)i * 0.4) * 0.05);
            double jumpOffset = Math.sin((double)t / 40.0 + (double)i * 1.0) * 2.0;
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, Math.max(0.8f, Math.min(1.0f, saturation)), Math.max(0.9f, Math.min(1.0f, brightness)));
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static MutableComponent infiniteDamage() {
        long t = System.currentTimeMillis() / 10L % 360L;
        MutableComponent out = Component.m_237113_((String)"\u653b\u51fb\u4f24\u5bb3: ");
        String infiniteText = "INFINITY";
        for (int i = 0; i < infiniteText.length(); ++i) {
            char ch = infiniteText.charAt(i);
            int hue = (int)((t + (long)(i * 25)) % 360L);
            double jumpOffset = Math.sin((double)t / 35.0 + (double)i * 1.5) * 2.5;
            float saturation = 0.9f + (float)(Math.sin((double)t / 50.0 + (double)i * 0.7) * 0.1);
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 10.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, saturation, brightness);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static MutableComponent jumpingTitle(String text) {
        long t = System.currentTimeMillis() / 10L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            double jumpOffset = Math.sin((double)t / 30.0 + (double)i * 1.5) * 3.0;
            double waveOffset = Math.sin((double)t / 60.0 + (double)i * 0.8) * 2.0;
            int hue = (int)(((double)(t + (long)(i * 20)) + jumpOffset * 10.0) % 360.0);
            float saturation = 1.0f;
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 8.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, saturation, brightness);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static MutableComponent makeAllTextJump(String text) {
        long t = System.currentTimeMillis() / 8L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            double jumpOffset = Math.sin((double)t / 30.0 + (double)i * 1.2) * 3.0;
            double waveOffset = Math.sin((double)t / 60.0 + (double)i * 0.8) * 3.0;
            int hue = (int)(((double)(t + (long)(i * 20)) + jumpOffset * 10.0) % 360.0);
            float saturation = 0.9f + (float)(Math.abs(jumpOffset) / 8.0);
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 12.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, Math.max(0.7f, Math.min(1.0f, saturation)), Math.max(0.6f, Math.min(1.0f, brightness)));
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static int hsvToRgb(float h, float s, float v) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float i = (float)Math.floor(h * 6.0f);
        float f = h * 6.0f - i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        int mod = (int)i % 6;
        switch (mod) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = (int)(r * 255.0f) & 0xFF;
        int gi = (int)(g * 255.0f) & 0xFF;
        int bi = (int)(b * 255.0f) & 0xFF;
        return ri << 16 | gi << 8 | bi;
    }

    private static MutableComponent createWeaponLore() {
        long t = System.currentTimeMillis() / 20L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        String loreText = "\u2726 \u795e\u5668\u00b7\u65e0\u94ed\u6709\u540d \u2726";
        for (int i = 0; i < loreText.length(); ++i) {
            char ch = loreText.charAt(i);
            double charTime = (double)t + (double)i * 15.0;
            double jumpOffset = Math.sin(charTime / 30.0) * 3.0;
            int hue = (int)((charTime * 2.0 + (double)(i * 25)) % 360.0);
            float saturation = 0.9f + (float)(Math.sin(charTime / 40.0 + (double)i * 0.3) * (double)0.1f);
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 8.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, saturation, brightness);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static MutableComponent createParticleSystem() {
        long t = System.currentTimeMillis() / 15L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        String particleText = "\u26a1 \u7c92\u5b50\u7cfb\u7edf: \u661f\u7a7a\u7c92\u5b50 + \u5f69\u8679\u8f68\u8ff9 \u26a1";
        for (int i = 0; i < particleText.length(); ++i) {
            char ch = particleText.charAt(i);
            double charTime = (double)t + (double)i * 12.0;
            double jumpOffset = Math.sin(charTime / 25.0) * 3.5;
            int baseHue = 240 + i * 20 % 60;
            int hue = (int)(((double)baseHue + charTime * 1.5) % 360.0);
            float saturation = 0.9f + (float)(Math.sin(charTime / 35.0 + (double)i * 0.4) * (double)0.1f);
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 10.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, saturation, brightness);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }

    private static MutableComponent createSpecialEffects() {
        long t = System.currentTimeMillis() / 12L % 360L;
        MutableComponent out = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)));
        String effectsText = "\ud83c\udf1f \u7279\u6548: \u65f6\u7a7a\u626d\u66f2 + \u7ef4\u5ea6\u5207\u5272 \ud83c\udf1f";
        for (int i = 0; i < effectsText.length(); ++i) {
            char ch = effectsText.charAt(i);
            double charTime = (double)t + (double)i * 18.0;
            double jumpOffset = Math.sin(charTime / 22.0) * 4.0;
            int baseHue = 280 + i * 25 % 40;
            int hue = (int)(((double)baseHue + charTime * 2.0) % 360.0);
            float saturation = 0.9f + (float)(Math.sin(charTime / 30.0 + (double)i * 0.5) * (double)0.1f);
            float brightness = 0.8f + (float)(Math.abs(jumpOffset) / 12.0);
            int rgb = TooltipStyler.hsvToRgb((float)hue / 360.0f, saturation, brightness);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(ch)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)).m_131136_(Boolean.valueOf(false)));
            out.m_7220_((Component)charComponent);
        }
        return out;
    }
}

