/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AdvancedProtectionSystem {
    private static final Map<String, Boolean> PROTECTION_STATES = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> INTERCEPTED_MODS = ConcurrentHashMap.newKeySet();
    private static final Map<String, Object> ORIGINAL_VALUES = new ConcurrentHashMap<String, Object>();
    private static final Set<String> PROTECTED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService PROTECTION_SCHEDULER = Executors.newScheduledThreadPool(4);
    private static final ScheduledExecutorService CLEANUP_SCHEDULER = Executors.newScheduledThreadPool(2);
    private static final ScheduledExecutorService ALLRETURN_SCHEDULER = Executors.newScheduledThreadPool(2);
    private static final AtomicBoolean ALLRETURN_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ENTITY_ERASER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean SUPER_BAD_CORE_ACTIVE = new AtomicBoolean(false);
    private static final Set<UUID> DEAD_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> PROTECTED_PLAYERS = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> ENTITY_REPLACEMENT_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<String, String> ENTITY_REPLACEMENT_MAP = Map.of("wither", "minecraft:ender_dragon", "\u51cb\u96f6", "minecraft:ender_dragon", "dragon", "minecraft:ender_dragon", "\u9f99", "minecraft:ender_dragon", "boss", "minecraft:wither", "chaos", "minecraft:ender_dragon", "\u6df7\u6c8c", "minecraft:ender_dragon", "silence", "minecraft:ender_dragon", "\u5f52\u5bc2", "minecraft:ender_dragon");
    private static final String[] PROTECTION_KEYWORDS = new String[]{"agentgodpower", "agent_godpower", "\u795e\u529b", "\u62e6\u622a", "chaoswither", "chaos_wither", "\u6df7\u6c8c\u51cb\u96f6", "chaos", "silence_wither", "silencewither", "\u5f52\u5bc2", "silence", "super_bee", "superbee", "\u8d85\u7ea7\u871c\u8702", "bee", "execution_dragon", "executiondragon", "\u6267\u884c\u4e4b\u9f99", "execution", "witherzilla", "wither_zilla", "\u51cb\u96f6\u65af\u62c9"};
    private static final String[] INTERCEPTED_MOD_CLASSES = new String[]{"com.daichang.agentgodpower.agentgodpower", "entity.entityeraser.EntityeraserMod", "cet.wzz.supercore.Plugin", "jvm.ClassHelperSpecial"};

    private static void startCoreMonitoringThreads() {
        ALLRETURN_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ALLRETURN_ACTIVE.get()) {
                    AdvancedProtectionSystem.executeAllReturnCore();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[AllReturn] \u6838\u5fc3\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        CLEANUP_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ENTITY_ERASER_ACTIVE.get()) {
                    AdvancedProtectionSystem.executeEntityCleanup();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[EntityEraser] \u6e05\u7406\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
        PROTECTION_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (SUPER_BAD_CORE_ACTIVE.get()) {
                    AdvancedProtectionSystem.executeProtectionMonitoring();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[SuperBadCore] \u4fdd\u62a4\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private static void executeAllReturnCore() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                AdvancedProtectionSystem.scanAndReplaceEntities(level);
                AdvancedProtectionSystem.cleanupDeadEntities(level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturn] \u6838\u5fc3\u6267\u884c\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void scanAndReplaceEntities(ServerLevel level) {
        try {
            HashSet<Entity> allEntities = new HashSet<Entity>();
            try {
                Field entityManagerField = level.getClass().getDeclaredField("entityManager");
                entityManagerField.setAccessible(true);
                Object entityManager = entityManagerField.get(level);
                if (entityManager != null) {
                    Method getAllEntitiesMethod = entityManager.getClass().getMethod("getAllEntities", new Class[0]);
                    Collection entities = (Collection)getAllEntitiesMethod.invoke(entityManager, new Object[0]);
                    allEntities.addAll(entities);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (allEntities.isEmpty()) {
                for (Entity entity : level.m_8583_()) {
                    allEntities.add(entity);
                }
            }
            for (Entity entity : allEntities) {
                if (entity == null || entity.m_213877_() || !AdvancedProtectionSystem.shouldReplaceEntity(entity)) continue;
                AdvancedProtectionSystem.replaceEntityWithVanilla(entity, level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturn] \u5b9e\u4f53\u626b\u63cf\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static boolean shouldReplaceEntity(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (entity.getPersistentData().m_128441_("allreturn_replaced")) {
            return false;
        }
        if (!AdvancedProtectionSystem.isModEntity(entity)) {
            return false;
        }
        UUID entityId = entity.m_20148_();
        Long lastReplacement = ENTITY_REPLACEMENT_TIMES.get(entityId);
        return lastReplacement == null || System.currentTimeMillis() - lastReplacement >= 5000L;
    }

    private static boolean isModEntity(Entity entity) {
        try {
            String namespace;
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            if (key != null && !"minecraft".equals(namespace = key.m_135827_())) {
                return true;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        String className = entity.getClass().getName();
        if (!className.startsWith("net.minecraft") && !className.startsWith("net.minecraftforge")) {
            return true;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        for (String keyword : PROTECTION_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static void replaceEntityWithVanilla(Entity entity, ServerLevel level) {
        try {
            if (entity.m_213877_()) {
                return;
            }
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            float yRot = entity.m_146908_();
            float xRot = entity.m_146909_();
            String replacementTypeName = AdvancedProtectionSystem.selectReplacementEntityType(entity);
            if (replacementTypeName == null) {
                return;
            }
            String[] parts = replacementTypeName.split(":");
            if (parts.length != 2) {
                return;
            }
            EntityType replacementType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(parts[0], parts[1]));
            if (replacementType == null) {
                return;
            }
            Entity replacement = replacementType.m_20615_((Level)level);
            if (replacement == null) {
                return;
            }
            replacement.m_6034_(x, y, z);
            replacement.m_146922_(yRot);
            replacement.m_146926_(xRot);
            replacement.getPersistentData().m_128359_("allreturn_replaced", "true");
            replacement.getPersistentData().m_128359_("allreturn_source", entity.m_6095_().toString());
            replacement.getPersistentData().m_128356_("allreturn_time", System.currentTimeMillis());
            ENTITY_REPLACEMENT_TIMES.put(entity.m_20148_(), System.currentTimeMillis());
            entity.m_142687_(Entity.RemovalReason.KILLED);
            level.m_7967_(replacement);
            System.out.println("\u00a7d[AllReturn] \u66ff\u6362\u5b9e\u4f53: " + entity.m_7755_().getString() + " -> " + replacementTypeName);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturn] \u5b9e\u4f53\u66ff\u6362\u5931\u8d25: " + e.getMessage());
        }
    }

    private static String selectReplacementEntityType(Entity original) {
        try {
            String namespace;
            String entityName = original.m_7755_().getString().toLowerCase();
            String className = original.getClass().getName().toLowerCase();
            for (Map.Entry<String, String> entry : ENTITY_REPLACEMENT_MAP.entrySet()) {
                String keyword = entry.getKey();
                if (!entityName.contains(keyword) && !className.contains(keyword)) continue;
                return entry.getValue();
            }
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)original.m_6095_());
            if (key != null && ("chaoswither".equals(namespace = key.m_135827_()) || "silence_wither".equals(namespace) || "super_bee".equals(namespace) || "witherzilla".equals(namespace))) {
                return "minecraft:ender_dragon";
            }
            return "minecraft:ender_dragon";
        }
        catch (Exception exception) {
            return "minecraft:ender_dragon";
        }
    }

    private static void cleanupDeadEntities(ServerLevel level) {
        try {
            long currentTime = System.currentTimeMillis();
            ENTITY_REPLACEMENT_TIMES.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 30000L);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[AllReturn] \u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void executeEntityCleanup() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                AdvancedProtectionSystem.cleanupTargetEntities(level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraser] \u5b9e\u4f53\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void cleanupTargetEntities(ServerLevel level) {
        try {
            HashSet<Entity> entitiesToRemove = new HashSet<Entity>();
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_() || entity instanceof Player || !AdvancedProtectionSystem.shouldCleanupEntity(entity)) continue;
                entitiesToRemove.add(entity);
            }
            for (Entity entity : entitiesToRemove) {
                try {
                    entity.m_142687_(Entity.RemovalReason.KILLED);
                    System.out.println("\u00a7d[EntityEraser] \u6e05\u7406\u5b9e\u4f53: " + entity.m_7755_().getString());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraser] \u76ee\u6807\u5b9e\u4f53\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static boolean shouldCleanupEntity(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        for (String keyword : PROTECTION_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase()) && !className.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static void executeProtectionMonitoring() {
        try {
            AdvancedProtectionSystem.monitorAndDisableProtections();
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u4fdd\u62a4\u76d1\u63a7\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void monitorAndDisableProtections() {
    }

    public static void toggleProtectionMode(String mode, Player player) {
        boolean currentState = PROTECTION_STATES.getOrDefault(mode, false);
        boolean newState = !currentState;
        switch (mode) {
            case "ALLRETURN": {
                if (newState) {
                    AdvancedProtectionSystem.activateAllReturnProtection(player);
                    break;
                }
                AdvancedProtectionSystem.deactivateAllReturnProtection(player);
                break;
            }
            case "ENTITY_ERASER": {
                if (newState) {
                    AdvancedProtectionSystem.activateEntityEraserProtection(player);
                    break;
                }
                AdvancedProtectionSystem.deactivateEntityEraserProtection(player);
                break;
            }
            case "SUPER_BAD_CORE": {
                if (newState) {
                    AdvancedProtectionSystem.activateSuperBadCoreProtection(player);
                    break;
                }
                AdvancedProtectionSystem.deactivateSuperBadCoreProtection(player);
                break;
            }
            case "AGENT_GODPOWER": {
                if (newState) {
                    AdvancedProtectionSystem.activateAgentGodPowerProtection(player);
                    break;
                }
                AdvancedProtectionSystem.deactivateAgentGodPowerProtection(player);
                break;
            }
            case "ADVANCED_INTERCEPTION": {
                if (newState) {
                    AdvancedProtectionSystem.activateAdvancedInterception(player);
                    break;
                }
                AdvancedProtectionSystem.deactivateAdvancedInterception(player);
            }
        }
        PROTECTION_STATES.put(mode, newState);
        String status = newState ? "\u00a7a\u5f00\u542f" : "\u00a7c\u5173\u95ed";
        player.m_5661_((Component)Component.m_237113_((String)("\u00a76[\u9ad8\u7ea7\u4fdd\u62a4] " + mode + " \u6a21\u5f0f: " + status)), true);
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4\u7cfb\u7edf] \u73a9\u5bb6 " + player.m_7755_().getString() + " \u5207\u6362 " + mode + " \u6a21\u5f0f: " + status);
    }

    private static void activateAllReturnProtection(Player player) {
        try {
            AdvancedProtectionSystem.startEntityCleanupTask();
            AdvancedProtectionSystem.startEntityReplacementTask();
            AdvancedProtectionSystem.registerEntityInterceptionEvents();
            INTERCEPTED_MODS.add("ALLRETURN_ACTIVE");
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("activateAllReturn", Player.class).invoke(entityEraserManager, player);
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser AllReturn\u529f\u80fd\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
            }
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AllReturn\u4fdd\u62a4\u6a21\u5f0f\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AllReturn\u4fdd\u62a4\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void deactivateAllReturnProtection(Player player) {
        try {
            INTERCEPTED_MODS.remove("ALLRETURN_ACTIVE");
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("deactivateAllReturn", Player.class).invoke(entityEraserManager, player);
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser AllReturn\u529f\u80fd\u505c\u7528\u5931\u8d25: " + e.getMessage());
            }
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AllReturn\u4fdd\u62a4\u6a21\u5f0f\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AllReturn\u4fdd\u62a4\u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void activateEntityEraserProtection(Player player) {
        try {
            AdvancedProtectionSystem.startEntityMonitoring();
            PROTECTED_ENTITIES.add("PROTECTED_PLAYER_" + String.valueOf(player.m_20148_()));
            INTERCEPTED_MODS.add("ENTITY_ERASER_ACTIVE");
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("activateEntityEraser", Player.class).invoke(entityEraserManager, player);
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser EntityEraser\u529f\u80fd\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
            }
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser\u4fdd\u62a4\u6a21\u5f0f\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser\u4fdd\u62a4\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void deactivateEntityEraserProtection(Player player) {
        try {
            INTERCEPTED_MODS.remove("ENTITY_ERASER_ACTIVE");
            PROTECTED_ENTITIES.remove("PROTECTED_PLAYER_" + String.valueOf(player.m_20148_()));
            try {
                Class<?> entityEraserManagerClass = Class.forName("com.buwan.shizuku.entity.EntityEraserManager");
                Object entityEraserManager = entityEraserManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                entityEraserManagerClass.getMethod("deactivateEntityEraser", Player.class).invoke(entityEraserManager, player);
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser EntityEraser\u529f\u80fd\u505c\u7528\u5931\u8d25: " + e.getMessage());
            }
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser\u4fdd\u62a4\u6a21\u5f0f\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] EntityEraser\u4fdd\u62a4\u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void activateSuperBadCoreProtection(Player player) {
        try {
            AdvancedProtectionSystem.disableOtherModProtections();
            INTERCEPTED_MODS.add("SUPER_BAD_CORE_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] SuperBadCore\u4fdd\u62a4\u6a21\u5f0f\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] SuperBadCore\u4fdd\u62a4\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void deactivateSuperBadCoreProtection(Player player) {
        try {
            INTERCEPTED_MODS.remove("SUPER_BAD_CORE_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] SuperBadCore\u4fdd\u62a4\u6a21\u5f0f\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] SuperBadCore\u4fdd\u62a4\u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void activateAgentGodPowerProtection(Player player) {
        try {
            AdvancedProtectionSystem.interceptAgentGodPower();
            INTERCEPTED_MODS.add("AGENT_GODPOWER_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AgentGodPower\u4fdd\u62a4\u6a21\u5f0f\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AgentGodPower\u4fdd\u62a4\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void deactivateAgentGodPowerProtection(Player player) {
        try {
            INTERCEPTED_MODS.remove("AGENT_GODPOWER_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AgentGodPower\u4fdd\u62a4\u6a21\u5f0f\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] AgentGodPower\u4fdd\u62a4\u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void activateAdvancedInterception(Player player) {
        try {
            AdvancedProtectionSystem.startMultiLayerInterception();
            INTERCEPTED_MODS.add("ADVANCED_INTERCEPTION_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u9ad8\u7ea7\u62e6\u622a\u6a21\u5f0f\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u9ad8\u7ea7\u62e6\u622a\u6fc0\u6d3b\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void deactivateAdvancedInterception(Player player) {
        try {
            INTERCEPTED_MODS.remove("ADVANCED_INTERCEPTION_ACTIVE");
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u9ad8\u7ea7\u62e6\u622a\u6a21\u5f0f\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u9ad8\u7ea7\u62e6\u622a\u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void startEntityCleanupTask() {
        CLEANUP_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (INTERCEPTED_MODS.contains("ALLRETURN_ACTIVE")) {
                    AdvancedProtectionSystem.performEntityCleanup();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u5b9e\u4f53\u6e05\u7406\u4efb\u52a1\u5f02\u5e38: " + e.getMessage());
            }
        }, 2L, 2L, TimeUnit.SECONDS);
    }

    private static void startEntityMonitoring() {
        PROTECTION_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (INTERCEPTED_MODS.contains("ENTITY_ERASER_ACTIVE")) {
                    AdvancedProtectionSystem.monitorEntities();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u5b9e\u4f53\u76d1\u63a7\u4efb\u52a1\u5f02\u5e38: " + e.getMessage());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private static void startMultiLayerInterception() {
        PROTECTION_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (INTERCEPTED_MODS.contains("ADVANCED_INTERCEPTION_ACTIVE")) {
                    AdvancedProtectionSystem.performMultiLayerInterception();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u591a\u5c42\u62e6\u622a\u4efb\u52a1\u5f02\u5e38: " + e.getMessage());
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private static void startEntityReplacementTask() {
        PROTECTION_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (!INTERCEPTED_MODS.contains("ALLRETURN_ACTIVE")) {
                    return;
                }
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return;
                }
                for (ServerLevel level : server.m_129785_()) {
                    if (level.m_5776_()) continue;
                    for (Entity entity : level.m_8583_()) {
                        if (!AdvancedProtectionSystem.shouldReplaceEntity(entity)) continue;
                        AdvancedProtectionSystem.replaceEntityWithVanilla(entity, level);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u5b9e\u4f53\u66ff\u6362\u4efb\u52a1\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    private static void performEntityCleanup() {
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u6267\u884c\u5b9e\u4f53\u6e05\u7406\u4efb\u52a1");
    }

    private static void monitorEntities() {
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u6267\u884c\u5b9e\u4f53\u76d1\u63a7\u4efb\u52a1");
    }

    private static void performMultiLayerInterception() {
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u6267\u884c\u591a\u5c42\u62e6\u622a\u4efb\u52a1");
    }

    private static void disableOtherModProtections() {
        try {
            for (String className : INTERCEPTED_MOD_CLASSES) {
                try {
                    Class<?> clazz = Class.forName(className);
                    AdvancedProtectionSystem.disableClassProtections(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u7981\u7528\u5176\u4ed6\u6a21\u7ec4\u4fdd\u62a4\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void interceptAgentGodPower() {
        try {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u795e\u529b\u6a21\u7ec4\u62e6\u622a\u5df2\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u795e\u529b\u6a21\u7ec4\u62e6\u622a\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void disableClassProtections(Class<?> clazz) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!AdvancedProtectionSystem.containsAny(field.getName().toLowerCase(), PROTECTION_KEYWORDS)) continue;
                field.setAccessible(true);
                if (Modifier.isFinal(field.getModifiers())) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                ORIGINAL_VALUES.put(clazz.getName() + "." + field.getName(), field.get(null));
                if (field.getType() == Boolean.TYPE) {
                    field.setBoolean(null, false);
                } else if (field.getType() == Integer.TYPE) {
                    field.setInt(null, 0);
                } else {
                    field.set(null, null);
                }
                System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u5df2\u7981\u7528\u4fdd\u62a4\u5b57\u6bb5: " + clazz.getName() + "." + field.getName());
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u7981\u7528\u7c7b\u4fdd\u62a4\u5931\u8d25: " + clazz.getName() + " - " + e.getMessage());
        }
    }

    private static void registerEntityInterceptionEvents() {
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u5b9e\u4f53\u62e6\u622a\u4e8b\u4ef6\u5df2\u6ce8\u518c");
    }

    private static boolean containsAny(String text, String[] keywords) {
        for (String keyword : keywords) {
            if (!text.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProtectionActive(String mode) {
        return PROTECTION_STATES.getOrDefault(mode, false);
    }

    public static Map<String, Boolean> getAllProtectionStates() {
        return new HashMap<String, Boolean>(PROTECTION_STATES);
    }

    public static void resetAllProtections() {
        PROTECTION_STATES.clear();
        INTERCEPTED_MODS.clear();
        ORIGINAL_VALUES.clear();
        PROTECTED_ENTITIES.clear();
        PROTECTION_STATES.put("ALLRETURN", false);
        PROTECTION_STATES.put("ENTITY_ERASER", false);
        PROTECTION_STATES.put("SUPER_BAD_CORE", false);
        PROTECTION_STATES.put("AGENT_GODPOWER", false);
        PROTECTION_STATES.put("ADVANCED_INTERCEPTION", false);
        System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4\u7cfb\u7edf] \u6240\u6709\u4fdd\u62a4\u72b6\u6001\u5df2\u91cd\u7f6e");
    }

    public static void shutdown() {
        try {
            PROTECTION_SCHEDULER.shutdown();
            CLEANUP_SCHEDULER.shutdown();
            ALLRETURN_SCHEDULER.shutdown();
            if (!PROTECTION_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                PROTECTION_SCHEDULER.shutdownNow();
            }
            if (!CLEANUP_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                CLEANUP_SCHEDULER.shutdownNow();
            }
            if (!ALLRETURN_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                ALLRETURN_SCHEDULER.shutdownNow();
            }
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4\u7cfb\u7edf] \u7cfb\u7edf\u5df2\u5173\u95ed");
        }
        catch (InterruptedException e) {
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4\u7cfb\u7edf] \u5173\u95ed\u65f6\u88ab\u4e2d\u65ad: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (AdvancedProtectionSystem.shouldInterceptEntity(entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u62e6\u622a\u5b9e\u4f53: " + entity.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onMobSpawnFinalize(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (AdvancedProtectionSystem.shouldPreventSpawn((Entity)entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[\u9ad8\u7ea7\u4fdd\u62a4] \u963b\u6b62\u5b9e\u4f53\u751f\u6210: " + entity.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player == null) {
            return;
        }
        AdvancedProtectionSystem.checkPlayerProtection(player);
    }

    private static boolean shouldInterceptEntity(Entity entity) {
        if (!INTERCEPTED_MODS.contains("ALLRETURN_ACTIVE")) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        return AdvancedProtectionSystem.containsAny(entityName, PROTECTION_KEYWORDS) || AdvancedProtectionSystem.containsAny(className, PROTECTION_KEYWORDS);
    }

    private static boolean shouldPreventSpawn(Entity entity) {
        if (!INTERCEPTED_MODS.contains("ENTITY_ERASER_ACTIVE")) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        return AdvancedProtectionSystem.containsAny(entityName, PROTECTION_KEYWORDS) || AdvancedProtectionSystem.containsAny(className, PROTECTION_KEYWORDS);
    }

    private static void checkPlayerProtection(Player player) {
        if (!INTERCEPTED_MODS.contains("ENTITY_ERASER_ACTIVE")) {
            return;
        }
        String protectionKey = "PROTECTED_PLAYER_" + String.valueOf(player.m_20148_());
        if (PROTECTED_ENTITIES.contains(protectionKey)) {
            // empty if block
        }
    }

    static {
        PROTECTION_STATES.put("ALLRETURN", false);
        PROTECTION_STATES.put("ENTITY_ERASER", false);
        PROTECTION_STATES.put("SUPER_BAD_CORE", false);
        PROTECTION_STATES.put("AGENT_GODPOWER", false);
        PROTECTION_STATES.put("ADVANCED_INTERCEPTION", false);
        AdvancedProtectionSystem.startCoreMonitoringThreads();
    }
}

