/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SuperBadCoreIntegration {
    private static final Set<String> INTERCEPTED_MODS = ConcurrentHashMap.newKeySet();
    private static final Map<String, Object> ORIGINAL_VALUES = new ConcurrentHashMap<String, Object>();
    private static final Set<String> PROTECTED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final String[] PROTECTION_KEYWORDS = new String[]{"protection", "immune", "invulnerable", "shield", "guard", "block", "resist"};

    public static void performSuperInterception(Player player) {
        try {
            SuperBadCoreIntegration.disableCoreProtections();
            SuperBadCoreIntegration.interceptModProtections();
            SuperBadCoreIntegration.resetAllProtections();
            INTERCEPTED_MODS.add("SUPER_INTERCEPTION_ACTIVE");
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7d[Shizuku] \u8d85\u7ea7\u62e6\u622a\u5df2\u6fc0\u6d3b\uff01\u6240\u6709\u4fdd\u62a4\u673a\u5236\u5df2\u7981\u7528\uff01"), true);
            System.out.println("\u00a7d[SuperBadCore] \u8d85\u7ea7\u62e6\u622a\u6210\u529f\u6fc0\u6d3b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u8d85\u7ea7\u62e6\u622a\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void disableCoreProtections() {
        try {
            String[] protectionClasses;
            for (String className : protectionClasses = new String[]{"org.spongepowered.asm.launch.MixinBootstrap", "org.spongepowered.asm.mixin.MixinEnvironment", "net.minecraftforge.fml.loading.FMLLoader"}) {
                try {
                    Field[] fields;
                    Class<?> protectionClass = Class.forName(className);
                    for (Field field : fields = protectionClass.getDeclaredFields()) {
                        String fieldName = field.getName().toLowerCase();
                        if (!SuperBadCoreIntegration.containsAny(fieldName, PROTECTION_KEYWORDS)) continue;
                        field.setAccessible(true);
                        if (!Modifier.isStatic(field.getModifiers())) continue;
                        ORIGINAL_VALUES.put(className + "." + field.getName(), field.get(null));
                        field.set(null, null);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u6838\u5fc3\u4fdd\u62a4\u7981\u7528\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void interceptModProtections() {
        try {
            SuperBadCoreIntegration.interceptKnownProtectionClasses();
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u6a21\u7ec4\u4fdd\u62a4\u62e6\u622a\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void interceptKnownProtectionClasses() {
        try {
            String[] knownProtectionClasses = new String[]{"com.example.witherzilla.WitherzillaEntity", "com.example.chaos.ChaosBossEntity", "com.example.titan.TitanBossEntity", "kakiku.pig2mod.entity.Pig2"};
            int interceptedCount = 0;
            for (String className : knownProtectionClasses) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!SuperBadCoreIntegration.interceptClassProtection(clazz)) continue;
                    ++interceptedCount;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            System.out.println("\u00a7d[SuperBadCore] \u62e6\u622a\u4e86 " + interceptedCount + " \u4e2a\u5df2\u77e5\u4fdd\u62a4\u7c7b");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u5df2\u77e5\u4fdd\u62a4\u7c7b\u62e6\u622a\u5931\u8d25: " + e.getMessage());
        }
    }

    private static boolean shouldInterceptClass(Class<?> clazz) {
        String className = clazz.getName().toLowerCase();
        if (className.startsWith("net.minecraft") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.buwan.shizuku")) {
            return false;
        }
        return SuperBadCoreIntegration.containsAny(className, PROTECTION_KEYWORDS);
    }

    private static boolean interceptClassProtection(Class<?> clazz) {
        try {
            Field[] fields;
            boolean intercepted = false;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName = field.getName().toLowerCase();
                if (!SuperBadCoreIntegration.containsAny(fieldName, PROTECTION_KEYWORDS)) continue;
                field.setAccessible(true);
                if (!Modifier.isStatic(field.getModifiers())) continue;
                ORIGINAL_VALUES.put(clazz.getName() + "." + field.getName(), field.get(null));
                Class<?> fieldType = field.getType();
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    field.set(null, false);
                } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                    field.set(null, 0);
                } else if (fieldType == Float.TYPE || fieldType == Float.class) {
                    field.set(null, Float.valueOf(0.0f));
                } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                    field.set(null, 0.0);
                } else {
                    field.set(null, null);
                }
                intercepted = true;
            }
            return intercepted;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void resetAllProtections() {
        try {
            PROTECTED_ENTITIES.clear();
            for (Map.Entry<String, Object> entry : ORIGINAL_VALUES.entrySet()) {
                try {
                    String[] parts = entry.getKey().split("\\.");
                    String className = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, parts.length - 1));
                    String fieldName = parts[parts.length - 1];
                    Class<?> clazz = Class.forName(className);
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(null, entry.getValue());
                }
                catch (Exception exception) {}
            }
            ORIGINAL_VALUES.clear();
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u4fdd\u62a4\u91cd\u7f6e\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void forceRemoveEntityProtection(LivingEntity entity) {
        try {
            String entityName = entity.m_7755_().getString().toLowerCase();
            String className = entity.getClass().getName().toLowerCase();
            if (SuperBadCoreIntegration.containsAny(entityName, PROTECTION_KEYWORDS) || SuperBadCoreIntegration.containsAny(className, PROTECTION_KEYWORDS)) {
                Field[] fields;
                PROTECTED_ENTITIES.add(entity.m_20148_().toString());
                Class<?> entityClass = entity.getClass();
                for (Field field : fields = entityClass.getDeclaredFields()) {
                    String fieldName = field.getName().toLowerCase();
                    if (!SuperBadCoreIntegration.containsAny(fieldName, PROTECTION_KEYWORDS)) continue;
                    field.setAccessible(true);
                    try {
                        Class<?> fieldType = field.getType();
                        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                            field.set(entity, false);
                            continue;
                        }
                        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                            field.set(entity, 0);
                            continue;
                        }
                        if (fieldType == Float.TYPE || fieldType == Float.class) {
                            field.set(entity, Float.valueOf(0.0f));
                            continue;
                        }
                        if (fieldType != Double.TYPE && fieldType != Double.class) continue;
                        field.set(entity, 0.0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println("\u00a7d[SuperBadCore] \u5f3a\u5236\u79fb\u9664\u5b9e\u4f53\u4fdd\u62a4: " + entity.m_7755_().getString());
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[SuperBadCore] \u5b9e\u4f53\u4fdd\u62a4\u79fb\u9664\u5931\u8d25: " + e.getMessage());
        }
    }

    private static boolean containsAny(String text, String[] keywords) {
        for (String keyword : keywords) {
            if (!text.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterceptionActive() {
        return INTERCEPTED_MODS.contains("SUPER_INTERCEPTION_ACTIVE");
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.getServer().m_129921_() % 1000 == 0) {
            SuperBadCoreIntegration.resetAllProtections();
            System.out.println("\u00a7d[SuperBadCore] \u5b9a\u671f\u6e05\u7406\u5b8c\u6210");
        }
    }
}

