/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.entity.eraserservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEraserService {
    private static final AtomicBoolean SERVICE_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ENTITY_ERASER_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean ALLRETURN_ACTIVE = new AtomicBoolean(false);
    private static final Set<UUID> ERASED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> PROTECTED_ENTITIES = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> ENTITY_ERASURE_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, String> ENTITY_ERASURE_REASONS = new ConcurrentHashMap<UUID, String>();
    private static final ScheduledExecutorService ENTITY_ERASER_SCHEDULER = Executors.newScheduledThreadPool(2);
    private static final ScheduledExecutorService ALLRETURN_SCHEDULER = Executors.newScheduledThreadPool(2);
    private static final String[] ERASURE_KEYWORDS = new String[]{"agentgodpower", "agent_godpower", "\u795e\u529b", "\u62e6\u622a", "chaoswither", "chaos_wither", "\u6df7\u6c8c\u51cb\u96f6", "chaos", "silence_wither", "silencewither", "\u5f52\u5bc2", "silence", "super_bee", "superbee", "\u8d85\u7ea7\u871c\u8702", "bee", "execution_dragon", "executiondragon", "\u6267\u884c\u4e4b\u9f99", "execution", "witherzilla", "wither_zilla", "\u51cb\u96f6\u65af\u62c9"};
    private static final Map<String, String> ENTITY_REPLACEMENT_MAP = Map.of("wither", "minecraft:ender_dragon", "\u51cb\u96f6", "minecraft:ender_dragon", "dragon", "minecraft:ender_dragon", "\u9f99", "minecraft:ender_dragon", "boss", "minecraft:wither", "chaos", "minecraft:ender_dragon", "\u6df7\u6c8c", "minecraft:ender_dragon", "silence", "minecraft:ender_dragon", "\u5f52\u5bc2", "minecraft:ender_dragon");
    private static volatile EntityEraserService instance;

    private EntityEraserService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntityEraserService getInstance() {
        if (instance != null) return instance;
        Class<EntityEraserService> clazz = EntityEraserService.class;
        synchronized (EntityEraserService.class) {
            if (instance != null) return instance;
            instance = new EntityEraserService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        if (SERVICE_ACTIVE.compareAndSet(false, true)) {
            this.startCoreThreads();
            MinecraftForge.EVENT_BUS.register((Object)this);
            ENTITY_ERASER_ACTIVE.set(false);
            ALLRETURN_ACTIVE.set(false);
            System.out.println("\u00a7d[EntityEraserService] \u670d\u52a1\u5df2\u521d\u59cb\u5316\uff08\u529f\u80fd\u672a\u81ea\u52a8\u6fc0\u6d3b\uff09");
        }
    }

    private void startCoreThreads() {
        ENTITY_ERASER_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ENTITY_ERASER_ACTIVE.get()) {
                    this.executeEntityEraserCore();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[EntityEraserService] \u6838\u5fc3\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
        ALLRETURN_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                if (ALLRETURN_ACTIVE.get()) {
                    this.executeAllReturnCore();
                }
            }
            catch (Exception e) {
                System.out.println("\u00a7d[EntityEraserService] \u6838\u5fc3\u7ebf\u7a0b\u5f02\u5e38: " + e.getMessage());
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private void executeEntityEraserCore() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                this.scanAndEraseEntities(level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u6838\u5fc3\u6267\u884c\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void executeAllReturnCore() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            for (ServerLevel level : server.m_129785_()) {
                if (level.m_5776_()) continue;
                this.scanAndReplaceEntities(level);
                this.cleanupDeadEntities(level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u6838\u5fc3\u6267\u884c\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void scanAndEraseEntities(ServerLevel level) {
        try {
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_() || !this.shouldEraseEntity(entity)) continue;
                this.eraseEntity(entity, level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u5b9e\u4f53\u626b\u63cf\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void scanAndReplaceEntities(ServerLevel level) {
        try {
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_() || !this.shouldReplaceEntity(entity)) continue;
                this.replaceEntityWithVanilla(entity, level);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u5b9e\u4f53\u626b\u63cf\u5f02\u5e38: " + e.getMessage());
        }
    }

    private boolean shouldEraseEntity(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (ERASED_ENTITIES.contains(entity.m_20148_())) {
            return false;
        }
        if (!this.isModEntity(entity)) {
            return false;
        }
        UUID entityId = entity.m_20148_();
        Long lastErasure = ENTITY_ERASURE_TIMES.get(entityId);
        return lastErasure == null || System.currentTimeMillis() - lastErasure >= 3000L;
    }

    private boolean shouldReplaceEntity(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (entity.getPersistentData().m_128441_("allreturn_replaced")) {
            return false;
        }
        return this.isModEntity(entity);
    }

    private boolean isModEntity(Entity entity) {
        try {
            String namespace;
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            if (key != null && !"minecraft".equals(namespace = key.m_135827_())) {
                return true;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        String className = entity.getClass().getName();
        if (!className.startsWith("net.minecraft") && !className.startsWith("net.minecraftforge")) {
            return true;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        for (String keyword : ERASURE_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void eraseEntity(Entity entity, ServerLevel level) {
        try {
            if (entity.m_213877_()) {
                return;
            }
            ENTITY_ERASURE_TIMES.put(entity.m_20148_(), System.currentTimeMillis());
            String reason = this.determineErasureReason(entity);
            ENTITY_ERASURE_REASONS.put(entity.m_20148_(), reason);
            ERASED_ENTITIES.add(entity.m_20148_());
            entity.m_142687_(Entity.RemovalReason.KILLED);
            System.out.println("\u00a7d[EntityEraserService] \u64e6\u9664\u5b9e\u4f53: " + entity.m_7755_().getString() + " (\u539f\u56e0: " + reason + ")");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u5b9e\u4f53\u64e6\u9664\u5931\u8d25: " + e.getMessage());
        }
    }

    private String determineErasureReason(Entity entity) {
        try {
            String entityName = entity.m_7755_().getString().toLowerCase();
            String className = entity.getClass().getName().toLowerCase();
            for (String keyword : ERASURE_KEYWORDS) {
                if (!entityName.contains(keyword.toLowerCase()) && !className.contains(keyword.toLowerCase())) continue;
                return "\u5173\u952e\u8bcd\u5339\u914d: " + keyword;
            }
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            if (key != null && !"minecraft".equals(key.m_135827_())) {
                return "\u6a21\u7ec4\u5b9e\u4f53: " + key.m_135827_();
            }
            return "\u672a\u77e5\u539f\u56e0";
        }
        catch (Exception e) {
            return "\u68c0\u67e5\u5931\u8d25";
        }
    }

    private void replaceEntityWithVanilla(Entity entity, ServerLevel level) {
        try {
            if (entity.m_213877_()) {
                return;
            }
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            float yRot = entity.m_146908_();
            float xRot = entity.m_146909_();
            String replacementTypeName = this.selectReplacementEntityType(entity);
            if (replacementTypeName == null) {
                return;
            }
            String[] parts = replacementTypeName.split(":");
            if (parts.length != 2) {
                return;
            }
            EntityType replacementType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(parts[0], parts[1]));
            if (replacementType == null) {
                return;
            }
            Entity replacement = replacementType.m_20615_((Level)level);
            if (replacement == null) {
                return;
            }
            replacement.m_6034_(x, y, z);
            replacement.m_146922_(yRot);
            replacement.m_146926_(xRot);
            replacement.getPersistentData().m_128359_("allreturn_replaced", "true");
            replacement.getPersistentData().m_128359_("allreturn_source", entity.m_6095_().toString());
            replacement.getPersistentData().m_128356_("allreturn_time", System.currentTimeMillis());
            entity.m_142687_(Entity.RemovalReason.KILLED);
            level.m_7967_(replacement);
            System.out.println("\u00a7d[EntityEraserService] \u66ff\u6362\u5b9e\u4f53: " + entity.m_7755_().getString() + " -> " + replacementTypeName);
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u5b9e\u4f53\u66ff\u6362\u5931\u8d25: " + e.getMessage());
        }
    }

    private String selectReplacementEntityType(Entity original) {
        try {
            String namespace;
            String entityName = original.m_7755_().getString().toLowerCase();
            String className = original.getClass().getName().toLowerCase();
            for (Map.Entry<String, String> entry : ENTITY_REPLACEMENT_MAP.entrySet()) {
                String keyword = entry.getKey();
                if (!entityName.contains(keyword) && !className.contains(keyword)) continue;
                return entry.getValue();
            }
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)original.m_6095_());
            if (key != null && ("chaoswither".equals(namespace = key.m_135827_()) || "silence_wither".equals(namespace) || "super_bee".equals(namespace) || "witherzilla".equals(namespace))) {
                return "minecraft:ender_dragon";
            }
            return "minecraft:ender_dragon";
        }
        catch (Exception e) {
            return "minecraft:ender_dragon";
        }
    }

    private void cleanupDeadEntities(ServerLevel level) {
        try {
            for (Entity entity : level.m_8583_()) {
                if (entity == null || entity.m_213877_() || !this.shouldCleanupEntity(entity)) continue;
                entity.m_142687_(Entity.RemovalReason.KILLED);
                System.out.println("\u00a7d[EntityEraserService] \u6e05\u7406\u6b7b\u4ea1\u5b9e\u4f53: " + entity.m_7755_().getString());
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[EntityEraserService] \u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406\u5f02\u5e38: " + e.getMessage());
        }
    }

    private boolean shouldCleanupEntity(Entity entity) {
        LivingEntity living;
        if (entity == null || entity.m_213877_()) {
            return false;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21224_()) {
            return true;
        }
        return ERASED_ENTITIES.contains(entity.m_20148_());
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.shouldInterceptEntity(entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[EntityEraserService] \u62e6\u622a\u5b9e\u4f53: " + entity.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public void onMobSpawnFinalize(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.shouldPreventSpawn((Entity)entity)) {
            event.setCanceled(true);
            System.out.println("\u00a7d[EntityEraserService] \u963b\u6b62\u5b9e\u4f53\u751f\u6210: " + entity.m_7755_().getString());
        }
    }

    private boolean shouldInterceptEntity(Entity entity) {
        if (!ALLRETURN_ACTIVE.get()) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        for (String keyword : ERASURE_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase()) && !className.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldPreventSpawn(Entity entity) {
        if (!ENTITY_ERASER_ACTIVE.get()) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        for (String keyword : ERASURE_KEYWORDS) {
            if (!entityName.contains(keyword.toLowerCase()) && !className.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void activateEntityEraser() {
        ENTITY_ERASER_ACTIVE.set(true);
        System.out.println("\u00a7d[EntityEraserService] EntityEraser\u529f\u80fd\u5df2\u6fc0\u6d3b");
    }

    public void deactivateEntityEraser() {
        ENTITY_ERASER_ACTIVE.set(false);
        System.out.println("\u00a7d[EntityEraserService] EntityEraser\u529f\u80fd\u5df2\u505c\u7528");
    }

    public void activateAllReturn() {
        ALLRETURN_ACTIVE.set(true);
        System.out.println("\u00a7d[EntityEraserService] AllReturn\u529f\u80fd\u5df2\u6fc0\u6d3b");
    }

    public void deactivateAllReturn() {
        ALLRETURN_ACTIVE.set(false);
        System.out.println("\u00a7d[EntityEraserService] AllReturn\u529f\u80fd\u5df2\u505c\u7528");
    }

    public boolean isEntityEraserActive() {
        return ENTITY_ERASER_ACTIVE.get();
    }

    public boolean isAllReturnActive() {
        return ALLRETURN_ACTIVE.get();
    }

    public boolean isServiceActive() {
        return SERVICE_ACTIVE.get();
    }

    public Map<String, Object> getErasureStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("erased_count", ERASED_ENTITIES.size());
        stats.put("protected_count", PROTECTED_ENTITIES.size());
        stats.put("entity_eraser_active", ENTITY_ERASER_ACTIVE.get());
        stats.put("allreturn_active", ALLRETURN_ACTIVE.get());
        stats.put("service_active", SERVICE_ACTIVE.get());
        return stats;
    }

    public void resetAllFeatures() {
        ENTITY_ERASER_ACTIVE.set(false);
        ALLRETURN_ACTIVE.set(false);
        ERASED_ENTITIES.clear();
        PROTECTED_ENTITIES.clear();
        ENTITY_ERASURE_TIMES.clear();
        ENTITY_ERASURE_REASONS.clear();
        System.out.println("\u00a7d[EntityEraserService] \u6240\u6709\u529f\u80fd\u5df2\u91cd\u7f6e");
    }

    public void shutdown() {
        try {
            SERVICE_ACTIVE.set(false);
            ENTITY_ERASER_ACTIVE.set(false);
            ALLRETURN_ACTIVE.set(false);
            ENTITY_ERASER_SCHEDULER.shutdown();
            ALLRETURN_SCHEDULER.shutdown();
            if (!ENTITY_ERASER_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                ENTITY_ERASER_SCHEDULER.shutdownNow();
            }
            if (!ALLRETURN_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS)) {
                ALLRETURN_SCHEDULER.shutdownNow();
            }
            System.out.println("\u00a7d[EntityEraserService] \u670d\u52a1\u5df2\u5173\u95ed");
        }
        catch (InterruptedException e) {
            System.out.println("\u00a7d[EntityEraserService] \u5173\u95ed\u65f6\u88ab\u4e2d\u65ad: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
    }
}

