/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.Unsafe;

public class ClassHelperSpecial {
    public static final boolean isHotspotJVM;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isMac;
    public static final int version;
    public static final MethodHandles.Lookup lookup;
    public static final Unsafe unsafe;
    private static final AtomicBoolean initialized;

    public static Class<?> findLoadedClass(ClassLoader loader, String name) {
        try {
            if (loader == null) {
                return Class.forName(name, false, null);
            }
            Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
            return (Class)findLoadedClass.invoke((Object)loader, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> defineClass(String name, byte[] data, ClassLoader loader) {
        return ClassHelperSpecial.defineClass(name, data, 0, data.length, loader, null);
    }

    public static Class<?> defineClass(String name, byte[] data, int offset, int length, ClassLoader loader, ProtectionDomain protectionDomain) {
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClass.setAccessible(true);
            return (Class)defineClass.invoke((Object)loader, name, data, offset, length, protectionDomain);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to define class: " + name, e);
        }
    }

    public static Class<?> defineClassBypassAgent(String name, Class<?> sourceClass, boolean initialize, ProtectionDomain protectionDomain) {
        try {
            byte[] classData = ClassHelperSpecial.getClassBytes(sourceClass);
            if (classData == null) {
                throw new RuntimeException("Cannot get class bytes for: " + sourceClass.getName());
            }
            return ClassHelperSpecial.defineClass(name, classData, 0, classData.length, sourceClass.getClassLoader(), protectionDomain);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to define class bypass agent: " + name, e);
        }
    }

    public static byte[] getClassBytes(Class<?> clazz) {
        try {
            int bytesRead;
            String resourceName = clazz.getName().replace('.', '/') + ".class";
            InputStream is = clazz.getClassLoader().getResourceAsStream(resourceName);
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            is.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSuperName(byte[] classData) {
        try {
            return "java.lang.Object";
        }
        catch (Exception e) {
            return "java.lang.Object";
        }
    }

    public static String[] getInterfaceNames(byte[] classData) {
        try {
            return new String[0];
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static void setClassPointer(Object obj, Class<?> targetClass) {
        if (unsafe == null || !isHotspotJVM) {
            return;
        }
        try {
            long l = unsafe.objectFieldOffset(Object.class.getDeclaredField("klass"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void forceSetField(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to force set field", e);
        }
    }

    public static Object forceGetField(Object obj, Field field) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to force get field", e);
        }
    }

    public static VarHandle findVarHandle(Class<?> declaringClass, String fieldName, Class<?> fieldType) {
        try {
            return lookup.findVarHandle(declaringClass, fieldName, fieldType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find VarHandle", e);
        }
    }

    public static Thread createHiddenThread(Runnable task) {
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.setName("HiddenThread-" + System.currentTimeMillis());
        return thread;
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    public static String getJVMInfo() {
        return String.format("ClassHelperSpecial: Hotspot=%s, OS=%s, Java=%d, Initialized=%s", isHotspotJVM, isWindows ? "Windows" : (isLinux ? "Linux" : (isMac ? "Mac" : "Unknown")), version, ClassHelperSpecial.isInitialized());
    }

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    public static MethodHandles.Lookup getLookup() {
        return lookup;
    }

    static {
        initialized = new AtomicBoolean(false);
        String vmName = System.getProperty("java.vm.name", "");
        isHotspotJVM = vmName.toLowerCase().contains("hotspot");
        String osName = System.getProperty("os.name", "").toLowerCase();
        isWindows = osName.contains("windows");
        isLinux = osName.contains("linux");
        isMac = osName.contains("mac");
        String javaVersion = System.getProperty("java.version", "1.8");
        version = javaVersion.startsWith("1.") ? Integer.parseInt(javaVersion.substring(2, 3)) : Integer.parseInt(javaVersion.split("\\.")[0]);
        MethodHandles.Lookup tempLookup = null;
        try {
            Field implLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookup.setAccessible(true);
            tempLookup = (MethodHandles.Lookup)implLookup.get(null);
        }
        catch (Exception e) {
            tempLookup = MethodHandles.lookup();
        }
        lookup = tempLookup;
        Unsafe tempUnsafe = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            tempUnsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Exception e) {
            tempUnsafe = null;
        }
        unsafe = tempUnsafe;
        initialized.set(true);
    }
}

